/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.kems.RSAKEMExtractor;
import org.bouncycastle.crypto.kems.RSAKEMGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.util.test.SimpleTest;

public class RSAKeyEncapsulationTest
extends SimpleTest {
    public String getName() {
        return "RSAKeyEncapsulation";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new RSAKeyEncapsulationTest());
    }

    public void performTest() throws Exception {
        RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
        rSAKeyPairGenerator.init(new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), new SecureRandom(), 1024, 5));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = rSAKeyPairGenerator.generateKeyPair();
        KDF2BytesGenerator kDF2BytesGenerator = new KDF2BytesGenerator(new SHA1Digest());
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[128];
        RSAKEMGenerator rSAKEMGenerator = new RSAKEMGenerator(16, kDF2BytesGenerator, secureRandom);
        SecretWithEncapsulation secretWithEncapsulation = rSAKEMGenerator.generateEncapsulated(asymmetricCipherKeyPair.getPublic());
        KeyParameter keyParameter = new KeyParameter(secretWithEncapsulation.getSecret());
        RSAKEMExtractor rSAKEMExtractor = new RSAKEMExtractor((RSAKeyParameters)asymmetricCipherKeyPair.getPrivate(), 16, kDF2BytesGenerator);
        KeyParameter keyParameter2 = new KeyParameter(rSAKEMExtractor.extractSecret(secretWithEncapsulation.getEncapsulation()));
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed test");
        }
    }
}

