/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RFC3211WrapEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.prng.FixedSecureRandom;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class RFC3211WrapTest
extends SimpleTest {
    SecureRandom r1 = new FixedSecureRandom(Hex.decode("C436F541"));
    SecureRandom r2 = new FixedSecureRandom(Hex.decode("FA060A45"));

    private void encryptBlock(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        CBCBlockCipher cBCBlockCipher = new CBCBlockCipher(new DESEngine());
        cBCBlockCipher.init(true, new ParametersWithIV(new KeyParameter(byArray), byArray2));
        int n = 0;
        while (n < byArray3.length) {
            cBCBlockCipher.processBlock(byArray3, n, byArray3, n);
            n += 8;
        }
        int n2 = 0;
        while (n2 < byArray3.length) {
            cBCBlockCipher.processBlock(byArray3, n2, byArray3, n2);
            n2 += 8;
        }
    }

    public String getName() {
        return "RFC3211Wrap";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new RFC3211WrapTest());
    }

    public void performTest() throws Exception {
        this.wrapTest(1, new DESEngine(), Hex.decode("D1DAA78615F287E6"), Hex.decode("EFE598EF21B33D6D"), this.r1, Hex.decode("8C627C897323A2F8"), Hex.decode("B81B2565EE373CA6DEDCA26A178B0C10"));
        this.wrapTest(2, new DESedeEngine(), Hex.decode("6A8970BF68C92CAEA84A8DF28510858607126380CC47AB2D"), Hex.decode("BAF1CA7931213C4E"), this.r2, Hex.decode("8C637D887223A2F965B566EB014B0FA5D52300A3F7EA40FFFC577203C71BAF3B"), Hex.decode("C03C514ABDB9E2C5AAC038572B5E24553876B377AAFB82ECA5A9D73F8AB143D9EC74E6CAD7DB260C"));
        this.testCorruption();
        RFC3211WrapEngine rFC3211WrapEngine = new RFC3211WrapEngine(new DESEngine());
        ParametersWithIV parametersWithIV = new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]);
        byte[] byArray = new byte[16];
        try {
            rFC3211WrapEngine.init(true, parametersWithIV);
            rFC3211WrapEngine.unwrap(byArray, 0, byArray.length);
            this.fail("failed unwrap state test.");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            this.fail("unexpected exception: " + invalidCipherTextException, invalidCipherTextException);
        }
        try {
            rFC3211WrapEngine.init(false, parametersWithIV);
            rFC3211WrapEngine.wrap(byArray, 0, byArray.length);
            this.fail("failed unwrap state test.");
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            rFC3211WrapEngine.init(false, parametersWithIV);
            rFC3211WrapEngine.unwrap(byArray, 0, byArray.length / 2);
            this.fail("failed unwrap short test.");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {}
    }

    private void testChecksum(byte[] byArray, byte[] byArray2, byte[] byArray3, Wrapper wrapper) {
        block2: {
            this.encryptBlock(byArray, byArray2, byArray3);
            try {
                wrapper.unwrap(byArray3, 0, byArray3.length);
                this.fail("bad checksum not detected");
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if (invalidCipherTextException.getMessage().equals("wrapped key corrupted")) break block2;
                this.fail("wrong exception");
            }
        }
    }

    private void testCorruption() throws InvalidCipherTextException {
        byte[] byArray;
        RFC3211WrapEngine rFC3211WrapEngine;
        byte[] byArray2;
        byte[] byArray3;
        block2: {
            byArray3 = Hex.decode("D1DAA78615F287E6");
            byArray2 = Hex.decode("EFE598EF21B33D6D");
            rFC3211WrapEngine = new RFC3211WrapEngine(new DESEngine());
            rFC3211WrapEngine.init(false, new ParametersWithIV(new KeyParameter(byArray3), byArray2));
            byArray = Hex.decode("ff739D838C627C897323A2F8C436F541");
            this.encryptBlock(byArray3, byArray2, byArray);
            try {
                rFC3211WrapEngine.unwrap(byArray, 0, byArray.length);
                this.fail("bad length not detected");
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if (invalidCipherTextException.getMessage().equals("wrapped key corrupted")) break block2;
                this.fail("wrong exception on length");
            }
        }
        byArray = Hex.decode("08639D838C627C897323A2F8C436F541");
        this.testChecksum(byArray3, byArray2, byArray, rFC3211WrapEngine);
        byArray = Hex.decode("08736D838C627C897323A2F8C436F541");
        this.testChecksum(byArray3, byArray2, byArray, rFC3211WrapEngine);
        byArray = Hex.decode("08739D638C627C897323A2F8C436F541");
        this.testChecksum(byArray3, byArray2, byArray, rFC3211WrapEngine);
    }

    private void wrapTest(int n, BlockCipher blockCipher, byte[] byArray, byte[] byArray2, SecureRandom secureRandom, byte[] byArray3, byte[] byArray4) throws Exception {
        RFC3211WrapEngine rFC3211WrapEngine = new RFC3211WrapEngine(blockCipher);
        rFC3211WrapEngine.init(true, new ParametersWithRandom(new ParametersWithIV(new KeyParameter(byArray), byArray2), secureRandom));
        byte[] byArray5 = rFC3211WrapEngine.wrap(byArray3, 0, byArray3.length);
        if (!Arrays.areEqual(byArray5, byArray4)) {
            this.fail("failed wrap test " + n + " expected " + new String(Hex.encode(byArray4)) + " got " + new String(Hex.encode(byArray5)));
        }
        rFC3211WrapEngine.init(false, new ParametersWithIV(new KeyParameter(byArray), byArray2));
        byte[] byArray6 = rFC3211WrapEngine.unwrap(byArray4, 0, byArray4.length);
        if (!Arrays.areEqual(byArray6, byArray3)) {
            this.fail("rfailed unwrap test " + n + " expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray6)));
        }
    }
}

