/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.ByteArrayInputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RC2CBCParameter;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class PKCS5Test
extends SimpleTest {
    static byte[] sample1 = Base64.decode("MIIBozA9BgkqhkiG9w0BBQ0wMDAbBgkqhkiG9w0BBQwwDgQIfWBDXwLp4K4CAggAMBEGBSsOAwIHBAiaCF/AvOgQ6QSCAWDWX4BdAzCRNSQSANSuNsT5X8mWYO27mr3Y9c9LoBVXGNmYWKA77MI4967f7SmjNcgXj3xNE/jmnVz6hhsjS8E5VPT3kfyVkpdZ0lr5e9Yk2m3JWpPU7++v5zBkZmC4V/MwV/XuIs6U+vykgzMgpxQg0oZKS9zgmiZof/4dOCL0UtCDnyOSvqT7mCVIcMDIEKu8QbVlgZYBop08l60EuEU3gARUo8WsYQmODz/ldx0Z+znIT0SXVuOwc+RVItC5T/Qx+aijmmpt+9l14nmaGBrEkmuhmtdvU/4vaptewGRgmjOfD6cqK+zs0O5NrrJ3P/6ZSxXj91CQgrThGfOv72bUncXEMNtc8pks2jpHFjGMdKufnadAD7XuMgzkkaklEXZ4f5tU6heIIwr51g0GBEGF96gYPFnjnSQM75JE02Clo+DfcfXpcybPTwwFg2jd6JTTOfkdf6OdSlA/1XNK43FA");
    static byte[] sample2 = Base64.decode("MIIBpjBABgkqhkiG9w0BBQ0wMzAbBgkqhkiG9w0BBQwwDgQIeFeOWl1jywYCAggAMBQGCCqGSIb3DQMHBAjUJ5eGBhQGtQSCAWBrHrRgqO8UUMLcWzZEtpk1l3mjxiF/koCMkHsFwowgyWhEbgIkTgbSViK54LVK8PskekcGNLph+rB6bGZ7pPbL5pbXASJ8+MkQcG3FZdlS4Ek9tTJDApj3O1UubZGFG4uvTlJJFbF1BOJ3MkY3XQ9Gl1qwv7j56e103Da7Cq9+oIDKmznza78XXQYrUsPo8mJGjUxPskEYlzwvHjKubRnYm/K6RKhi5f4zX4BQ/Dt3H812ZjRXrsjAJP0KrD/jyD/jCT7zNBVPH1izBds+RwizyQAHwfNJBFR78TH4cgzB619X47FDVOnT0LqQNVd0O3cSwnPrXE9XR3tPayE+iOB15llFSmi8z0ByOXldEpkezCn92Umk++suzIVj1qfsK+bv2phZWJPbLEIWPDRHUbYf76q5ArAru4xtxT/hoK3krEs/IN3d70qjlUJ36SEw1UaZ82PWhakQbdtu39ZraMJB");
    static byte[] sample3 = Base64.decode("MIIBrjBIBgkqhkiG9w0BBQ0wOzAeBgkqhkiG9w0BBQwwEQQIrHyQPBZqWLUCAggAAgEQMBkGCCqGSIb3DQMCMA0CAToECEhbh7YZKiPSBIIBYCT1zp6o5jpFlIkgwPop7bW1+8ACr4exqzkeb3WflQ8cWJ4cURxzVdvxUnXeW1VJdaQZtjS/QHs5GhPTG/0fwtvnaPfwrIJ3FeGaZfcg2CrYhalOFmEb4xrE4KyoEQmUN8tb/Cg94uzd16BOPw21RDnE8bnPdIGY7TyL95kbkqH23mK53pi7h+xWIgduW+atIqDyyt55f7WMZcvDvlj6VpN/V0h+qxBHL274WA4dj6GYgeyUFpi60HdGCK7By2TBy8h1ZvKGjmB9h8jZvkx1MkbRumXxyFsowTZawyYvO8Um6lbfEDP9zIEUq0IV8RqH2MRyblsPNSikyYhxX/cztdDxRKhilySbSBg5Kr8OfcwKp9bpinN96nmG4xr3Tch1bnVvqJzOQ5+Vva2WwVvH2JkWvYm5WaANg4Q6bRxu9vz7DuhbJjQdZbxFezIAgrJdSe92B00jO/0Kny1WjiVO6DA=");
    static byte[] result = Hex.decode("30820155020100300d06092a864886f70d01010105000482013f3082013b020100024100debbfc2c09d61bada2a9462f24224e54cc6b3cc0755f15ce318ef57e79df17026b6a85cca12428027245045df2052a329a2f9ad3d17b78a10572ad9b22bf343b020301000102402d90a96adcec472743527bc023153d8f0d6e96b40c8ed228276d467d843306429f8670559bf376dd41857f6397c2fc8d95e0e53ed62de420b855430ee4a1b8a1022100ffcaf083823931e073ff534f06a5d415b3d414bc614a4544a3dff7ed271817eb022100deea30242117db2d3b8837f58f1da530ff83cf9283680da33683ec4e583610f1022100e6026381adb0a683f16a8f4c096b462979b9e4277cc89f3ed8a905b46fa9ff9f02210097c146d4d1d2b3dbaf53a504ff51674c5c271800de84d003f4f10ac6ab36e38102202bfa141f10bda874e1017d845e82767c1c38e82745daf421f0c8cd09d7652387");

    public String getName() {
        return "PKCS5S2";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new PKCS5Test());
    }

    public void performTest() throws Exception {
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESEngine()));
        PBETest pBETest = new PBETest(0, paddedBufferedBlockCipher, sample1, 64);
        ((SimpleTest)pBETest).performTest();
        paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()));
        pBETest = new PBETest(1, paddedBufferedBlockCipher, sample2, 192);
        ((SimpleTest)pBETest).performTest();
        paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new RC2Engine()));
        pBETest = new PBETest(2, paddedBufferedBlockCipher, sample3, 0);
        ((SimpleTest)pBETest).performTest();
        char[] cArray = new char[]{'p', 'a', 's', 's', 'w', 'o', 'r', 'd'};
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
        byte[] byArray = Hex.decode("1234567878563412");
        pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray, 5);
        if (!this.areEqual(((KeyParameter)((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(64)).getKey(), Hex.decode("d1daa78615f287e6"))) {
            this.fail("64 test failed");
        }
        cArray = "All n-entities must communicate with other n-entities via n-1 entiteeheehees".toCharArray();
        pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray, 500);
        if (!this.areEqual(((KeyParameter)((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(192)).getKey(), Hex.decode("6a8970bf68c92caea84a8df28510858607126380cc47ab2d"))) {
            this.fail("192 test failed");
        }
        pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray, 60000);
        if (!this.areEqual(((KeyParameter)((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(192)).getKey(), Hex.decode("29aaef810c12ecd2236bbcfb55407f9852b5573dc1c095bb"))) {
            this.fail("192 (60000) test failed");
        }
    }

    private static class PBETest
    extends SimpleTest {
        int id;
        BufferedBlockCipher cipher;
        byte[] sample;
        int keySize;

        PBETest(int n, BufferedBlockCipher bufferedBlockCipher, byte[] byArray, int n2) {
            this.id = n;
            this.cipher = bufferedBlockCipher;
            this.sample = byArray;
            this.keySize = n2;
        }

        public String getName() {
            return String.valueOf(this.cipher.getUnderlyingCipher().getAlgorithmName()) + " PKCS5S2 Test " + this.id;
        }

        public void performTest() {
            ParametersWithIV parametersWithIV;
            byte[] byArray;
            Object object;
            char[] cArray = new char[]{'p', 'a', 's', 's', 'w', 'o', 'r', 'd'};
            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.sample);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = null;
            try {
                encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(aSN1InputStream.readObject());
            }
            catch (Exception exception) {
                this.fail("failed construction - exception " + exception.toString(), exception);
            }
            PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(encryptedPrivateKeyInfo.getEncryptionAlgorithm().getParameters());
            PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(pBES2Parameters.getKeyDerivationFunc().getParameters());
            EncryptionScheme encryptionScheme = pBES2Parameters.getEncryptionScheme();
            if (pBKDF2Params.getKeyLength() != null) {
                this.keySize = pBKDF2Params.getKeyLength().intValue() * 8;
            }
            int n = pBKDF2Params.getIterationCount().intValue();
            byte[] byArray2 = pBKDF2Params.getSalt();
            pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray2, n);
            if (encryptionScheme.getAlgorithm().equals(PKCSObjectIdentifiers.RC2_CBC)) {
                object = RC2CBCParameter.getInstance(encryptionScheme.getParameters());
                byArray = ((RC2CBCParameter)object).getIV();
                parametersWithIV = new ParametersWithIV(((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(this.keySize), byArray);
            } else {
                object = ASN1OctetString.getInstance(encryptionScheme.getParameters()).getOctets();
                parametersWithIV = new ParametersWithIV(((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(this.keySize), (byte[])object);
            }
            this.cipher.init(false, parametersWithIV);
            object = encryptedPrivateKeyInfo.getEncryptedData();
            byArray = new byte[this.cipher.getOutputSize(((Object)object).length)];
            int n2 = this.cipher.processBytes((byte[])object, 0, ((Object)object).length, byArray, 0);
            try {
                n2 += this.cipher.doFinal(byArray, n2);
            }
            catch (Exception exception) {
                this.fail("failed doFinal - exception " + exception.toString());
            }
            if (result.length != n2) {
                this.fail("failed length");
            }
            int n3 = 0;
            while (n3 != n2) {
                if (byArray[n3] != result[n3]) {
                    this.fail("failed comparison");
                }
                ++n3;
            }
        }
    }
}

