/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.NISTCTSBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class NISTCTSTest
extends SimpleTest {
    private static KeyParameter key = new KeyParameter(Hex.decode("000102030405060708090a0b0c0d0e0f"));
    private static byte[] iv = Hex.decode("101112131415161718191a1b1c1d1e1f");
    private static byte[] singleBlock = Hex.decode("4920616d206f6e6520626c6f636b2e2e");
    private static byte[] singleOut = Hex.decode("8aad2098847a2d74ac87de22745d2537");
    private static byte[] twoBlock = Hex.decode("4920616d206174206c656173742074776f20626c6f636b73206c6f6e672e2e2e");
    private static byte[] cs1TwoBlockOut = Hex.decode("3f07fd5816c3b96349eb9f6a074909d67237eb8aa9a7467b8a388c61d0e8f35a");
    private static byte[] cs2TwoBlockOut = Hex.decode("3f07fd5816c3b96349eb9f6a074909d67237eb8aa9a7467b8a388c61d0e8f35a");
    private static byte[] cs3TwoBlockOut = Hex.decode("7237eb8aa9a7467b8a388c61d0e8f35a3f07fd5816c3b96349eb9f6a074909d6");
    private static byte[] notQuiteTwo = Hex.decode("4920616d206e6f742071756974652074776f2e2e2e");
    private static byte[] cs1NotQuiteTwoBlockOut = Hex.decode("22ecf2ac77f098097ca69b72e3a46e9ca21bb5ebbc");
    private static byte[] cs2NotQuiteTwoBlockOut = Hex.decode("f098097ca69b72e3a46e9ca21bb5ebbc22ecf2ac77");
    private static byte[] cs3NotQuiteTwoBlockOut = Hex.decode("f098097ca69b72e3a46e9ca21bb5ebbc22ecf2ac77");
    static byte[] in1 = Hex.decode("4e6f7720697320746865207420");
    static byte[] in2 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f0aaa");
    static byte[] out1 = Hex.decode("9952f131588465033fa40e8a98");
    static byte[] out2 = Hex.decode("358f84d01eb42988dc34efb994");
    static byte[] out3 = Hex.decode("170171cfad3f04530c509b0c1f0be0aefbd45a8e3755a873bff5ea198504b71683c6");

    public String getName() {
        return "NISTCTS";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new NISTCTSTest());
    }

    public void performTest() throws Exception {
        this.testCTS(1, 1, AESEngine.newInstance(), new ParametersWithIV(key, iv), singleBlock, singleOut);
        this.testCTS(2, 2, AESEngine.newInstance(), new ParametersWithIV(key, iv), singleBlock, singleOut);
        this.testCTS(3, 3, AESEngine.newInstance(), new ParametersWithIV(key, iv), singleBlock, singleOut);
        this.testCTS(4, 1, AESEngine.newInstance(), new ParametersWithIV(key, iv), twoBlock, cs1TwoBlockOut);
        this.testCTS(5, 2, AESEngine.newInstance(), new ParametersWithIV(key, iv), twoBlock, cs2TwoBlockOut);
        this.testCTS(6, 3, AESEngine.newInstance(), new ParametersWithIV(key, iv), twoBlock, cs3TwoBlockOut);
        this.testCTS(7, 1, AESEngine.newInstance(), new ParametersWithIV(key, iv), notQuiteTwo, cs1NotQuiteTwoBlockOut);
        this.testCTS(8, 2, AESEngine.newInstance(), new ParametersWithIV(key, iv), notQuiteTwo, cs2NotQuiteTwoBlockOut);
        this.testCTS(9, 3, AESEngine.newInstance(), new ParametersWithIV(key, iv), notQuiteTwo, cs3NotQuiteTwoBlockOut);
        byte[] byArray = Hex.decode("aafd12f659cae63489b479e5076ddec2f06cb58faafd12f6");
        byte[] byArray2 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");
        byte[] byArray3 = Hex.decode("6db2f802d99e1ef0a5940f306079e083cf87f4d8bb9d1abb36cdd9f44ead7d04");
        this.testCTS(10, 3, AESEngine.newInstance(), new ParametersWithIV(new KeyParameter(byArray), Hex.decode("aafd12f659cae63489b479e5076ddec2")), byArray2, byArray3);
        byte[] byArray4 = Hex.decode("aafd12f659cae63489b479e5076ddec2");
        byte[] byArray5 = Hex.decode("0af33c005a337af55a5149effc5108eaa1ea87de8a8556e8786b8f230da64e56");
        this.testCTS(11, 3, AESEngine.newInstance(), new ParametersWithIV(new KeyParameter(byArray4), Hex.decode("aafd12f659cae63489b479e5076ddec2")), byArray2, byArray5);
        this.testExceptions();
    }

    private void testCTS(int n, int n2, BlockCipher blockCipher, CipherParameters cipherParameters, byte[] byArray, byte[] byArray2) throws Exception {
        byte[] byArray3 = new byte[byArray.length];
        NISTCTSBlockCipher nISTCTSBlockCipher = new NISTCTSBlockCipher(n2, blockCipher);
        ((BufferedBlockCipher)nISTCTSBlockCipher).init(true, cipherParameters);
        int n3 = ((BufferedBlockCipher)nISTCTSBlockCipher).processBytes(byArray, 0, byArray.length, byArray3, 0);
        ((BufferedBlockCipher)nISTCTSBlockCipher).doFinal(byArray3, n3);
        if (!this.areEqual(byArray2, byArray3)) {
            this.fail(String.valueOf(n) + " failed encryption expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        ((BufferedBlockCipher)nISTCTSBlockCipher).init(false, cipherParameters);
        n3 = ((BufferedBlockCipher)nISTCTSBlockCipher).processBytes(byArray2, 0, byArray2.length, byArray3, 0);
        ((BufferedBlockCipher)nISTCTSBlockCipher).doFinal(byArray3, n3);
        if (!this.areEqual(byArray, byArray3)) {
            this.fail(String.valueOf(n) + " failed decryption expected " + new String(Hex.encode(byArray)) + " got " + new String(Hex.encode(byArray3)));
        }
    }

    private void testExceptions() throws InvalidCipherTextException {
        NISTCTSBlockCipher nISTCTSBlockCipher = new NISTCTSBlockCipher(1, AESEngine.newInstance());
        KeyParameter keyParameter = new KeyParameter(new byte[((BufferedBlockCipher)nISTCTSBlockCipher).getBlockSize()]);
        ((BufferedBlockCipher)nISTCTSBlockCipher).init(true, keyParameter);
        byte[] byArray = new byte[((BufferedBlockCipher)nISTCTSBlockCipher).getOutputSize(((BufferedBlockCipher)nISTCTSBlockCipher).getBlockSize())];
        ((BufferedBlockCipher)nISTCTSBlockCipher).processBytes(new byte[((BufferedBlockCipher)nISTCTSBlockCipher).getBlockSize() - 1], 0, ((BufferedBlockCipher)nISTCTSBlockCipher).getBlockSize() - 1, byArray, 0);
        try {
            ((BufferedBlockCipher)nISTCTSBlockCipher).doFinal(byArray, 0);
            this.fail("Expected CTS encrypt error on < 1 block input");
        }
        catch (DataLengthException dataLengthException) {}
        ((BufferedBlockCipher)nISTCTSBlockCipher).init(true, keyParameter);
        ((BufferedBlockCipher)nISTCTSBlockCipher).processBytes(new byte[((BufferedBlockCipher)nISTCTSBlockCipher).getBlockSize()], 0, ((BufferedBlockCipher)nISTCTSBlockCipher).getBlockSize(), byArray, 0);
        try {
            ((BufferedBlockCipher)nISTCTSBlockCipher).doFinal(byArray, 0);
        }
        catch (DataLengthException dataLengthException) {
            this.fail("Unexpected CTS encrypt error on == 1 block input");
        }
        ((BufferedBlockCipher)nISTCTSBlockCipher).init(false, keyParameter);
        ((BufferedBlockCipher)nISTCTSBlockCipher).processBytes(new byte[((BufferedBlockCipher)nISTCTSBlockCipher).getBlockSize() - 1], 0, ((BufferedBlockCipher)nISTCTSBlockCipher).getBlockSize() - 1, byArray, 0);
        try {
            ((BufferedBlockCipher)nISTCTSBlockCipher).doFinal(byArray, 0);
            this.fail("Expected CTS decrypt error on < 1 block input");
        }
        catch (DataLengthException dataLengthException) {}
        ((BufferedBlockCipher)nISTCTSBlockCipher).init(false, keyParameter);
        ((BufferedBlockCipher)nISTCTSBlockCipher).processBytes(new byte[((BufferedBlockCipher)nISTCTSBlockCipher).getBlockSize()], 0, ((BufferedBlockCipher)nISTCTSBlockCipher).getBlockSize(), byArray, 0);
        try {
            ((BufferedBlockCipher)nISTCTSBlockCipher).doFinal(byArray, 0);
        }
        catch (DataLengthException dataLengthException) {
            this.fail("Unexpected CTS decrypt error on == 1 block input");
        }
    }
}

