/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.LEAEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class LEATest
extends SimpleTest {
    public String getName() {
        return "LEA";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new LEATest());
    }

    public void performTest() throws Exception {
        this.testFromVectorFile();
        new LEA128Test().testTheCipher(this);
        new LEA192Test().testTheCipher(this);
        new LEA256Test().testTheCipher(this);
    }

    private static String remove(String string, String string2) {
        int n = -1;
        while ((n = string.indexOf(string2)) >= 0) {
            string = String.valueOf(string.substring(0, n)) + string.substring(n + string2.length());
        }
        return string;
    }

    void testCipher(BlockCipher blockCipher, String string, String string2, String string3) {
        byte[] byArray = new byte[blockCipher.getBlockSize()];
        byte[] byArray2 = new byte[blockCipher.getBlockSize()];
        KeyParameter keyParameter = new KeyParameter(Hex.decode(string));
        byte[] byArray3 = Hex.decode(string2);
        blockCipher.init(true, keyParameter);
        blockCipher.processBlock(byArray3, 0, byArray, 0);
        byte[] byArray4 = Hex.decode(string3);
        this.isTrue("Encryption mismatch", Arrays.areEqual(byArray4, byArray));
        blockCipher.init(false, keyParameter);
        blockCipher.processBlock(byArray, 0, byArray2, 0);
        this.isTrue("Decryption mismatch", Arrays.areEqual(byArray3, byArray2));
    }

    public void testFromVectorFile() throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(TestResourceFinder.findTestResource("crypto", "lea.txt")));
        String string2 = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            byte[] byArray5;
            BlockCipher blockCipher;
            if ((string = string.trim()).length() == 0 || string.startsWith("#")) continue;
            if (string.startsWith("Comment:")) {
                string2 = string.substring(string.indexOf(":") + 1).trim();
                continue;
            }
            if (string.startsWith("Key:")) {
                string = LEATest.remove(LEATest.remove(string, "0x"), ", ").trim();
                byArray = Hex.decode(string.substring(string.indexOf(":") + 1).trim());
                continue;
            }
            if (string.startsWith("Plaintext:")) {
                string = LEATest.remove(LEATest.remove(string, "0x"), ", ").trim();
                byArray2 = Hex.decode(string.substring(string.indexOf(":") + 1).trim());
                continue;
            }
            if (string.startsWith("Ciphertext:")) {
                string = LEATest.remove(LEATest.remove(string, "0x"), ", ").trim();
                byArray3 = Hex.decode(string.substring(string.indexOf(":") + 1).trim());
                continue;
            }
            if (string.startsWith("IV:")) {
                string = LEATest.remove(LEATest.remove(string, "0x"), ", ").trim();
                byArray4 = Hex.decode(string.substring(string.indexOf(":") + 1).trim());
                continue;
            }
            if (!string.startsWith("Test:")) continue;
            if (string2.indexOf("ECB") >= 0) {
                blockCipher = new LEAEngine();
                if (string.endsWith("Encrypt")) {
                    ((LEAEngine)blockCipher).init(true, new KeyParameter(byArray));
                    byArray5 = new byte[byArray3.length];
                    n = 0;
                    while (n < byArray5.length) {
                        n += ((LEAEngine)blockCipher).processBlock(byArray2, n, byArray5, n);
                    }
                    this.isTrue(String.valueOf(string2) + " cipher text must match vector", Arrays.areEqual(byArray5, byArray3));
                    continue;
                }
                if (!string.endsWith("Decrypt")) continue;
                ((LEAEngine)blockCipher).init(false, new KeyParameter(byArray));
                byArray5 = new byte[byArray2.length];
                n = 0;
                while (n < byArray5.length) {
                    n += ((LEAEngine)blockCipher).processBlock(byArray3, n, byArray5, n);
                }
                this.isTrue(String.valueOf(string2) + " plain text must match", Arrays.areEqual(byArray5, byArray2));
                continue;
            }
            if (string2.indexOf("CTR") >= 0 || string2.indexOf("CBC") >= 0) {
                blockCipher = string2.indexOf("CBC") >= 0 ? CBCBlockCipher.newInstance(new LEAEngine()) : SICBlockCipher.newInstance(new LEAEngine());
                if (string.endsWith("Encrypt")) {
                    blockCipher.init(true, new ParametersWithIV(new KeyParameter(byArray), byArray4));
                    byArray5 = new byte[byArray3.length];
                    n = 0;
                    while (n < byArray5.length) {
                        n += blockCipher.processBlock(byArray2, n, byArray5, n);
                    }
                    this.isTrue(String.valueOf(string2) + " cipher text must match vector", Arrays.areEqual(byArray5, byArray3));
                    continue;
                }
                if (!string.endsWith("Decrypt")) continue;
                blockCipher.init(false, new ParametersWithIV(new KeyParameter(byArray), byArray4));
                byArray5 = new byte[byArray2.length];
                n = 0;
                while (n < byArray5.length) {
                    n += blockCipher.processBlock(byArray3, n, byArray5, n);
                }
                this.isTrue(String.valueOf(string2) + " plain text must match", Arrays.areEqual(byArray5, byArray2));
                continue;
            }
            throw new IllegalStateException("unknown mode");
        }
    }

    static class LEA128Test {
        private static final String KEY = "0f1e2d3c4b5a69788796a5b4c3d2e1f0";
        private static final String TESTDATA = "101112131415161718191a1b1c1d1e1f";
        private static final String EXPECTED = "9fc84e3528c6c6185532c7a704648bfd";

        LEA128Test() {
        }

        void testTheCipher(LEATest lEATest) {
            lEATest.testCipher(new LEAEngine(), KEY, TESTDATA, EXPECTED);
        }
    }

    static class LEA192Test {
        private static final String KEY = "0f1e2d3c4b5a69788796a5b4c3d2e1f0f0e1d2c3b4a59687";
        private static final String TESTDATA = "202122232425262728292a2b2c2d2e2f";
        private static final String EXPECTED = "6fb95e325aad1b878cdcf5357674c6f2";

        LEA192Test() {
        }

        void testTheCipher(LEATest lEATest) {
            lEATest.testCipher(new LEAEngine(), KEY, TESTDATA, EXPECTED);
        }
    }

    static class LEA256Test {
        private static final String KEY = "0f1e2d3c4b5a69788796a5b4c3d2e1f0f0e1d2c3b4a5968778695a4b3c2d1e0f";
        private static final String TESTDATA = "303132333435363738393a3b3c3d3e3f";
        private static final String EXPECTED = "d651aff647b189c13a8900ca27f9e197";

        LEA256Test() {
        }

        void testTheCipher(LEATest lEATest) {
            lEATest.testCipher(new LEAEngine(), KEY, TESTDATA, EXPECTED);
        }
    }
}

