/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.macs.KMAC;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class KMACTest
extends SimpleTest {
    private void checkKMAC(int n, KMAC kMAC, byte[] byArray) {
        KMAC kMAC2 = new KMAC(n, null);
        kMAC2.init(new KeyParameter(new byte[0]));
        kMAC.init(new KeyParameter(new byte[0]));
        kMAC2.update(byArray, 0, byArray.length);
        kMAC.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        kMAC2.doFinal(byArray2, 0, byArray2.length);
        kMAC.doFinal(byArray3, 0, byArray3.length);
        this.isTrue(Arrays.areEqual(byArray2, byArray3));
    }

    private void doFinalTest() {
        KMAC kMAC = new KMAC(128, Strings.toByteArray("My Tagged Application"));
        kMAC.init(new KeyParameter(Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F")));
        kMAC.update(Hex.decode("00010203"), 0, 4);
        byte[] byArray = new byte[32];
        kMAC.doOutput(byArray, 0, byArray.length);
        this.isTrue(Hex.toHexString(byArray), Arrays.areEqual(Hex.decode("31a44527b4ed9f5c6101d11de6d26f0620aa5c341def41299657fe9df1a3b16c"), byArray));
        kMAC.doOutput(byArray, 0, byArray.length);
        this.isTrue(Arrays.areEqual(Hex.decode("31a44527b4ed9f5c6101d11de6d26f0620aa5c341def41299657fe9df1a3b16c"), byArray) ^ true);
        kMAC.doFinal(byArray, 0, byArray.length);
        kMAC.update(Hex.decode("00010203"), 0, 4);
        kMAC.doFinal(byArray, 0, byArray.length);
        this.isTrue(Arrays.areEqual(Hex.decode("3B1FBA963CD8B0B59E8C1A6D71888B7143651AF8BA0A7070C0979E2811324AA5"), byArray));
        kMAC.update(Hex.decode("00010203"), 0, 4);
        kMAC.doOutput(byArray, 0, byArray.length);
        this.isTrue(Arrays.areEqual(Hex.decode("31a44527b4ed9f5c6101d11de6d26f0620aa5c341def41299657fe9df1a3b16c"), byArray));
        kMAC.doFinal(byArray, 0, byArray.length);
        this.isTrue(Hex.toHexString(byArray), Arrays.areEqual(Hex.decode("ffcb48c7620ccd67d1c83224186892cef2f2a99278d5cfdde10e48bdc89718c2"), byArray));
    }

    public String getName() {
        return "KMAC";
    }

    private void longBlockTest() {
        KMAC kMAC;
        byte[] byArray = new byte[16000];
        byte[] byArray2 = new byte[64];
        int n = 0;
        while (n != byArray.length) {
            byArray[n] = (byte)n;
            ++n;
        }
        int n2 = 10000;
        while (n2 != byArray.length) {
            kMAC = new KMAC(128, Arrays.copyOfRange(byArray, 0, n2));
            kMAC.init(new KeyParameter(new byte[0]));
            kMAC.update(Hex.decode("00010203"), 0, 4);
            kMAC.doFinal(byArray2, 0);
            ++n2;
        }
        kMAC = new KMAC(256, new byte[200]);
        kMAC.init(new KeyParameter(new byte[0]));
        kMAC.update(Arrays.copyOfRange(byArray, 0, 200), 0, 200);
        kMAC.doFinal(byArray2, 0);
        this.isTrue(Hex.toHexString(byArray2), Arrays.areEqual(Hex.decode("f9476d9b3e42bf23307af5ccb5287fd6f033b23c400566a2ebc5829bd119aa545cd9b6bde76ef61cd31c3c0f0aaf0945f44481e863b19e9c26fb46c8b2a8a9bb"), byArray2));
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new KMACTest());
    }

    private void paddingCheckTest() {
        byte[] byArray = Hex.decode("01880204187B3E43EDA8D51EC181D37DDE5B17ECCDD8BE84C268DC6C9500700857");
        byte[] byArray2 = new byte[32];
        KMAC kMAC = new KMAC(128, new byte[0]);
        kMAC.init(new KeyParameter(new byte[163]));
        kMAC.update(byArray, 0, byArray.length);
        kMAC.doOutput(byArray2, 0, byArray2.length);
        this.isTrue("128 failed", Arrays.areEqual(byArray2, Hex.decode("6e6ab56468c7445f81c679f89f45c90a95a9c01afbaab5f7065b7e2e96f7d2bb")));
        KMAC kMAC2 = new KMAC(256, new byte[0]);
        kMAC2.init(new KeyParameter(new byte[131]));
        kMAC2.update(byArray, 0, byArray.length);
        kMAC2.doOutput(byArray2, 0, byArray2.length);
        this.isTrue("256 failed", Arrays.areEqual(byArray2, Hex.decode("f6302d4f854b4872e811b37993b6bfe027258089b6a9fbb26a755b1ebfc0d830")));
    }

    public void performTest() throws Exception {
        KMAC kMAC = new KMAC(128, Strings.toByteArray(""));
        this.isEquals("KMAC128", kMAC.getAlgorithmName());
        kMAC.init(new KeyParameter(Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F")));
        kMAC.update(Hex.decode("00010203"), 0, 4);
        byte[] byArray = new byte[32];
        kMAC.doFinal(byArray, 0, byArray.length);
        this.isTrue("oops: " + Hex.toHexString(byArray), Arrays.areEqual(Hex.decode("E5780B0D3EA6F7D3A429C5706AA43A00FADBD7D49628839E3187243F456EE14E"), byArray));
        kMAC = new KMAC(128, Strings.toByteArray("My Tagged Application"));
        kMAC.init(new KeyParameter(Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F")));
        kMAC.update(Hex.decode("00010203"), 0, 4);
        byArray = new byte[32];
        kMAC.doFinal(byArray, 0, byArray.length);
        this.isTrue("oops: " + Hex.toHexString(byArray), Arrays.areEqual(Hex.decode("3B1FBA963CD8B0B59E8C1A6D71888B7143651AF8BA0A7070C0979E2811324AA5"), byArray));
        kMAC = new KMAC(128, Strings.toByteArray("My Tagged Application"));
        kMAC.init(new KeyParameter(Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F")));
        byte[] byArray2 = Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7");
        kMAC.update(byArray2, 0, byArray2.length);
        byArray = new byte[32];
        kMAC.doFinal(byArray, 0, byArray.length);
        this.isTrue("oops:" + Hex.toHexString(byArray), Arrays.areEqual(Hex.decode("1F5B4E6CCA02209E0DCB5CA635B89A15E271ECC760071DFD805FAA38F9729230"), byArray));
        kMAC = new KMAC(256, Strings.toByteArray("My Tagged Application"));
        this.isEquals("KMAC256", kMAC.getAlgorithmName());
        kMAC.init(new KeyParameter(Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F")));
        byArray2 = Hex.decode("00 01 02 03");
        kMAC.update(byArray2, 0, byArray2.length);
        byArray = new byte[64];
        kMAC.doFinal(byArray, 0, byArray.length);
        this.isTrue("oops:" + Hex.toHexString(byArray), Arrays.areEqual(Hex.decode("20C570C31346F703C9AC36C61C03CB64C3970D0CFC787E9B79599D273A68D2F7F69D4CC3DE9D104A351689F27CF6F5951F0103F33F4F24871024D9C27773A8DD"), byArray));
        kMAC = new KMAC(256, Strings.toByteArray(""));
        kMAC.init(new KeyParameter(Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F")));
        byArray2 = Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7");
        kMAC.update(byArray2, 0, byArray2.length);
        byArray = new byte[64];
        kMAC.doFinal(byArray, 0, byArray.length);
        this.isTrue("oops:" + Hex.toHexString(byArray), Arrays.areEqual(Hex.decode("75358CF39E41494E949707927CEE0AF20A3FF553904C86B08F21CC414BCFD691589D27CF5E15369CBBFF8B9A4C2EB17800855D0235FF635DA82533EC6B759B69"), byArray));
        kMAC = new KMAC(256, Strings.toByteArray("My Tagged Application"));
        kMAC.init(new KeyParameter(Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F")));
        byArray2 = Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7");
        kMAC.update(byArray2, 0, byArray2.length);
        byArray = new byte[64];
        kMAC.doFinal(byArray, 0, byArray.length);
        this.isTrue("oops:" + Hex.toHexString(byArray), Arrays.areEqual(Hex.decode("B58618F71F92E1D56C1B8C55DDD7CD188B97B4CA4D99831EB2699A837DA2E4D970FBACFDE50033AEA585F1A2708510C32D07880801BD182898FE476876FC8965"), byArray));
        this.doFinalTest();
        this.longBlockTest();
        this.paddingCheckTest();
        this.checkKMAC(128, new KMAC(128, new byte[0]), Hex.decode("eeaabeef"));
        this.checkKMAC(256, new KMAC(256, null), Hex.decode("eeaabeef"));
        this.checkKMAC(128, new KMAC(128, new byte[0]), Hex.decode("eeaabeef"));
        this.checkKMAC(128, new KMAC(128, null), Hex.decode("eeaabeef"));
        this.checkKMAC(256, new KMAC(256, null), Hex.decode("eeaabeef"));
    }
}

