/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class HKDFGeneratorTest
extends SimpleTest {
    private void compareOKM(int n, byte[] byArray, byte[] byArray2) {
        if (!this.areEqual(byArray, byArray2)) {
            this.fail("HKDF failed generator test " + n);
        }
    }

    public String getName() {
        return "HKDF";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new HKDFGeneratorTest());
    }

    public void performTest() {
        SavableDigest savableDigest = SHA256Digest.newInstance();
        byte[] byArray = Hex.decode("0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b");
        byte[] byArray2 = Hex.decode("000102030405060708090a0b0c");
        byte[] byArray3 = Hex.decode("f0f1f2f3f4f5f6f7f8f9");
        int n = 42;
        byte[] byArray4 = new byte[n];
        HKDFParameters hKDFParameters = new HKDFParameters(byArray, byArray2, byArray3);
        HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator(savableDigest);
        hKDFBytesGenerator.init(hKDFParameters);
        hKDFBytesGenerator.generateBytes(byArray4, 0, n);
        this.compareOKM(1, byArray4, Hex.decode("3cb25f25faacd57a90434f64d0362f2a2d2d0a90cf1a5a4c5db02d56ecc4c5bf34007208d5b887185865"));
        SavableDigest savableDigest2 = SHA256Digest.newInstance();
        byte[] byArray5 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f");
        byte[] byArray6 = Hex.decode("606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeaf");
        byte[] byArray7 = Hex.decode("b0b1b2b3b4b5b6b7b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfeff");
        int n2 = 82;
        byte[] byArray8 = new byte[n2];
        HKDFParameters hKDFParameters2 = new HKDFParameters(byArray5, byArray6, byArray7);
        HKDFBytesGenerator hKDFBytesGenerator2 = new HKDFBytesGenerator(savableDigest2);
        hKDFBytesGenerator2.init(hKDFParameters2);
        hKDFBytesGenerator2.generateBytes(byArray8, 0, n2);
        this.compareOKM(2, byArray8, Hex.decode("b11e398dc80327a1c8e7f78c596a49344f012eda2d4efad8a050cc4c19afa97c59045a99cac7827271cb41c65e590e09da3275600c2f09b8367793a9aca3db71cc30c58179ec3e87c14c01d5c1f3434f1d87"));
        SavableDigest savableDigest3 = SHA256Digest.newInstance();
        byte[] byArray9 = Hex.decode("0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b");
        byte[] byArray10 = new byte[]{};
        byte[] byArray11 = null;
        int n3 = 42;
        byte[] byArray12 = new byte[n3];
        HKDFParameters hKDFParameters3 = new HKDFParameters(byArray9, byArray10, byArray11);
        HKDFBytesGenerator hKDFBytesGenerator3 = new HKDFBytesGenerator(savableDigest3);
        hKDFBytesGenerator3.init(hKDFParameters3);
        hKDFBytesGenerator3.generateBytes(byArray12, 0, n3);
        this.compareOKM(3, byArray12, Hex.decode("8da4e775a563c18f715f802a063c5a31b8a11f5c5ee1879ec3454e5f3c738d2d9d201395faa4b61a96c8"));
        SHA1Digest sHA1Digest = new SHA1Digest();
        byte[] byArray13 = Hex.decode("0b0b0b0b0b0b0b0b0b0b0b");
        byte[] byArray14 = Hex.decode("000102030405060708090a0b0c");
        byte[] byArray15 = Hex.decode("f0f1f2f3f4f5f6f7f8f9");
        int n4 = 42;
        byte[] byArray16 = new byte[n4];
        HKDFParameters hKDFParameters4 = new HKDFParameters(byArray13, byArray14, byArray15);
        HKDFBytesGenerator hKDFBytesGenerator4 = new HKDFBytesGenerator(sHA1Digest);
        hKDFBytesGenerator4.init(hKDFParameters4);
        hKDFBytesGenerator4.generateBytes(byArray16, 0, n4);
        this.compareOKM(4, byArray16, Hex.decode("085a01ea1b10f36933068b56efa5ad81a4f14b822f5b091568a9cdd4f155fda2c22e422478d305f3f896"));
        SHA1Digest sHA1Digest2 = new SHA1Digest();
        byte[] byArray17 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f");
        byte[] byArray18 = Hex.decode("606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeaf");
        byte[] byArray19 = Hex.decode("b0b1b2b3b4b5b6b7b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfeff");
        int n5 = 82;
        byte[] byArray20 = new byte[n5];
        HKDFParameters hKDFParameters5 = new HKDFParameters(byArray17, byArray18, byArray19);
        HKDFBytesGenerator hKDFBytesGenerator5 = new HKDFBytesGenerator(sHA1Digest2);
        hKDFBytesGenerator5.init(hKDFParameters5);
        hKDFBytesGenerator5.generateBytes(byArray20, 0, n5);
        this.compareOKM(5, byArray20, Hex.decode("0bd770a74d1160f7c9f12cd5912a06ebff6adcae899d92191fe4305673ba2ffe8fa3f1a4e5ad79f3f334b3b202b2173c486ea37ce3d397ed034c7f9dfeb15c5e927336d0441f4c4300e2cff0d0900b52d3b4"));
        SHA1Digest sHA1Digest3 = new SHA1Digest();
        byte[] byArray21 = Hex.decode("0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b");
        byte[] byArray22 = null;
        byte[] byArray23 = new byte[]{};
        int n6 = 42;
        byte[] byArray24 = new byte[n6];
        HKDFParameters hKDFParameters6 = new HKDFParameters(byArray21, byArray22, byArray23);
        HKDFBytesGenerator hKDFBytesGenerator6 = new HKDFBytesGenerator(sHA1Digest3);
        hKDFBytesGenerator6.init(hKDFParameters6);
        hKDFBytesGenerator6.generateBytes(byArray24, 0, n6);
        this.compareOKM(6, byArray24, Hex.decode("0ac1af7002b3d761d1e55298da9d0506b9ae52057220a306e07b6b87e8df21d0ea00033de03984d34918"));
        SHA1Digest sHA1Digest4 = new SHA1Digest();
        byte[] byArray25 = Hex.decode("0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c");
        byte[] byArray26 = null;
        byte[] byArray27 = new byte[]{};
        int n7 = 42;
        byte[] byArray28 = new byte[n7];
        HKDFParameters hKDFParameters7 = new HKDFParameters(byArray25, byArray26, byArray27);
        HKDFBytesGenerator hKDFBytesGenerator7 = new HKDFBytesGenerator(sHA1Digest4);
        hKDFBytesGenerator7.init(hKDFParameters7);
        hKDFBytesGenerator7.generateBytes(byArray28, 0, n7);
        this.compareOKM(7, byArray28, Hex.decode("2c91117204d745f3500d636a62f64f0ab3bae548aa53d423b0d1f27ebba6f5e5673a081d70cce7acfc48"));
        SHA1Digest sHA1Digest5 = new SHA1Digest();
        byte[] byArray29 = Hex.decode("2adccada18779e7c2077ad2eb19d3f3e731385dd");
        byte[] byArray30 = new byte[]{};
        int n8 = 42;
        byte[] byArray31 = new byte[n8];
        HKDFParameters hKDFParameters8 = HKDFParameters.skipExtractParameters(byArray29, byArray30);
        HKDFBytesGenerator hKDFBytesGenerator8 = new HKDFBytesGenerator(sHA1Digest5);
        hKDFBytesGenerator8.init(hKDFParameters8);
        hKDFBytesGenerator8.generateBytes(byArray31, 0, n8);
        this.compareOKM(101, byArray31, Hex.decode("2c91117204d745f3500d636a62f64f0ab3bae548aa53d423b0d1f27ebba6f5e5673a081d70cce7acfc48"));
        SHA1Digest sHA1Digest6 = new SHA1Digest();
        byte[] byArray32 = Hex.decode("2adccada18779e7c2077ad2eb19d3f3e731385dd");
        byte[] byArray33 = new byte[]{};
        int n9 = 255 * sHA1Digest6.getDigestSize();
        byte[] byArray34 = new byte[n9];
        HKDFParameters hKDFParameters9 = HKDFParameters.skipExtractParameters(byArray32, byArray33);
        HKDFBytesGenerator hKDFBytesGenerator9 = new HKDFBytesGenerator(sHA1Digest6);
        hKDFBytesGenerator9.init(hKDFParameters9);
        hKDFBytesGenerator9.generateBytes(byArray34, 0, n9);
        int n10 = 0;
        int n11 = 0;
        while (n11 < sHA1Digest6.getDigestSize()) {
            if (byArray34[n11] == 0) {
                ++n10;
            }
            ++n11;
        }
        if (n10 == sHA1Digest6.getDigestSize()) {
            this.fail("HKDF failed generator test 102");
        }
        SHA256Digest sHA256Digest = new SHA256Digest();
        byte[] byArray35 = Hex.decode("c702e7d0a9e064b09ba55245fb733cf3");
        byte[] byArray36 = Strings.toByteArray("The Cryptographic Message Syntax");
        byte[] byArray37 = Hex.decode("301b0609608648016503040106300e040c5c79058ba2f43447639d29e2");
        byte[] byArray38 = Hex.decode("2124ffb29fac4e0fbbc7d5d87492bff3");
        byte[] byArray39 = new byte[byArray38.length];
        HKDFParameters hKDFParameters10 = new HKDFParameters(byArray35, byArray36, byArray37);
        HKDFBytesGenerator hKDFBytesGenerator10 = new HKDFBytesGenerator(sHA256Digest);
        hKDFBytesGenerator10.init(hKDFParameters10);
        hKDFBytesGenerator10.generateBytes(byArray39, 0, byArray39.length);
        this.compareOKM(8, byArray39, byArray38);
        SHA256Digest sHA256Digest2 = new SHA256Digest();
        byte[] byArray40 = Hex.decode("c702e7d0a9e064b09ba55245fb733cf3");
        byte[] byArray41 = Strings.toByteArray("The Cryptographic Message Syntax");
        byte[] byArray42 = Hex.decode("301d06096086480165030401020410651f722ffd512c52fe072e507d72b377");
        byte[] byArray43 = Hex.decode("9cd102c52f1e19ece8729b35bfeceb50");
        byte[] byArray44 = new byte[byArray43.length];
        HKDFParameters hKDFParameters11 = new HKDFParameters(byArray40, byArray41, byArray42);
        HKDFBytesGenerator hKDFBytesGenerator11 = new HKDFBytesGenerator(sHA256Digest2);
        hKDFBytesGenerator11.init(hKDFParameters11);
        hKDFBytesGenerator11.generateBytes(byArray44, 0, byArray44.length);
        this.compareOKM(9, byArray44, byArray43);
    }
}

