/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.Grain128AEADEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class Grain128AEADTest
extends SimpleTest {
    public String getName() {
        return "Grain-128AEAD";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new Grain128AEADTest());
    }

    private void mismatch(String string, String string2, byte[] byArray) {
        this.fail("mismatch on " + string, string2, new String(Hex.encode(byArray)));
    }

    public void performTest() throws Exception {
        this.testVectors();
        this.testSplitUpdate();
        this.testExceptions();
        this.testLongAEAD();
    }

    private void testExceptions() throws InvalidCipherTextException {
        Grain128AEADEngine grain128AEADEngine;
        try {
            grain128AEADEngine = new Grain128AEADEngine();
            grain128AEADEngine.init(true, new KeyParameter(new byte[10]));
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("Grain-128AEAD init parameters must include an IV", illegalArgumentException.getMessage());
        }
        try {
            grain128AEADEngine = new Grain128AEADEngine();
            grain128AEADEngine.init(true, new ParametersWithIV(new KeyParameter(new byte[10]), new byte[8]));
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("Grain-128AEAD requires exactly 12 bytes of IV", illegalArgumentException.getMessage());
        }
        try {
            grain128AEADEngine = new Grain128AEADEngine();
            grain128AEADEngine.init(true, new ParametersWithIV(new KeyParameter(new byte[10]), new byte[12]));
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("Grain-128AEAD key must be 128 bits long", illegalArgumentException.getMessage());
        }
    }

    private void testLongAEAD() throws InvalidCipherTextException {
        byte[] byArray = Hex.decode("000102030405060708090A0B0C0D0E0F");
        byte[] byArray2 = Hex.decode("000102030405060708090A0B");
        byte[] byArray3 = Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");
        byte[] byArray4 = Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9");
        byte[] byArray5 = Hex.decode("731DAA8B1D15317A1CCB4E3DD320095FB27E5BB2A10F2C669F870538637D4F162298C70430A2B560");
        Grain128AEADEngine grain128AEADEngine = new Grain128AEADEngine();
        ParametersWithIV parametersWithIV = new ParametersWithIV(new KeyParameter(byArray), byArray2);
        grain128AEADEngine.init(true, parametersWithIV);
        grain128AEADEngine.processAADBytes(byArray4, 0, byArray4.length);
        byte[] byArray6 = new byte[byArray5.length];
        int n = grain128AEADEngine.processBytes(byArray3, 0, 10, byArray6, 0);
        n += grain128AEADEngine.processByte(byArray3[10], byArray6, n);
        n += grain128AEADEngine.processBytes(byArray3, 11, byArray3.length - 11, byArray6, n);
        grain128AEADEngine.doFinal(byArray6, n);
        this.isTrue(Arrays.areEqual(byArray6, byArray5));
        grain128AEADEngine.processBytes(byArray3, 0, 10, byArray6, 0);
        try {
            grain128AEADEngine.processAADByte((byte)1);
            this.fail("no exception");
        }
        catch (IllegalStateException illegalStateException) {
            this.isEquals("associated data must be added before plaintext/ciphertext", illegalStateException.getMessage());
        }
        try {
            grain128AEADEngine.processAADBytes(byArray4, 0, byArray4.length);
            this.fail("no exception");
        }
        catch (IllegalStateException illegalStateException) {
            this.isEquals("associated data must be added before plaintext/ciphertext", illegalStateException.getMessage());
        }
    }

    private void testSplitUpdate() throws InvalidCipherTextException {
        byte[] byArray = Hex.decode("000102030405060708090A0B0C0D0E0F");
        byte[] byArray2 = Hex.decode("000102030405060708090A0B");
        byte[] byArray3 = Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");
        byte[] byArray4 = Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E");
        byte[] byArray5 = Hex.decode("EAD60EF559493ACEF6A3C238C018835DE3ABB6AA621A9AA65EFAF7B9D05BBE6C0913DFC8674BACC9");
        Grain128AEADEngine grain128AEADEngine = new Grain128AEADEngine();
        ParametersWithIV parametersWithIV = new ParametersWithIV(new KeyParameter(byArray), byArray2);
        grain128AEADEngine.init(true, parametersWithIV);
        grain128AEADEngine.processAADBytes(byArray4, 0, 10);
        grain128AEADEngine.processAADByte(byArray4[10]);
        grain128AEADEngine.processAADBytes(byArray4, 11, byArray4.length - 11);
        byte[] byArray6 = new byte[byArray5.length];
        int n = grain128AEADEngine.processBytes(byArray3, 0, 10, byArray6, 0);
        n += grain128AEADEngine.processByte(byArray3[10], byArray6, n);
        n += grain128AEADEngine.processBytes(byArray3, 11, byArray3.length - 11, byArray6, n);
        grain128AEADEngine.doFinal(byArray6, n);
        this.isTrue(Arrays.areEqual(byArray6, byArray5));
        grain128AEADEngine.processBytes(byArray3, 0, 10, byArray6, 0);
        try {
            grain128AEADEngine.processAADByte((byte)1);
            this.fail("no exception");
        }
        catch (IllegalStateException illegalStateException) {
            this.isEquals("associated data must be added before plaintext/ciphertext", illegalStateException.getMessage());
        }
        try {
            grain128AEADEngine.processAADBytes(byArray4, 0, byArray4.length);
            this.fail("no exception");
        }
        catch (IllegalStateException illegalStateException) {
            this.isEquals("associated data must be added before plaintext/ciphertext", illegalStateException.getMessage());
        }
    }

    private void testVectors() throws Exception {
        String string;
        Grain128AEADEngine grain128AEADEngine = new Grain128AEADEngine();
        InputStream inputStream = TestResourceFinder.findTestResource("crypto", "LWC_AEAD_KAT_128_96.txt");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(61);
            if (n < 0) {
                ParametersWithIV parametersWithIV = new ParametersWithIV(new KeyParameter(Hex.decode((String)hashMap.get("Key"))), Hex.decode((String)hashMap.get("Nonce")));
                grain128AEADEngine.init(true, parametersWithIV);
                byte[] byArray = Hex.decode((String)hashMap.get("AD"));
                grain128AEADEngine.processAADBytes(byArray, 0, byArray.length);
                byte[] byArray2 = Hex.decode((String)hashMap.get("PT"));
                byte[] byArray3 = new byte[byArray2.length];
                grain128AEADEngine.processBytes(byArray2, 0, byArray2.length, byArray3, 0);
                byte[] byArray4 = new byte[8];
                grain128AEADEngine.doFinal(byArray4, 0);
                if (!this.areEqual(Arrays.concatenate(byArray3, byArray4), Hex.decode((String)hashMap.get("CT")))) {
                    this.mismatch("Keystream " + hashMap.get("Count"), (String)hashMap.get("CT"), byArray3);
                }
                hashMap.clear();
                continue;
            }
            hashMap.put(string.substring(0, n).trim(), string.substring(n + 1).trim());
        }
    }
}

