/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.engines.GOST3412_2015Engine;
import org.bouncycastle.crypto.macs.CMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class GOST3412MacTest
implements Test {
    public String getName() {
        return "GOST 3412 2015 MAC test";
    }

    public static void main(String[] stringArray) {
        GOST3412MacTest gOST3412MacTest = new GOST3412MacTest();
        TestResult testResult = gOST3412MacTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        byte[][] byArrayArray = new byte[][]{Hex.decode("1122334455667700ffeeddccbbaa9988"), Hex.decode("00112233445566778899aabbcceeff0a"), Hex.decode("112233445566778899aabbcceeff0a00"), Hex.decode("2233445566778899aabbcceeff0a0011")};
        CMac cMac = new CMac(new GOST3412_2015Engine(), 64);
        byte[] byArray = Hex.decode("336f4d296059fbe3");
        KeyParameter keyParameter = new KeyParameter(Hex.decode("8899aabbccddeeff0011223344556677fedcba98765432100123456789abcdef"));
        cMac.init(keyParameter);
        int n = 0;
        while (n != byArrayArray.length) {
            cMac.update(byArrayArray[n], 0, byArrayArray[n].length);
            ++n;
        }
        byte[] byArray2 = new byte[8];
        cMac.doFinal(byArray2, 0);
        if (!Arrays.areEqual(byArray2, byArray)) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed test 1 - expected " + new String(Hex.encode(byArray)) + " got " + new String(Hex.encode(byArray2)));
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

