/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.util.ArrayList;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.GOST3411_2012_256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.DigestTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class GOST3411_2012_256DigestTest
extends DigestTest {
    private static final String[] messages;
    private static char[] M1;
    private static char[] M2;
    private static final String[] digests;

    static {
        M1 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2'};
        M2 = new char[]{'\u00d1', '\u00e5', ' ', '\u00e2', '\u00e5', '\u00f2', '\u00f0', '\u00e8', ',', ' ', '\u00d1', '\u00f2', '\u00f0', '\u00e8', '\u00e1', '\u00ee', '\u00e6', '\u00e8', ' ', '\u00e2', '\u00ed', '\u00f3', '\u00f6', '\u00e8', ',', ' ', '\u00e2', '\u00e5', '\u00fe', '\u00f2', '\u00fa', ' ', '\u00f1', ' ', '\u00ec', '\u00ee', '\u00f0', '\u00ff', ' ', '\u00f1', '\u00f2', '\u00f0', '\u00e5', '\u00eb', '\u00e0', '\u00ec', '\u00e8', ' ', '\u00ed', '\u00e0', ' ', '\u00f5', '\u00f0', '\u00e0', '\u00e1', '\u00f0', '\u00fb', '\u00ff', ' ', '\u00ef', '\u00eb', '\u00fa', '\u00ea', '\u00fb', ' ', '\u00c8', '\u00e3', '\u00ee', '\u00f0', '\u00e5', '\u00e2', '\u00fb'};
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(new String(M1));
        arrayList.add(new String(M2));
        messages = new String[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            GOST3411_2012_256DigestTest.messages[n] = (String)arrayList.get(n);
            ++n;
        }
        digests = new String[]{"9d151eefd8590b89daa6ba6cb74af9275dd051026bb149a452fd84e5e57b5500", "9dd2fe4e90409e5da87f53976d7405b0c0cac628fc669a741d50063c557e8f50"};
    }

    GOST3411_2012_256DigestTest() {
        super(new GOST3411_2012_256Digest(), messages, digests);
    }

    protected Digest cloneDigest(Digest digest) {
        return new GOST3411_2012_256Digest((GOST3411_2012_256Digest)digest);
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new GOST3411_2012_256DigestTest());
    }

    public void performTest() {
        super.performTest();
        HMac hMac = new HMac(new GOST3411_2012_256Digest());
        hMac.init(new KeyParameter(Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f")));
        byte[] byArray = Hex.decode("0126bdb87800af214341456563780100");
        hMac.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[hMac.getMacSize()];
        hMac.doFinal(byArray2, 0);
        if (!Arrays.areEqual(Hex.decode("a1aa5f7de402d7b3d323f2991c8d4534013137010a83754fd0af6d7cd4922ed9"), byArray2)) {
            this.fail("mac calculation failed.");
        }
    }
}

