/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.GCMModeCipher;
import org.bouncycastle.crypto.modes.gcm.BasicGCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.Tables4kGCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.Tables64kGCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.Tables8kGCMMultiplier;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.test.AEADTestUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.Times;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class GCMTest
extends SimpleTest {
    private static final String[][] TEST_VECTORS = new String[][]{{"Test Case 1", "00000000000000000000000000000000", "", "", "000000000000000000000000", "", "58e2fccefa7e3061367f1d57a4e7455a"}, {"Test Case 2", "00000000000000000000000000000000", "00000000000000000000000000000000", "", "000000000000000000000000", "0388dace60b6a392f328c2b971b2fe78", "ab6e47d42cec13bdf53a67b21257bddf"}, {"Test Case 3", "feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b391aafd255", "", "cafebabefacedbaddecaf888", "42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091473f5985", "4d5c2af327cd64a62cf35abd2ba6fab4"}, {"Test Case 4", "feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "cafebabefacedbaddecaf888", "42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091", "5bc94fbc3221a5db94fae95ae7121a47"}, {"Test Case 5", "feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "cafebabefacedbad", "61353b4c2806934a777ff51fa22a4755699b2a714fcdc6f83766e5f97b6c742373806900e49f24b22b097544d4896b424989b5e1ebac0f07c23f4598", "3612d2e79e3b0785561be14aaca2fccb"}, {"Test Case 6", "feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b", "8ce24998625615b603a033aca13fb894be9112a5c3a211a8ba262a3cca7e2ca701e4a9a4fba43c90ccdcb281d48c7c6fd62875d2aca417034c34aee5", "619cc5aefffe0bfa462af43c1699d050"}, {"Test Case 7", "000000000000000000000000000000000000000000000000", "", "", "000000000000000000000000", "", "cd33b28ac773f74ba00ed1f312572435"}, {"Test Case 8", "000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "", "000000000000000000000000", "98e7247c07f0fe411c267e4384b0f600", "2ff58d80033927ab8ef4d4587514f0fb"}, {"Test Case 9", "feffe9928665731c6d6a8f9467308308feffe9928665731c", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b391aafd255", "", "cafebabefacedbaddecaf888", "3980ca0b3c00e841eb06fac4872a2757859e1ceaa6efd984628593b40ca1e19c7d773d00c144c525ac619d18c84a3f4718e2448b2fe324d9ccda2710acade256", "9924a7c8587336bfb118024db8674a14"}, {"Test Case 10", "feffe9928665731c6d6a8f9467308308feffe9928665731c", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "cafebabefacedbaddecaf888", "3980ca0b3c00e841eb06fac4872a2757859e1ceaa6efd984628593b40ca1e19c7d773d00c144c525ac619d18c84a3f4718e2448b2fe324d9ccda2710", "2519498e80f1478f37ba55bd6d27618c"}, {"Test Case 11", "feffe9928665731c6d6a8f9467308308feffe9928665731c", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "cafebabefacedbad", "0f10f599ae14a154ed24b36e25324db8c566632ef2bbb34f8347280fc4507057fddc29df9a471f75c66541d4d4dad1c9e93a19a58e8b473fa0f062f7", "65dcc57fcf623a24094fcca40d3533f8"}, {"Test Case 12", "feffe9928665731c6d6a8f9467308308feffe9928665731c", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b", "d27e88681ce3243c4830165a8fdcf9ff1de9a1d8e6b447ef6ef7b79828666e4581e79012af34ddd9e2f037589b292db3e67c036745fa22e7e9b7373b", "dcf566ff291c25bbb8568fc3d376a6d9"}, {"Test Case 13", "0000000000000000000000000000000000000000000000000000000000000000", "", "", "000000000000000000000000", "", "530f8afbc74536b9a963b4f1c4cb738b"}, {"Test Case 14", "0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "", "000000000000000000000000", "cea7403d4d606b6e074ec5d3baf39d18", "d0d1c8a799996bf0265b98b5d48ab919"}, {"Test Case 15", "feffe9928665731c6d6a8f9467308308feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b391aafd255", "", "cafebabefacedbaddecaf888", "522dc1f099567d07f47f37a32a84427d643a8cdcbfe5c0c97598a2bd2555d1aa8cb08e48590dbb3da7b08b1056828838c5f61e6393ba7a0abcc9f662898015ad", "b094dac5d93471bdec1a502270e3cc6c"}, {"Test Case 16", "feffe9928665731c6d6a8f9467308308feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "cafebabefacedbaddecaf888", "522dc1f099567d07f47f37a32a84427d643a8cdcbfe5c0c97598a2bd2555d1aa8cb08e48590dbb3da7b08b1056828838c5f61e6393ba7a0abcc9f662", "76fc6ece0f4e1768cddf8853bb2d551b"}, {"Test Case 17", "feffe9928665731c6d6a8f9467308308feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "cafebabefacedbad", "c3762df1ca787d32ae47c13bf19844cbaf1ae14d0b976afac52ff7d79bba9de0feb582d33934a4f0954cc2363bc73f7862ac430e64abe499f47c9b1f", "3a337dbf46a792c45e454913fe2ea8f2"}, {"Test Case 18", "feffe9928665731c6d6a8f9467308308feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b", "5a8def2f0c9e53f1f75d7853659e2a20eeb2b22aafde6419a058ab4f6f746bf40fc0c3b780f244452da3ebf1c5d82cdea2418997200ef82e44ae7e3f", "a44a8266ee1c8eb0c8b5d4cf5ae9f19a"}};

    private void checkTestCase(GCMModeCipher gCMModeCipher, GCMModeCipher gCMModeCipher2, String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws InvalidCipherTextException {
        byte[] byArray5 = new byte[gCMModeCipher.getOutputSize(byArray2.length)];
        if (byArray != null) {
            gCMModeCipher.processAADBytes(byArray, 0, byArray.length);
        }
        int n = gCMModeCipher.processBytes(byArray2, 0, byArray2.length, byArray5, 0);
        if (byArray5.length != (n += gCMModeCipher.doFinal(byArray5, n))) {
            this.fail("encryption reported incorrect length: " + string);
        }
        byte[] byArray6 = gCMModeCipher.getMac();
        byte[] byArray7 = new byte[byArray2.length];
        System.arraycopy(byArray5, 0, byArray7, 0, byArray7.length);
        byte[] byArray8 = new byte[byArray5.length - byArray2.length];
        System.arraycopy(byArray5, byArray2.length, byArray8, 0, byArray8.length);
        if (!this.areEqual(byArray3, byArray7)) {
            this.fail("incorrect encrypt in: " + string);
        }
        if (!this.areEqual(byArray4, byArray6)) {
            this.fail("getMac() returned wrong mac in: " + string);
        }
        if (!this.areEqual(byArray4, byArray8)) {
            this.fail("stream contained wrong mac in: " + string);
        }
        byte[] byArray9 = new byte[gCMModeCipher2.getOutputSize(byArray5.length)];
        if (byArray != null) {
            gCMModeCipher2.processAADBytes(byArray, 0, byArray.length);
        }
        n = gCMModeCipher2.processBytes(byArray5, 0, byArray5.length, byArray9, 0);
        n += gCMModeCipher2.doFinal(byArray9, n);
        byArray6 = gCMModeCipher2.getMac();
        byArray7 = new byte[byArray3.length];
        System.arraycopy(byArray9, 0, byArray7, 0, byArray7.length);
        if (!this.areEqual(byArray2, byArray7)) {
            this.fail("incorrect decrypt in: " + string);
        }
    }

    protected BlockCipher createAESEngine() {
        return AESEngine.newInstance();
    }

    public String getName() {
        return "GCM";
    }

    private GCMModeCipher initCipher(GCMMultiplier gCMMultiplier, boolean bl, AEADParameters aEADParameters) {
        GCMModeCipher gCMModeCipher = GCMBlockCipher.newInstance(AESEngine.newInstance(), gCMMultiplier);
        gCMModeCipher.init(bl, aEADParameters);
        return gCMModeCipher;
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new GCMTest());
    }

    private static int nextInt(SecureRandom secureRandom, int n) {
        int n2;
        int n3;
        if ((n & -n) == n) {
            return (int)((long)n * (long)(secureRandom.nextInt() >>> 1) >> 31);
        }
        while ((n3 = secureRandom.nextInt() >>> 1) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    private void outputSizeTests() {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = null;
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(byArray), 128, byArray2, byArray3);
        GCMModeCipher gCMModeCipher = this.initCipher(null, true, aEADParameters);
        if (gCMModeCipher.getUpdateOutputSize(0) != 0) {
            this.fail("incorrect getUpdateOutputSize for initial 0 bytes encryption");
        }
        if (gCMModeCipher.getOutputSize(0) != 16) {
            this.fail("incorrect getOutputSize for initial 0 bytes encryption");
        }
        gCMModeCipher.init(false, aEADParameters);
        if (gCMModeCipher.getUpdateOutputSize(0) != 0) {
            this.fail("incorrect getUpdateOutputSize for initial 0 bytes decryption");
        }
        if (gCMModeCipher.getOutputSize(0) != 0) {
            this.fail("fragile getOutputSize for initial 0 bytes decryption");
        }
        if (gCMModeCipher.getOutputSize(16) != 0) {
            this.fail("incorrect getOutputSize for initial MAC-size bytes decryption");
        }
    }

    public void performTest() throws Exception {
        int n = 0;
        while (n < TEST_VECTORS.length) {
            this.runTestCase(TEST_VECTORS[n]);
            ++n;
        }
        this.randomTests();
        this.outputSizeTests();
        this.testExceptions();
        this.testResetBehavior();
    }

    private void randomTest(SecureRandom secureRandom, GCMMultiplier gCMMultiplier) throws InvalidCipherTextException {
        byte[] byArray;
        int n = 16 + 8 * (Math.abs(secureRandom.nextInt()) % 3);
        byte[] byArray2 = new byte[n];
        secureRandom.nextBytes(byArray2);
        int n2 = secureRandom.nextInt() >>> 16;
        byte[] byArray3 = new byte[n2];
        secureRandom.nextBytes(byArray3);
        int n3 = secureRandom.nextInt() >>> 24;
        byte[] byArray4 = new byte[n3];
        secureRandom.nextBytes(byArray4);
        int n4 = secureRandom.nextInt() >>> 24;
        byte[] byArray5 = new byte[n4];
        secureRandom.nextBytes(byArray5);
        int n5 = 1 + (secureRandom.nextInt() >>> 24);
        byte[] byArray6 = new byte[n5];
        secureRandom.nextBytes(byArray6);
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(byArray2), 128, byArray6, byArray4);
        GCMModeCipher gCMModeCipher = this.initCipher(gCMMultiplier, true, aEADParameters);
        byte[] byArray7 = new byte[gCMModeCipher.getOutputSize(byArray3.length)];
        int n6 = gCMModeCipher.getUpdateOutputSize(byArray3.length);
        int n7 = GCMTest.nextInt(secureRandom, byArray5.length + 1);
        gCMModeCipher.processAADBytes(byArray5, 0, n7);
        int n8 = gCMModeCipher.processBytes(byArray3, 0, byArray3.length, byArray7, 0);
        gCMModeCipher.processAADBytes(byArray5, n7, byArray5.length - n7);
        if (n6 != n8) {
            this.fail("encryption reported incorrect update length in randomised test");
        }
        if (byArray7.length != (n8 += gCMModeCipher.doFinal(byArray7, n8))) {
            this.fail("encryption reported incorrect length in randomised test");
        }
        byte[] byArray8 = gCMModeCipher.getMac();
        byte[] byArray9 = new byte[byArray7.length - byArray3.length];
        System.arraycopy(byArray7, byArray3.length, byArray9, 0, byArray9.length);
        if (!this.areEqual(byArray8, byArray9)) {
            this.fail("stream contained wrong mac in randomised test");
        }
        gCMModeCipher.init(false, aEADParameters);
        byte[] byArray10 = new byte[gCMModeCipher.getOutputSize(byArray7.length)];
        n6 = gCMModeCipher.getUpdateOutputSize(byArray7.length);
        n7 = GCMTest.nextInt(secureRandom, byArray5.length + 1);
        gCMModeCipher.processAADBytes(byArray5, 0, n7);
        n8 = gCMModeCipher.processBytes(byArray7, 0, byArray7.length, byArray10, 0);
        gCMModeCipher.processAADBytes(byArray5, n7, byArray5.length - n7);
        if (n6 != n8) {
            this.fail("decryption reported incorrect update length in randomised test");
        }
        n8 += gCMModeCipher.doFinal(byArray10, n8);
        if (!this.areEqual(byArray3, byArray10)) {
            this.fail("incorrect decrypt in randomised test");
        }
        if (!this.areEqual(byArray8, byArray = gCMModeCipher.getMac())) {
            this.fail("decryption produced different mac from encryption");
        }
        gCMModeCipher.init(false, AEADTestUtil.reuseKey(aEADParameters));
        byArray10 = new byte[gCMModeCipher.getOutputSize(byArray7.length)];
        n7 = GCMTest.nextInt(secureRandom, byArray5.length + 1);
        gCMModeCipher.processAADBytes(byArray5, 0, n7);
        n8 = gCMModeCipher.processBytes(byArray7, 0, byArray7.length, byArray10, 0);
        gCMModeCipher.processAADBytes(byArray5, n7, byArray5.length - n7);
        n8 += gCMModeCipher.doFinal(byArray10, n8);
        if (!this.areEqual(byArray3, byArray10)) {
            this.fail("incorrect decrypt in randomised test");
        }
        if (!this.areEqual(byArray8, byArray = gCMModeCipher.getMac())) {
            this.fail("decryption produced different mac from encryption");
        }
    }

    private void randomTests() throws InvalidCipherTextException {
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(Times.nanoTime());
        this.randomTests(secureRandom, null);
        this.randomTests(secureRandom, new BasicGCMMultiplier());
        this.randomTests(secureRandom, new Tables4kGCMMultiplier());
        this.randomTests(secureRandom, new Tables8kGCMMultiplier());
        this.randomTests(secureRandom, new Tables64kGCMMultiplier());
    }

    private void randomTests(SecureRandom secureRandom, GCMMultiplier gCMMultiplier) throws InvalidCipherTextException {
        int n = 0;
        while (n < 10) {
            this.randomTest(secureRandom, gCMMultiplier);
            ++n;
        }
    }

    private void runTestCase(GCMMultiplier gCMMultiplier, GCMMultiplier gCMMultiplier2, String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws InvalidCipherTextException {
        byte[] byArray7 = new byte[byArray3.length / 2];
        byte[] byArray8 = new byte[byArray3.length - byArray3.length / 2];
        System.arraycopy(byArray3, 0, byArray7, 0, byArray7.length);
        System.arraycopy(byArray3, byArray7.length, byArray8, 0, byArray8.length);
        this.runTestCase(gCMMultiplier, gCMMultiplier2, String.valueOf(string) + " all initial associated data", byArray, byArray2, byArray3, null, byArray4, byArray5, byArray6);
        this.runTestCase(gCMMultiplier, gCMMultiplier2, String.valueOf(string) + " all subsequent associated data", byArray, byArray2, null, byArray3, byArray4, byArray5, byArray6);
        this.runTestCase(gCMMultiplier, gCMMultiplier2, String.valueOf(string) + " split associated data", byArray, byArray2, byArray7, byArray8, byArray4, byArray5, byArray6);
    }

    private void runTestCase(GCMMultiplier gCMMultiplier, GCMMultiplier gCMMultiplier2, String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7) throws InvalidCipherTextException {
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(byArray), byArray7.length * 8, byArray2, byArray3);
        GCMModeCipher gCMModeCipher = this.initCipher(gCMMultiplier, true, aEADParameters);
        GCMModeCipher gCMModeCipher2 = this.initCipher(gCMMultiplier2, false, aEADParameters);
        this.checkTestCase(gCMModeCipher, gCMModeCipher2, string, byArray4, byArray5, byArray6, byArray7);
        gCMModeCipher = this.initCipher(gCMMultiplier, true, aEADParameters);
        this.checkTestCase(gCMModeCipher, gCMModeCipher2, String.valueOf(string) + " (reused)", byArray4, byArray5, byArray6, byArray7);
        AEADParameters aEADParameters2 = AEADTestUtil.reuseKey(aEADParameters);
        try {
            gCMModeCipher.init(true, aEADParameters2);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("wrong message", "cannot reuse nonce for GCM encryption".equals(illegalArgumentException.getMessage()));
        }
    }

    private void runTestCase(String[] stringArray) throws InvalidCipherTextException {
        int n = 12;
        while (n <= 16) {
            this.runTestCase(stringArray, n);
            ++n;
        }
    }

    private void runTestCase(String[] stringArray, int n) throws InvalidCipherTextException {
        int n2 = 0;
        String string = stringArray[n2++];
        byte[] byArray = Hex.decode(stringArray[n2++]);
        byte[] byArray2 = Hex.decode(stringArray[n2++]);
        byte[] byArray3 = Hex.decode(stringArray[n2++]);
        byte[] byArray4 = Hex.decode(stringArray[n2++]);
        byte[] byArray5 = Hex.decode(stringArray[n2++]);
        byte[] byArray6 = Hex.decode(stringArray[n2++]);
        byte[] byArray7 = new byte[n];
        System.arraycopy(byArray6, 0, byArray7, 0, byArray7.length);
        this.runTestCase(null, null, string, byArray, byArray4, byArray3, byArray2, byArray5, byArray7);
        this.runTestCase(new BasicGCMMultiplier(), new BasicGCMMultiplier(), string, byArray, byArray4, byArray3, byArray2, byArray5, byArray7);
        this.runTestCase(new Tables4kGCMMultiplier(), new Tables4kGCMMultiplier(), string, byArray, byArray4, byArray3, byArray2, byArray5, byArray7);
        this.runTestCase(new Tables8kGCMMultiplier(), new Tables8kGCMMultiplier(), string, byArray, byArray4, byArray3, byArray2, byArray5, byArray7);
        this.runTestCase(new Tables64kGCMMultiplier(), new Tables64kGCMMultiplier(), string, byArray, byArray4, byArray3, byArray2, byArray5, byArray7);
    }

    private void testExceptions() throws InvalidCipherTextException {
        GCMBlockCipher gCMBlockCipher = new GCMBlockCipher(this.createAESEngine());
        try {
            gCMBlockCipher = new GCMBlockCipher(new DESEngine());
            this.fail("incorrect block size not picked up");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            gCMBlockCipher.init(false, new KeyParameter(new byte[16]));
            this.fail("illegal argument not picked up");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        AEADTestUtil.testTampering(this, gCMBlockCipher, new AEADParameters(new KeyParameter(new byte[16]), 128, new byte[16]));
        byte[] byArray = Strings.toByteArray("Hello world!");
        byte[] byArray2 = new byte[100];
        GCMModeCipher gCMModeCipher = GCMBlockCipher.newInstance(AESEngine.newInstance());
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(new byte[16]), 128, new byte[16]);
        gCMModeCipher.init(true, aEADParameters);
        gCMModeCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
        gCMModeCipher.doFinal(byArray2, 0);
        try {
            gCMModeCipher.doFinal(byArray2, 0);
            this.fail("no exception on reuse");
        }
        catch (IllegalStateException illegalStateException) {
            this.isTrue("wrong message", illegalStateException.getMessage().equals("GCM cipher cannot be reused for encryption"));
        }
        try {
            gCMModeCipher.init(true, aEADParameters);
            this.fail("no exception on reuse");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("wrong message", illegalArgumentException.getMessage().equals("cannot reuse nonce for GCM encryption"));
        }
    }

    private void testResetBehavior() throws Exception {
        GCMBlockCipher gCMBlockCipher = new GCMBlockCipher(this.createAESEngine());
        SecureRandom secureRandom = new SecureRandom();
        int[] nArray = new int[]{10, 12, 16};
        int n = 0;
        while (n != nArray.length) {
            int n2 = nArray[n];
            int[] nArray2 = new int[]{16, 24, 32};
            int n3 = 0;
            while (n3 != nArray2.length) {
                int n4 = nArray2[n3];
                byte[] byArray = new byte[n4];
                byte[] byArray2 = new byte[n2];
                secureRandom.nextBytes(byArray);
                secureRandom.nextBytes(byArray2);
                gCMBlockCipher.init(true, new ParametersWithIV(new KeyParameter(byArray), byArray2));
                byte[] byArray3 = new byte[1024];
                secureRandom.nextBytes(byArray3);
                byte[] byArray4 = new byte[gCMBlockCipher.getOutputSize(byArray3.length)];
                int n5 = gCMBlockCipher.processBytes(byArray3, 0, byArray3.length, byArray4, 0);
                gCMBlockCipher.doFinal(byArray4, n5);
                gCMBlockCipher.init(false, new ParametersWithIV(new KeyParameter(byArray), byArray2));
                byte[] byArray5 = new byte[byArray3.length];
                n5 = gCMBlockCipher.processBytes(byArray4, 0, byArray4.length, byArray5, 0);
                gCMBlockCipher.doFinal(byArray5, n5);
                gCMBlockCipher.reset();
                byte[] byArray6 = new byte[byArray3.length];
                n5 = gCMBlockCipher.processBytes(byArray4, 0, byArray4.length, byArray6, 0);
                gCMBlockCipher.doFinal(byArray6, n5);
                this.isTrue("before / after reset decryptions not the same", Arrays.areEqual(byArray5, byArray6));
                this.isTrue("decryption not same as message", Arrays.areEqual(byArray3, byArray6));
                ++n3;
            }
            ++n;
        }
    }
}

