/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyEncoder;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.EthereumIESEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.IESParameters;
import org.bouncycastle.crypto.params.IESWithCipherParameters;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.parsers.ECIESPublicKeyParser;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class EthereumIESTest
extends SimpleTest {
    private static byte[] TWOFISH_IV = Hex.decode("000102030405060708090a0b0c0d0e0f");

    EthereumIESTest() {
    }

    private void doEphemeralTest(byte[] byArray, final boolean bl) throws Exception {
        BigInteger bigInteger = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), bigInteger, ECConstants.ONE);
        ECDomainParameters eCDomainParameters = new ECDomainParameters(fp, fp.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), bigInteger);
        ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), eCDomainParameters);
        ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(fp.decodePoint(Hex.decode("0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), eCDomainParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(eCDomainParameters, new SecureRandom()));
        EphemeralKeyPairGenerator ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator(eCKeyPairGenerator, new KeyEncoder(){

            public byte[] getEncoded(AsymmetricKeyParameter asymmetricKeyParameter) {
                return ((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getEncoded(bl);
            }
        });
        byte[] byArray2 = Hex.decode("0262b12d60690cdcf330baba03188da80eb03090f67cbf2043a18800f4ff0a0262b12d60690cdcf330bab6e69763b471f994dd2d16a5fd82ff1012b6e69763b4");
        EthereumIESEngine ethereumIESEngine = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray2);
        EthereumIESEngine ethereumIESEngine2 = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray2);
        byte[] byArray3 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray4 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        CipherParameters cipherParameters = new ParametersWithIV(new IESParameters(byArray3, byArray4, 64), new byte[32]);
        ethereumIESEngine.init(asymmetricCipherKeyPair2.getPublic(), cipherParameters, ephemeralKeyPairGenerator);
        ethereumIESEngine2.init(asymmetricCipherKeyPair2.getPrivate(), cipherParameters, new ECIESPublicKeyParser(eCDomainParameters));
        byte[] byArray5 = Hex.decode("1234567890abcdef");
        byte[] byArray6 = ethereumIESEngine.processBlock(byArray5, 0, byArray5.length);
        byte[] byArray7 = ethereumIESEngine2.processBlock(byArray6, 0, byArray6.length);
        if (!this.areEqual(byArray7, byArray5)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        ethereumIESEngine = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray2, paddedBufferedBlockCipher);
        ethereumIESEngine2 = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray2, paddedBufferedBlockCipher2);
        byArray3 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byArray4 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        cipherParameters = new IESWithCipherParameters(byArray3, byArray4, 64, 128);
        if (byArray != null) {
            cipherParameters = new ParametersWithIV(cipherParameters, byArray);
        }
        ethereumIESEngine.init(asymmetricCipherKeyPair2.getPublic(), cipherParameters, ephemeralKeyPairGenerator);
        ethereumIESEngine2.init(asymmetricCipherKeyPair2.getPrivate(), cipherParameters, new ECIESPublicKeyParser(eCDomainParameters));
        byArray5 = Hex.decode("1234567890abcdef");
        byArray6 = ethereumIESEngine.processBlock(byArray5, 0, byArray5.length);
        byArray7 = ethereumIESEngine2.processBlock(byArray6, 0, byArray6.length);
        if (!this.areEqual(byArray7, byArray5)) {
            this.fail("twofish cipher test failed");
        }
    }

    private void doShortTest(byte[] byArray) throws Exception {
        block7: {
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4;
            ParametersWithIV parametersWithIV;
            EthereumIESEngine ethereumIESEngine;
            EthereumIESEngine ethereumIESEngine2;
            AsymmetricCipherKeyPair asymmetricCipherKeyPair;
            ECDomainParameters eCDomainParameters;
            block6: {
                BigInteger bigInteger = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
                ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), bigInteger, ECConstants.ONE);
                eCDomainParameters = new ECDomainParameters(fp, fp.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), bigInteger);
                ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), eCDomainParameters);
                ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(fp.decodePoint(Hex.decode("0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), eCDomainParameters);
                AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
                asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
                byte[] byArray5 = Hex.decode("0262b12d60690cdcf330baba03188da80eb03090f67cbf2043a18800f4ff0a0262b12d60690cdcf330bab6e69763b471f994dd2d16a5fd82ff1012b6e69763b4");
                ethereumIESEngine2 = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray5);
                ethereumIESEngine = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray5);
                byte[] byArray6 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
                byte[] byArray7 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
                parametersWithIV = new ParametersWithIV(new IESParameters(byArray6, byArray7, 64), new byte[32]);
                ethereumIESEngine2.init(true, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), parametersWithIV);
                ethereumIESEngine.init(false, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), parametersWithIV);
                byArray4 = new byte[]{};
                byArray3 = ethereumIESEngine2.processBlock(byArray4, 0, byArray4.length);
                byArray2 = ethereumIESEngine.processBlock(byArray3, 0, byArray3.length);
                if (!this.areEqual(byArray2, byArray4)) {
                    this.fail("stream cipher test failed");
                }
                try {
                    ethereumIESEngine.processBlock(byArray3, 0, byArray3.length - 1);
                    this.fail("no exception");
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    if ("length of input must be greater than the MAC and V combined".equals(invalidCipherTextException.getMessage())) break block6;
                    this.fail("wrong exception");
                }
            }
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            eCKeyPairGenerator.init(new ECKeyGenerationParameters(eCDomainParameters, new SecureRandom()));
            EphemeralKeyPairGenerator ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator(eCKeyPairGenerator, new KeyEncoder(){

                public byte[] getEncoded(AsymmetricKeyParameter asymmetricKeyParameter) {
                    return ((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getEncoded(false);
                }
            });
            ethereumIESEngine2.init(asymmetricCipherKeyPair.getPublic(), (CipherParameters)parametersWithIV, ephemeralKeyPairGenerator);
            ethereumIESEngine.init(asymmetricCipherKeyPair.getPrivate(), (CipherParameters)parametersWithIV, new ECIESPublicKeyParser(eCDomainParameters));
            byArray3 = ethereumIESEngine2.processBlock(byArray4, 0, byArray4.length);
            byArray2 = ethereumIESEngine.processBlock(byArray3, 0, byArray3.length);
            if (!this.areEqual(byArray2, byArray4)) {
                this.fail("V cipher test failed");
            }
            try {
                ethereumIESEngine.processBlock(byArray3, 0, byArray3.length - 1);
                this.fail("no exception");
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if ("length of input must be greater than the MAC and V combined".equals(invalidCipherTextException.getMessage())) break block7;
                this.fail("wrong exception");
            }
        }
    }

    private void doStaticTest(byte[] byArray) throws Exception {
        byte[] byArray2;
        BigInteger bigInteger = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), bigInteger, ECConstants.ONE);
        ECDomainParameters eCDomainParameters = new ECDomainParameters(fp, fp.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), bigInteger);
        ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), eCDomainParameters);
        ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(fp.decodePoint(Hex.decode("0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), eCDomainParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
        byte[] byArray3 = Hex.decode("0262b12d60690cdcf330baba03188da80eb03090f67cbf2043a18800f4ff0a0262b12d60690cdcf330bab6e69763b471f994dd2d16a5fd82ff1012b6e69763b4");
        EthereumIESEngine ethereumIESEngine = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray3);
        EthereumIESEngine ethereumIESEngine2 = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray3);
        byte[] byArray4 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray5 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        CipherParameters cipherParameters = new ParametersWithIV(new IESParameters(byArray4, byArray5, 64), new byte[32]);
        ethereumIESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), cipherParameters);
        ethereumIESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), cipherParameters);
        byte[] byArray6 = Hex.decode("1234567890abcdef");
        byte[] byArray7 = ethereumIESEngine.processBlock(byArray6, 0, byArray6.length);
        if (!this.areEqual(byArray7, Hex.decode("fb493cdaaa2938daaa2fbbf0886f3b9575c810db240eb9f4adb9089b"))) {
            this.fail("stream cipher test failed on enc");
        }
        if (!this.areEqual(byArray2 = ethereumIESEngine2.processBlock(byArray7, 0, byArray7.length), byArray6)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        ethereumIESEngine = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray3, paddedBufferedBlockCipher);
        ethereumIESEngine2 = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray3, paddedBufferedBlockCipher2);
        byArray4 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byArray5 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        cipherParameters = new IESWithCipherParameters(byArray4, byArray5, 64, 128);
        if (byArray != null) {
            cipherParameters = new ParametersWithIV(cipherParameters, byArray);
        }
        ethereumIESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), cipherParameters);
        ethereumIESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), cipherParameters);
        byArray6 = Hex.decode("1234567890abcdef");
        byArray7 = ethereumIESEngine.processBlock(byArray6, 0, byArray6.length);
        if (!this.areEqual(byArray7, byArray == null ? Hex.decode("b8a06ea5c2b9df28b58a0a90a734cde8c9c02903e5c220021fe4417410d1e53a32a71696") : Hex.decode("34bb9676b087d0b3a016e70a93c4afcb507882a53c5ca7a770913e654ff1422c4b236cbf"))) {
            this.fail("twofish cipher test failed on enc");
        }
        if (!this.areEqual(byArray2 = ethereumIESEngine2.processBlock(byArray7, 0, byArray7.length), byArray6)) {
            this.fail("twofish cipher test failed");
        }
    }

    private void doTest(AsymmetricCipherKeyPair asymmetricCipherKeyPair, AsymmetricCipherKeyPair asymmetricCipherKeyPair2) throws Exception {
        byte[] byArray = Hex.decode("0262b12d60690cdcf330baba03188da80eb03090f67cbf2043a18800f4ff0a0262b12d60690cdcf330bab6e69763b471f994dd2d16a5fd82ff1012b6e69763b4");
        EthereumIESEngine ethereumIESEngine = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray);
        EthereumIESEngine ethereumIESEngine2 = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray);
        byte[] byArray2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray3 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        ParametersWithIV parametersWithIV = new ParametersWithIV(new IESParameters(byArray2, byArray3, 64), new byte[32]);
        ethereumIESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), parametersWithIV);
        ethereumIESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), parametersWithIV);
        byte[] byArray4 = Hex.decode("1234567890abcdef");
        byte[] byArray5 = ethereumIESEngine.processBlock(byArray4, 0, byArray4.length);
        byte[] byArray6 = ethereumIESEngine2.processBlock(byArray5, 0, byArray5.length);
        if (!this.areEqual(byArray6, byArray4)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        ethereumIESEngine = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray, paddedBufferedBlockCipher);
        ethereumIESEngine2 = new EthereumIESEngine(new ECDHBasicAgreement(), new EthereumIESEngine.HandshakeKDFFunction(1, new SHA1Digest()), new HMac(new SHA1Digest()), byArray, paddedBufferedBlockCipher2);
        byArray2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byArray3 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        parametersWithIV = new ParametersWithIV(new IESWithCipherParameters(byArray2, byArray3, 64, 128), new byte[16]);
        ethereumIESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), parametersWithIV);
        ethereumIESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), parametersWithIV);
        byArray4 = Hex.decode("1234567890abcdef");
        byArray5 = ethereumIESEngine.processBlock(byArray4, 0, byArray4.length);
        byArray6 = ethereumIESEngine2.processBlock(byArray5, 0, byArray5.length);
        if (!this.areEqual(byArray6, byArray4)) {
            this.fail("twofish cipher test failed");
        }
    }

    public String getName() {
        return "EthereumIES";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new EthereumIESTest());
    }

    public void performTest() throws Exception {
        this.doStaticTest(TWOFISH_IV);
        this.doShortTest(null);
        BigInteger bigInteger = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), bigInteger, ECConstants.ONE);
        ECDomainParameters eCDomainParameters = new ECDomainParameters(fp, fp.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), bigInteger);
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, new SecureRandom());
        eCKeyPairGenerator.init(eCKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = eCKeyPairGenerator.generateKeyPair();
        this.doTest(asymmetricCipherKeyPair, asymmetricCipherKeyPair2);
        this.doEphemeralTest(TWOFISH_IV, false);
        this.doEphemeralTest(TWOFISH_IV, true);
    }
}

