/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.generators.Ed448KeyPairGenerator;
import org.bouncycastle.crypto.params.Ed448KeyGenerationParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.crypto.signers.Ed448phSigner;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class Ed448Test
extends SimpleTest {
    private static final SecureRandom RANDOM = new SecureRandom();

    private void basicSigTest() throws Exception {
        Ed448PrivateKeyParameters ed448PrivateKeyParameters = new Ed448PrivateKeyParameters(Hex.decode("6c82a562cb808d10d632be89c8513ebf6c929f34ddfa8c9f63c9960ef6e348a3528c8a3fcc2f044e39a3fc5b94492f8f032e7549a20098f95b"));
        Ed448PublicKeyParameters ed448PublicKeyParameters = new Ed448PublicKeyParameters(Hex.decode("5fd7449b59b461fd2ce787ec616ad46a1da1342485a70e1f8a0ea75d80e96778edf124769b46c7061bd6783df1e50f6cd1fa1abeafe8256180"));
        byte[] byArray = Hex.decode("533a37f6bbe457251f023c0d88f976ae2dfb504a843e34d2074fd823d41a591f2b233f034f628281f2fd7a22ddd47d7828c59bd0a21bfd3980ff0d2028d4b18a9df63e006c5d1c2d345b925d8dc00b4104852db99ac5c7cdda8530a113a0f4dbb61149f05a7363268c71d95808ff2e652600");
        Ed448Signer ed448Signer = new Ed448Signer(new byte[0]);
        ed448Signer.init(true, ed448PrivateKeyParameters);
        this.isTrue(this.areEqual(byArray, ed448Signer.generateSignature()));
        ed448Signer.init(false, ed448PublicKeyParameters);
        this.isTrue(ed448Signer.verifySignature(byArray));
    }

    private Signer createSigner(int n, byte[] byArray) {
        switch (n) {
            case 0: {
                return new Ed448Signer(byArray);
            }
            case 1: {
                return new Ed448phSigner(byArray);
            }
        }
        throw new IllegalArgumentException("algorithm");
    }

    public String getName() {
        return "Ed448";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new Ed448Test());
    }

    public void performTest() throws Exception {
        this.basicSigTest();
        int n = 0;
        while (n < 10) {
            byte[] byArray = this.randomContext(RANDOM.nextInt() & 0xFF);
            this.testConsistency(0, byArray);
            this.testConsistency(1, byArray);
            ++n;
        }
    }

    private byte[] randomContext(int n) {
        byte[] byArray = new byte[n];
        RANDOM.nextBytes(byArray);
        return byArray;
    }

    private void testConsistency(int n, byte[] byArray) throws Exception {
        boolean bl;
        Ed448KeyPairGenerator ed448KeyPairGenerator = new Ed448KeyPairGenerator();
        ed448KeyPairGenerator.init(new Ed448KeyGenerationParameters(RANDOM));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = ed448KeyPairGenerator.generateKeyPair();
        Ed448PrivateKeyParameters ed448PrivateKeyParameters = (Ed448PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        Ed448PublicKeyParameters ed448PublicKeyParameters = (Ed448PublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        byte[] byArray2 = new byte[RANDOM.nextInt() & 0xFF];
        RANDOM.nextBytes(byArray2);
        Signer signer = this.createSigner(n, byArray);
        signer.init(true, ed448PrivateKeyParameters);
        signer.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = signer.generateSignature();
        Signer signer2 = this.createSigner(n, byArray);
        signer2.init(false, ed448PublicKeyParameters);
        signer2.update(byArray2, 0, byArray2.length);
        boolean bl2 = signer2.verifySignature(byArray3);
        if (!bl2) {
            this.fail("Ed448(" + n + ") signature failed to verify");
        }
        byte[] byArray4 = Arrays.append(byArray3, (byte)0);
        signer2.init(false, ed448PublicKeyParameters);
        signer2.update(byArray2, 0, byArray2.length);
        boolean bl3 = signer2.verifySignature(byArray4);
        if (bl3) {
            this.fail("Ed448(" + n + ") wrong length signature incorrectly verified");
        }
        if (byArray2.length > 0 && (bl = signer2.verifySignature(byArray3))) {
            this.fail("Ed448(" + n + ") wrong length failure did not reset verifier");
        }
        byte[] byArray5 = Arrays.clone(byArray3);
        int n2 = (RANDOM.nextInt() >>> 1) % byArray5.length;
        byArray5[n2] = (byte)(byArray5[n2] ^ 1 << (RANDOM.nextInt() & 7));
        signer2.init(false, ed448PublicKeyParameters);
        signer2.update(byArray2, 0, byArray2.length);
        boolean bl4 = signer2.verifySignature(byArray5);
        if (bl4) {
            this.fail("Ed448(" + n + ") bad signature incorrectly verified");
        }
    }
}

