/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed25519ctxSigner;
import org.bouncycastle.crypto.signers.Ed25519phSigner;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class Ed25519Test
extends SimpleTest {
    private static final SecureRandom RANDOM = new SecureRandom();

    private void basicSigTest() throws Exception {
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = new Ed25519PrivateKeyParameters(Hex.decode("9d61b19deffd5a60ba844af492ec2cc44449c5697b326919703bac031cae7f60"));
        Ed25519PublicKeyParameters ed25519PublicKeyParameters = new Ed25519PublicKeyParameters(Hex.decode("d75a980182b10ab7d54bfed3c964073a0ee172f3daa62325af021a68f707511a"));
        byte[] byArray = Hex.decode("e5564300c360ac729086e2cc806e828a84877f1eb8e5d974d873e065224901555fb8821590a33bacc61e39701cf9b46bd25bf5f0595bbe24655141438e7a100b");
        Ed25519Signer ed25519Signer = new Ed25519Signer();
        ed25519Signer.init(true, ed25519PrivateKeyParameters);
        this.isTrue(this.areEqual(byArray, ed25519Signer.generateSignature()));
        ed25519Signer.init(false, ed25519PublicKeyParameters);
        this.isTrue(ed25519Signer.verifySignature(byArray));
    }

    private Signer createSigner(int n, byte[] byArray) {
        switch (n) {
            case 0: {
                return new Ed25519Signer();
            }
            case 1: {
                return new Ed25519ctxSigner(byArray);
            }
            case 2: {
                return new Ed25519phSigner(byArray);
            }
        }
        throw new IllegalArgumentException("algorithm");
    }

    public String getName() {
        return "Ed25519";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new Ed25519Test());
    }

    public void performTest() throws Exception {
        this.basicSigTest();
        int n = 0;
        while (n < 10) {
            this.testConsistency(0, null);
            byte[] byArray = this.randomContext(RANDOM.nextInt() & 0xFF);
            this.testConsistency(1, byArray);
            this.testConsistency(2, byArray);
            ++n;
        }
    }

    private byte[] randomContext(int n) {
        byte[] byArray = new byte[n];
        RANDOM.nextBytes(byArray);
        return byArray;
    }

    private void testConsistency(int n, byte[] byArray) throws Exception {
        boolean bl;
        Ed25519KeyPairGenerator ed25519KeyPairGenerator = new Ed25519KeyPairGenerator();
        ed25519KeyPairGenerator.init(new Ed25519KeyGenerationParameters(RANDOM));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = ed25519KeyPairGenerator.generateKeyPair();
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = (Ed25519PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        Ed25519PublicKeyParameters ed25519PublicKeyParameters = (Ed25519PublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        byte[] byArray2 = new byte[RANDOM.nextInt() & 0xFF];
        RANDOM.nextBytes(byArray2);
        Signer signer = this.createSigner(n, byArray);
        signer.init(true, ed25519PrivateKeyParameters);
        signer.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = signer.generateSignature();
        Signer signer2 = this.createSigner(n, byArray);
        signer2.init(false, ed25519PublicKeyParameters);
        signer2.update(byArray2, 0, byArray2.length);
        boolean bl2 = signer2.verifySignature(byArray3);
        if (!bl2) {
            this.fail("Ed25519(" + n + ") signature failed to verify");
        }
        byte[] byArray4 = Arrays.append(byArray3, (byte)0);
        signer2.init(false, ed25519PublicKeyParameters);
        signer2.update(byArray2, 0, byArray2.length);
        boolean bl3 = signer2.verifySignature(byArray4);
        if (bl3) {
            this.fail("Ed25519(" + n + ") wrong length signature incorrectly verified");
        }
        if (byArray2.length > 0 && (bl = signer2.verifySignature(byArray3))) {
            this.fail("Ed25519(" + n + ") wrong length failure did not reset verifier");
        }
        byte[] byArray5 = Arrays.clone(byArray3);
        int n2 = (RANDOM.nextInt() >>> 1) % byArray5.length;
        byArray5[n2] = (byte)(byArray5[n2] ^ 1 << (RANDOM.nextInt() & 7));
        signer2.init(false, ed25519PublicKeyParameters);
        signer2.update(byArray2, 0, byArray2.length);
        boolean bl4 = signer2.verifySignature(byArray5);
        if (bl4) {
            this.fail("Ed25519(" + n + ") bad signature incorrectly verified");
        }
    }
}

