/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.digests.TigerDigest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.ECNRSigner;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestRandomBigInteger;

public class ECNRTest
extends SimpleTest {
    BigInteger r = new BigInteger("308636143175167811492623515537541734843573549327605293463169625072911693");
    BigInteger s = new BigInteger("852401710738814635664888632022555967400445256405412579597015412971797143");
    byte[] kData = BigIntegers.asUnsignedByteArray(new BigInteger("700000017569056646655505781757157107570501575775705779575555657156756655"));
    SecureRandom k = new TestRandomBigInteger(this.kData);

    private void ecNR239bitPrime() {
        BigInteger bigInteger = new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307");
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16), bigInteger, ECConstants.ONE);
        ECDomainParameters eCDomainParameters = new ECDomainParameters(fp, fp.decodePoint(Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), bigInteger);
        ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger("876300101507107567501066130761671078357010671067781776716671676178726717"), eCDomainParameters);
        ECNRSigner eCNRSigner = new ECNRSigner();
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom(eCPrivateKeyParameters, this.k);
        eCNRSigner.init(true, parametersWithRandom);
        byte[] byArray = new BigInteger("968236873715988614170569073515315707566766479517").toByteArray();
        BigInteger[] bigIntegerArray = eCNRSigner.generateSignature(byArray);
        if (!this.r.equals(bigIntegerArray[0])) {
            this.fail("r component wrong.", this.r, bigIntegerArray[0]);
        }
        if (!this.s.equals(bigIntegerArray[1])) {
            this.fail("s component wrong.", this.s, bigIntegerArray[1]);
        }
        ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(fp.decodePoint(Hex.decode("025b6dc53bc61a2548ffb0f671472de6c9521a9d2d2534e65abfcbd5fe0c70")), eCDomainParameters);
        eCNRSigner.init(false, eCPublicKeyParameters);
        if (!eCNRSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1])) {
            this.fail("signature fails");
        }
    }

    public String getName() {
        return "ECNR";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new ECNRTest());
    }

    public void performTest() {
        this.ecNR239bitPrime();
        this.rangeTest();
    }

    private void rangeTest() {
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        SecureRandom secureRandom = new SecureRandom();
        String string = "brainpoolP192t1";
        X9ECParameters x9ECParameters = ECNamedCurveTable.getByName(string);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = ECNamedCurveTable.getOID(string);
        ECNamedDomainParameters eCNamedDomainParameters = new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCNamedDomainParameters, secureRandom);
        eCKeyPairGenerator.init(eCKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        TigerDigest tigerDigest = new TigerDigest();
        byte[] byArray = new byte[tigerDigest.getDigestSize()];
        byte[] byArray2 = "Hello there. How is life treating you?".getBytes();
        tigerDigest.update(byArray2, 0, byArray2.length);
        tigerDigest.doFinal(byArray, 0);
        ECNRSigner eCNRSigner = new ECNRSigner();
        eCNRSigner.init(true, asymmetricCipherKeyPair.getPrivate());
        try {
            eCNRSigner.generateSignature(byArray);
            this.fail("out of range input not caught");
        }
        catch (DataLengthException dataLengthException) {
            this.isTrue(dataLengthException.getMessage().equals("input too large for ECNR key"));
        }
        BigInteger bigInteger = ((ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getParameters().getN();
        eCNRSigner.init(true, asymmetricCipherKeyPair.getPrivate());
        byte[] byArray3 = BigIntegers.asUnsignedByteArray(bigInteger.subtract(BigIntegers.ONE));
        BigInteger[] bigIntegerArray = eCNRSigner.generateSignature(byArray3);
        eCNRSigner.init(false, asymmetricCipherKeyPair.getPublic());
        if (!eCNRSigner.verifySignature(byArray3, bigIntegerArray[0], bigIntegerArray[1])) {
            this.fail("ECNR failed 2");
        }
        this.isTrue(Arrays.areEqual(byArray3, eCNRSigner.getRecoveredMessage(bigIntegerArray[0], bigIntegerArray[1])));
    }
}

