/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyEncoder;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.kems.ECIESKEMExtractor;
import org.bouncycastle.crypto.kems.ECIESKEMGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.IESParameters;
import org.bouncycastle.crypto.params.IESWithCipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.parsers.ECIESPublicKeyParser;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ECIESTest
extends SimpleTest {
    private static byte[] TWOFISH_IV = Hex.decode("000102030405060708090a0b0c0d0e0f");

    ECIESTest() {
    }

    private void doCofactorTest(boolean bl, boolean bl2) {
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        SecureRandom secureRandom = new SecureRandom();
        String string = "sect571k1";
        X9ECParameters x9ECParameters = ECNamedCurveTable.getByName(string);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = ECNamedCurveTable.getOID(string);
        ECNamedDomainParameters eCNamedDomainParameters = new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCNamedDomainParameters, secureRandom);
        eCKeyPairGenerator.init(eCKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        int n = x9ECParameters.getCurve().getFieldSize();
        n = (n + 8 - 1) / 8;
        int n2 = 2 * n + 1;
        byte[] byArray = new byte[n2];
        int n3 = 32;
        ECIESKEMGenerator eCIESKEMGenerator = new ECIESKEMGenerator(n3, new KDF2BytesGenerator(new SHA512Digest()), secureRandom, bl, bl2, false);
        SecretWithEncapsulation secretWithEncapsulation = eCIESKEMGenerator.generateEncapsulated(asymmetricCipherKeyPair.getPublic());
        KeyParameter keyParameter = new KeyParameter(secretWithEncapsulation.getSecret());
        byte[] byArray2 = keyParameter.getKey();
        ECIESKEMExtractor eCIESKEMExtractor = new ECIESKEMExtractor((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), n3, new KDF2BytesGenerator(new SHA512Digest()), bl, bl2, false);
        KeyParameter keyParameter2 = new KeyParameter(eCIESKEMExtractor.extractSecret(secretWithEncapsulation.getEncapsulation()));
        byte[] byArray3 = keyParameter2.getKey();
        this.isTrue("new " + bl + " old " + bl2, Arrays.areEqual(byArray2, byArray3));
    }

    private void doEphemeralTest(byte[] byArray, final boolean bl) throws Exception {
        BigInteger bigInteger = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), bigInteger, ECConstants.ONE);
        ECDomainParameters eCDomainParameters = new ECDomainParameters(fp, fp.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), bigInteger);
        ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), eCDomainParameters);
        ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(fp.decodePoint(Hex.decode("0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), eCDomainParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(eCDomainParameters, new SecureRandom()));
        EphemeralKeyPairGenerator ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator(eCKeyPairGenerator, new KeyEncoder(){

            public byte[] getEncoded(AsymmetricKeyParameter asymmetricKeyParameter) {
                return ((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getEncoded(bl);
            }
        });
        IESEngine iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        IESEngine iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        byte[] byArray2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray3 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        CipherParameters cipherParameters = new IESParameters(byArray2, byArray3, 64);
        iESEngine.init(asymmetricCipherKeyPair2.getPublic(), cipherParameters, ephemeralKeyPairGenerator);
        iESEngine2.init(asymmetricCipherKeyPair2.getPrivate(), cipherParameters, new ECIESPublicKeyParser(eCDomainParameters));
        byte[] byArray4 = Hex.decode("1234567890abcdef");
        byte[] byArray5 = iESEngine.processBlock(byArray4, 0, byArray4.length);
        byte[] byArray6 = iESEngine2.processBlock(byArray5, 0, byArray5.length);
        if (!this.areEqual(byArray6, byArray4)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), paddedBufferedBlockCipher);
        iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), paddedBufferedBlockCipher2);
        byArray2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byArray3 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        cipherParameters = new IESWithCipherParameters(byArray2, byArray3, 64, 128);
        if (byArray != null) {
            cipherParameters = new ParametersWithIV(cipherParameters, byArray);
        }
        iESEngine.init(asymmetricCipherKeyPair2.getPublic(), cipherParameters, ephemeralKeyPairGenerator);
        iESEngine2.init(asymmetricCipherKeyPair2.getPrivate(), cipherParameters, new ECIESPublicKeyParser(eCDomainParameters));
        byArray4 = Hex.decode("1234567890abcdef");
        byArray5 = iESEngine.processBlock(byArray4, 0, byArray4.length);
        byArray6 = iESEngine2.processBlock(byArray5, 0, byArray5.length);
        if (!this.areEqual(byArray6, byArray4)) {
            this.fail("twofish cipher test failed");
        }
    }

    private void doShortTest(byte[] byArray) throws Exception {
        block7: {
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4;
            IESParameters iESParameters;
            IESEngine iESEngine;
            IESEngine iESEngine2;
            AsymmetricCipherKeyPair asymmetricCipherKeyPair;
            ECDomainParameters eCDomainParameters;
            block6: {
                BigInteger bigInteger = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
                ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), bigInteger, ECConstants.ONE);
                eCDomainParameters = new ECDomainParameters(fp, fp.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), bigInteger);
                ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), eCDomainParameters);
                ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(fp.decodePoint(Hex.decode("0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), eCDomainParameters);
                AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
                asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
                iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
                iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
                byte[] byArray5 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
                byte[] byArray6 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
                iESParameters = new IESParameters(byArray5, byArray6, 64);
                iESEngine2.init(true, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), iESParameters);
                iESEngine.init(false, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), iESParameters);
                byArray4 = new byte[]{};
                byArray3 = iESEngine2.processBlock(byArray4, 0, byArray4.length);
                byArray2 = iESEngine.processBlock(byArray3, 0, byArray3.length);
                if (!this.areEqual(byArray2, byArray4)) {
                    this.fail("stream cipher test failed");
                }
                try {
                    iESEngine.processBlock(byArray3, 0, byArray3.length - 1);
                    this.fail("no exception");
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    if ("Length of input must be greater than the MAC and V combined".equals(invalidCipherTextException.getMessage())) break block6;
                    this.fail("wrong exception");
                }
            }
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            eCKeyPairGenerator.init(new ECKeyGenerationParameters(eCDomainParameters, new SecureRandom()));
            EphemeralKeyPairGenerator ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator(eCKeyPairGenerator, new KeyEncoder(){

                public byte[] getEncoded(AsymmetricKeyParameter asymmetricKeyParameter) {
                    return ((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getEncoded(false);
                }
            });
            iESEngine2.init(asymmetricCipherKeyPair.getPublic(), (CipherParameters)iESParameters, ephemeralKeyPairGenerator);
            iESEngine.init(asymmetricCipherKeyPair.getPrivate(), (CipherParameters)iESParameters, new ECIESPublicKeyParser(eCDomainParameters));
            byArray3 = iESEngine2.processBlock(byArray4, 0, byArray4.length);
            byArray2 = iESEngine.processBlock(byArray3, 0, byArray3.length);
            if (!this.areEqual(byArray2, byArray4)) {
                this.fail("V cipher test failed");
            }
            try {
                iESEngine.processBlock(byArray3, 0, byArray3.length - 1);
                this.fail("no exception");
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if ("Length of input must be greater than the MAC and V combined".equals(invalidCipherTextException.getMessage())) break block7;
                this.fail("wrong exception");
            }
        }
    }

    private void doStaticTest(byte[] byArray) throws Exception {
        byte[] byArray2;
        BigInteger bigInteger = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), bigInteger, ECConstants.ONE);
        ECDomainParameters eCDomainParameters = new ECDomainParameters(fp, fp.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), bigInteger);
        ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), eCDomainParameters);
        ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(fp.decodePoint(Hex.decode("0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), eCDomainParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
        IESEngine iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        IESEngine iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        byte[] byArray3 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray4 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        CipherParameters cipherParameters = new IESParameters(byArray3, byArray4, 64);
        iESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), cipherParameters);
        iESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), cipherParameters);
        byte[] byArray5 = Hex.decode("1234567890abcdef");
        byte[] byArray6 = iESEngine.processBlock(byArray5, 0, byArray5.length);
        if (!this.areEqual(byArray6, Hex.decode("468d89877e8238802403ec4cb6b329faeccfa6f3a730f2cdb3c0a8e8"))) {
            this.fail("stream cipher test failed on enc");
        }
        if (!this.areEqual(byArray2 = iESEngine2.processBlock(byArray6, 0, byArray6.length), byArray5)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), paddedBufferedBlockCipher);
        iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), paddedBufferedBlockCipher2);
        byArray3 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byArray4 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        cipherParameters = new IESWithCipherParameters(byArray3, byArray4, 64, 128);
        if (byArray != null) {
            cipherParameters = new ParametersWithIV(cipherParameters, byArray);
        }
        iESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), cipherParameters);
        iESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), cipherParameters);
        byArray5 = Hex.decode("1234567890abcdef");
        byArray6 = iESEngine.processBlock(byArray5, 0, byArray5.length);
        if (!this.areEqual(byArray6, byArray == null ? Hex.decode("b8a06ea5c2b9df28b58a0a90a734cde8c9c02903e5c220021fe4417410d1e53a32a71696") : Hex.decode("f246b0e26a2711992cac9c590d08e45c5e730b7c0f4218bb064e27b7dd7c8a3bd8bf01c3"))) {
            this.fail("twofish cipher test failed on enc");
        }
        if (!this.areEqual(byArray2 = iESEngine2.processBlock(byArray6, 0, byArray6.length), byArray5)) {
            this.fail("twofish cipher test failed");
        }
    }

    private void doTest(AsymmetricCipherKeyPair asymmetricCipherKeyPair, AsymmetricCipherKeyPair asymmetricCipherKeyPair2) throws Exception {
        IESEngine iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        IESEngine iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray2 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameters iESParameters = new IESParameters(byArray, byArray2, 64);
        iESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), iESParameters);
        iESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), iESParameters);
        byte[] byArray3 = Hex.decode("1234567890abcdef");
        byte[] byArray4 = iESEngine.processBlock(byArray3, 0, byArray3.length);
        byte[] byArray5 = iESEngine2.processBlock(byArray4, 0, byArray4.length);
        if (!this.areEqual(byArray5, byArray3)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), paddedBufferedBlockCipher);
        iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), paddedBufferedBlockCipher2);
        byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byArray2 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        iESParameters = new IESWithCipherParameters(byArray, byArray2, 64, 128);
        iESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), iESParameters);
        iESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), iESParameters);
        byArray3 = Hex.decode("1234567890abcdef");
        byArray4 = iESEngine.processBlock(byArray3, 0, byArray3.length);
        byArray5 = iESEngine2.processBlock(byArray4, 0, byArray4.length);
        if (!this.areEqual(byArray5, byArray3)) {
            this.fail("twofish cipher test failed");
        }
    }

    public String getName() {
        return "ECIES";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new ECIESTest());
    }

    public void performTest() throws Exception {
        this.doStaticTest(null);
        this.doStaticTest(TWOFISH_IV);
        this.doShortTest(null);
        BigInteger bigInteger = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), bigInteger, ECConstants.ONE);
        ECDomainParameters eCDomainParameters = new ECDomainParameters(fp, fp.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), bigInteger);
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, new SecureRandom());
        eCKeyPairGenerator.init(eCKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = eCKeyPairGenerator.generateKeyPair();
        this.doTest(asymmetricCipherKeyPair, asymmetricCipherKeyPair2);
        this.doEphemeralTest(null, false);
        this.doEphemeralTest(null, true);
        this.doEphemeralTest(TWOFISH_IV, false);
        this.doEphemeralTest(TWOFISH_IV, true);
        this.doCofactorTest(true, false);
        this.doCofactorTest(false, false);
        this.doCofactorTest(false, true);
        this.doCofactorTest(true, true);
    }
}

