/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.kems.ECIESKEMExtractor;
import org.bouncycastle.crypto.kems.ECIESKEMGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.test.SimpleTest;

public class ECIESKeyEncapsulationTest
extends SimpleTest {
    public String getName() {
        return "ECIESKeyEncapsulation";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new ECIESKeyEncapsulationTest());
    }

    public void performTest() throws Exception {
        X9ECParameters x9ECParameters = SECNamedCurves.getByName("secp224r1");
        ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(eCDomainParameters, new SecureRandom()));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        KDF2BytesGenerator kDF2BytesGenerator = new KDF2BytesGenerator(new SHA1Digest());
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[57];
        ECIESKEMGenerator eCIESKEMGenerator = new ECIESKEMGenerator(16, kDF2BytesGenerator, secureRandom);
        SecretWithEncapsulation secretWithEncapsulation = eCIESKEMGenerator.generateEncapsulated(asymmetricCipherKeyPair.getPublic());
        KeyParameter keyParameter = new KeyParameter(secretWithEncapsulation.getSecret());
        ECIESKEMExtractor eCIESKEMExtractor = new ECIESKEMExtractor((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), 16, kDF2BytesGenerator);
        KeyParameter keyParameter2 = new KeyParameter(eCIESKEMExtractor.extractSecret(secretWithEncapsulation.getEncapsulation()));
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed basic test");
        }
        eCIESKEMGenerator = new ECIESKEMGenerator(16, kDF2BytesGenerator, secureRandom, true, false, false);
        secretWithEncapsulation = eCIESKEMGenerator.generateEncapsulated(asymmetricCipherKeyPair.getPublic());
        keyParameter = new KeyParameter(secretWithEncapsulation.getSecret());
        eCIESKEMExtractor = new ECIESKEMExtractor((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), 16, kDF2BytesGenerator, true, false, false);
        keyParameter2 = new KeyParameter(eCIESKEMExtractor.extractSecret(secretWithEncapsulation.getEncapsulation()));
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed cofactor test");
        }
        eCIESKEMGenerator = new ECIESKEMGenerator(16, kDF2BytesGenerator, secureRandom, false, true, false);
        secretWithEncapsulation = eCIESKEMGenerator.generateEncapsulated(asymmetricCipherKeyPair.getPublic());
        keyParameter = new KeyParameter(secretWithEncapsulation.getSecret());
        eCIESKEMExtractor = new ECIESKEMExtractor((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), 16, kDF2BytesGenerator, false, true, false);
        keyParameter2 = new KeyParameter(eCIESKEMExtractor.extractSecret(secretWithEncapsulation.getEncapsulation()));
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed old cofactor test");
        }
        eCIESKEMGenerator = new ECIESKEMGenerator(16, kDF2BytesGenerator, secureRandom, false, false, true);
        secretWithEncapsulation = eCIESKEMGenerator.generateEncapsulated(asymmetricCipherKeyPair.getPublic());
        keyParameter = new KeyParameter(secretWithEncapsulation.getSecret());
        eCIESKEMExtractor = new ECIESKEMExtractor((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), 16, kDF2BytesGenerator, false, false, true);
        keyParameter2 = new KeyParameter(eCIESKEMExtractor.extractSecret(secretWithEncapsulation.getEncapsulation()));
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed single hash test");
        }
        eCIESKEMGenerator = new ECIESKEMGenerator(16, kDF2BytesGenerator, secureRandom, true, false, true);
        secretWithEncapsulation = eCIESKEMGenerator.generateEncapsulated(asymmetricCipherKeyPair.getPublic());
        keyParameter = new KeyParameter(secretWithEncapsulation.getSecret());
        eCIESKEMExtractor = new ECIESKEMExtractor((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), 16, kDF2BytesGenerator, true, false, true);
        keyParameter2 = new KeyParameter(eCIESKEMExtractor.extractSecret(secretWithEncapsulation.getEncapsulation()));
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed cofactor and single hash test");
        }
        eCIESKEMGenerator = new ECIESKEMGenerator(16, kDF2BytesGenerator, secureRandom, false, true, true);
        secretWithEncapsulation = eCIESKEMGenerator.generateEncapsulated(asymmetricCipherKeyPair.getPublic());
        keyParameter = new KeyParameter(secretWithEncapsulation.getSecret());
        eCIESKEMExtractor = new ECIESKEMExtractor((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), 16, kDF2BytesGenerator, false, true, true);
        keyParameter2 = new KeyParameter(eCIESKEMExtractor.extractSecret(secretWithEncapsulation.getEncapsulation()));
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed old cofactor and single hash test");
        }
    }
}

