/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.DESedeWrapEngine;
import org.bouncycastle.crypto.generators.DESedeKeyGenerator;
import org.bouncycastle.crypto.params.DESedeParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.test.BlockCipherVectorTest;
import org.bouncycastle.crypto.test.CipherTest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class DESedeTest
extends CipherTest {
    private static byte[] weakKey = new byte[]{6, 1, 1, 1, 1, 1, 1, 1, 31, 31, 31, 31, 14, 14, 14, 14, -32, -32, -32, -32, -15, -15, -15, -15};
    static String input1 = "4e6f77206973207468652074696d6520666f7220616c6c20";
    static String input2 = "4e6f7720697320746865";
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(0, new DESedeEngine(), new DESedeParameters(Hex.decode("0123456789abcdef0123456789abcdef")), input1, "3fa40e8a984d48156a271787ab8883f9893d51ec4b563b53"), new BlockCipherVectorTest(1, new DESedeEngine(), new DESedeParameters(Hex.decode("0123456789abcdeffedcba9876543210")), input1, "d80a0d8b2bae5e4e6a0094171abcfc2775d2235a706e232c"), new BlockCipherVectorTest(2, new DESedeEngine(), new DESedeParameters(Hex.decode("0123456789abcdef0123456789abcdef0123456789abcdef")), input1, "3fa40e8a984d48156a271787ab8883f9893d51ec4b563b53"), new BlockCipherVectorTest(3, new DESedeEngine(), new DESedeParameters(Hex.decode("0123456789abcdeffedcba98765432100123456789abcdef")), input1, "d80a0d8b2bae5e4e6a0094171abcfc2775d2235a706e232c")};

    DESedeTest() {
        super(tests, new DESedeEngine(), new KeyParameter(new byte[16]));
    }

    public String getName() {
        return "DESede";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new DESedeTest());
    }

    public void performTest() throws Exception {
        block9: {
            block8: {
                super.performTest();
                byte[] byArray = Hex.decode("255e0d1c07b646dfb3134cc843ba8aa71f025b7c0838251f");
                byte[] byArray2 = Hex.decode("5dd4cbfc96f5453b");
                byte[] byArray3 = Hex.decode("2923bf85e06dd6ae529149f1f1bae9eab3a7da3d860d3e98");
                byte[] byArray4 = Hex.decode("690107618ef092b3b48ca1796b234ae9fa33ebb4159604037db5d6a84eb3aac2768c632775a467d4");
                this.wrapTest(1, byArray, byArray2, byArray3, byArray4);
                SecureRandom secureRandom = new SecureRandom();
                DESedeKeyGenerator dESedeKeyGenerator = new DESedeKeyGenerator();
                dESedeKeyGenerator.init(new KeyGenerationParameters(secureRandom, 112));
                byte[] byArray5 = dESedeKeyGenerator.generateKey();
                if (byArray5.length != 16) {
                    this.fail("112 bit key wrong length.");
                }
                dESedeKeyGenerator.init(new KeyGenerationParameters(secureRandom, 168));
                byArray5 = dESedeKeyGenerator.generateKey();
                if (byArray5.length != 24) {
                    this.fail("168 bit key wrong length.");
                }
                try {
                    dESedeKeyGenerator.init(new KeyGenerationParameters(secureRandom, 200));
                    this.fail("invalid key length not detected.");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                try {
                    DESedeParameters.isWeakKey(new byte[4], 0);
                    this.fail("no exception on small key");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (illegalArgumentException.getMessage().equals("key material too short.")) break block8;
                    this.fail("wrong exception");
                }
            }
            try {
                new DESedeParameters(weakKey);
                this.fail("no exception on weak key");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (illegalArgumentException.getMessage().equals("attempt to create weak DESede key")) break block9;
                this.fail("wrong exception");
            }
        }
    }

    private void wrapTest(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5;
        DESedeWrapEngine dESedeWrapEngine = new DESedeWrapEngine();
        dESedeWrapEngine.init(true, new ParametersWithIV(new KeyParameter(byArray), byArray2));
        try {
            byArray5 = dESedeWrapEngine.wrap(byArray3, 0, byArray3.length);
            if (!this.areEqual(byArray5, byArray4)) {
                this.fail(": failed wrap test " + n + " expected " + new String(Hex.encode(byArray4)) + " got " + new String(Hex.encode(byArray5)));
            }
        }
        catch (Exception exception) {
            this.fail("failed wrap test exception: " + exception.toString(), exception);
        }
        dESedeWrapEngine.init(false, new KeyParameter(byArray));
        try {
            byArray5 = dESedeWrapEngine.unwrap(byArray4, 0, byArray4.length);
            if (!this.areEqual(byArray5, byArray3)) {
                this.fail("failed unwrap test " + n + " expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray5)));
            }
        }
        catch (Exception exception) {
            this.fail("failed unwrap test exception: " + exception.toString(), exception);
        }
    }
}

