/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.util.Collections;
import org.bouncycastle.crypto.CryptoServiceConstraintsException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.constraints.BitsOfSecurityConstraint;
import org.bouncycastle.crypto.constraints.LegacyBitsOfSecurityConstraint;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class CryptoServiceConstraintsTest
extends SimpleTest {
    public String getName() {
        return "CryptoServiceConstraintsTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new CryptoServiceConstraintsTest());
    }

    public void performTest() throws Exception {
        this.test112bits();
        this.test128bits();
        this.testLegacy128bits();
    }

    private void test112bits() {
        CryptoServicesRegistrar.setServicesConstraints(new BitsOfSecurityConstraint(112));
        try {
            new RC4Engine();
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 112 bits of security only 20", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(new BitsOfSecurityConstraint(112, Collections.singleton("ARC4")));
        new RC4Engine();
        try {
            new DESEngine();
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 112 bits of security only 56", cryptoServiceConstraintsException.getMessage());
        }
        new DESedeEngine();
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void test128bits() {
        CryptoServicesRegistrar.setServicesConstraints(new BitsOfSecurityConstraint(128));
        try {
            new DESedeEngine();
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 112", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(new BitsOfSecurityConstraint(128, Collections.singleton("DESede")));
        new DESedeEngine();
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testLegacy128bits() {
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128));
        DESedeEngine dESedeEngine = new DESedeEngine();
        KeyParameter keyParameter = new KeyParameter(Hex.decode("01020304050607080102030405060708"));
        try {
            dESedeEngine.init(true, keyParameter);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        dESedeEngine.init(false, keyParameter);
        CryptoServicesRegistrar.setServicesConstraints(null);
    }
}

