/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.util.Random;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.agreement.kdf.ConcatenationKDFGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.params.KDFParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ConcatenationKDFTest
extends SimpleTest {
    public String getName() {
        return "ConcatenationKDF";
    }

    private void implKDFPositiveLenTest() {
        String string = "e65b1905878b95f68b5535bd3b2b1013";
        String string2 = "830221b1730d9176f807d407";
        byte[] byArray = Hex.decodeStrict(string);
        byte[] byArray2 = Hex.decodeStrict(string2);
        byte[] byArray3 = new byte[2048];
        ConcatenationKDFGenerator concatenationKDFGenerator = new ConcatenationKDFGenerator(new SHA512Digest());
        concatenationKDFGenerator.init(new KDFParameters(byArray, byArray2));
        try {
            concatenationKDFGenerator.generateBytes(byArray3, 0, 0);
            this.fail("ConcatenationKDF must ignore the len parameter with value zero");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("Expect valid ConcatenationKDF error message", "len must be > 0", illegalArgumentException.getMessage());
        }
        try {
            concatenationKDFGenerator.generateBytes(byArray3, 0, -1);
            this.fail("ConcatenationKDF must ignore the len parameter with negative value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("Expect valid ConcatenationKDF error message", "len must be > 0", illegalArgumentException.getMessage());
        }
    }

    private void implKDFTest(Digest digest, String string, String string2, String string3) {
        byte[] byArray = Hex.decodeStrict(string);
        byte[] byArray2 = Hex.decodeStrict(string2);
        byte[] byArray3 = Hex.decodeStrict(string3);
        byte[] byArray4 = new byte[15 + byArray3.length];
        Random random = new Random();
        ConcatenationKDFGenerator concatenationKDFGenerator = new ConcatenationKDFGenerator(digest);
        int n = 1;
        while (n <= byArray3.length) {
            Arrays.fill(byArray4, (byte)0);
            int n2 = random.nextInt(16);
            concatenationKDFGenerator.init(new KDFParameters(byArray, byArray2));
            concatenationKDFGenerator.generateBytes(byArray4, n2, n);
            if (!Arrays.areEqual(byArray3, 0, n, byArray4, n2, n2 + n)) {
                this.fail("ConcatenationKDF (" + digest.getAlgorithmName() + ") failed for count of " + n);
            }
            ++n;
        }
    }

    private void implSHA1Test() {
        String string = "ebe28edbae5a410b87a479243db3f690";
        String string2 = "e60dd8b28228ce5b9be74d3b";
        String string3 = "b4a23963e07f485382cb358a493daec1759ac7043dbeac37152c6ddf105031f0f239f270b7f30616166f10e5d2b4cb11ba8bf4ba3f2276885abfbc3e811a568d480d9192";
        this.implKDFTest(new SHA1Digest(), string, string2, string3);
    }

    private void implSHA256Test() {
        String string = "3f892bd8b84dae64a782a35f6eaa8f00";
        String string2 = "ec3f1cd873d28858a58cc39e";
        String string3 = "a7c0665298252531e0db37737a374651b368275f2048284d16a166c6d8a90a91a491c16f49641b9f516a03d9d6d0f4fe7b81ffdf1c816f40ecd74aed8eda2b8a3c714fa0";
        this.implKDFTest(new SHA256Digest(), string, string2, string3);
    }

    private void implSHA512Test() {
        String string = "e65b1905878b95f68b5535bd3b2b1013";
        String string2 = "830221b1730d9176f807d407";
        String string3 = "b8c44bdf0b85a64b6a51c12a06710e373d829bb1fda5b4e1a20795c6199594f6fa65198a721257f7d58cb2f6f6db9bb5699f73863045909054b2389e06ec00fe318cabd9";
        this.implKDFTest(new SHA512Digest(), string, string2, string3);
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new ConcatenationKDFTest());
    }

    public void performTest() {
        this.implSHA1Test();
        this.implSHA256Test();
        this.implSHA512Test();
        this.implKDFPositiveLenTest();
    }
}

