/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.test.SimpleTest;

public abstract class CipherTest
extends SimpleTest {
    private SimpleTest[] _tests;
    private BlockCipher _engine;
    private KeyParameter _validKey;

    protected CipherTest(SimpleTest[] simpleTestArray, BlockCipher blockCipher, KeyParameter keyParameter) {
        this._tests = simpleTestArray;
        this._engine = blockCipher;
        this._validKey = keyParameter;
    }

    private void bufferSizeCheck(BlockCipher blockCipher) {
        byte[] byArray = new byte[blockCipher.getBlockSize()];
        byte[] byArray2 = new byte[byArray.length / 2];
        blockCipher.init(true, this._validKey);
        try {
            blockCipher.processBlock(byArray2, 0, byArray, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException dataLengthException) {}
        try {
            blockCipher.processBlock(byArray, 0, byArray2, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException dataLengthException) {}
        blockCipher.init(false, this._validKey);
        try {
            blockCipher.processBlock(byArray2, 0, byArray, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException dataLengthException) {}
        try {
            blockCipher.processBlock(byArray, 0, byArray2, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException dataLengthException) {}
    }

    static void checkCipher(int n, int n2, int n3, Instace instace) {
        AEADCipher aEADCipher = instace.CreateInstace();
        try {
            byte[] byArray = new byte[n3];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(byArray);
            byte[] byArray2 = new byte[n];
            secureRandom.nextBytes(byArray2);
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            KeyGenerationParameters keyGenerationParameters = new KeyGenerationParameters(secureRandom, 128);
            cipherKeyGenerator.init(keyGenerationParameters);
            byte[] byArray3 = cipherKeyGenerator.generateKey();
            KeyParameter keyParameter = new KeyParameter(byArray3);
            byte[] byArray4 = new byte[n2];
            secureRandom.nextBytes(byArray4);
            ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray4);
            aEADCipher.init(true, parametersWithIV);
            int n4 = aEADCipher.getOutputSize(n3);
            byte[] byArray5 = new byte[n4];
            aEADCipher.processAADBytes(byArray2, 0, n);
            int n5 = aEADCipher.processBytes(byArray, 0, n3, byArray5, 0);
            n5 += aEADCipher.doFinal(byArray5, n5);
            aEADCipher = instace.CreateInstace();
            aEADCipher.init(false, parametersWithIV);
            int n6 = aEADCipher.getOutputSize(n5);
            byte[] byArray6 = new byte[n6];
            aEADCipher.processAADBytes(byArray2, 0, n);
            int n7 = aEADCipher.processBytes(byArray5, 0, byArray5.length, byArray6, 0);
            n7 += aEADCipher.doFinal(byArray6, n7);
            byte[] byArray7 = Arrays.copyOf(byArray6, n3);
            if (!Arrays.areEqual(byArray, byArray7)) {
                System.out.println("Cipher " + aEADCipher.getAlgorithmName() + " failed");
            }
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new RuntimeException(invalidCipherTextException.toString());
        }
    }

    public abstract String getName();

    public void performTest() throws Exception {
        int n = 0;
        while (n != this._tests.length) {
            this._tests[n].performTest();
            ++n;
        }
        if (this._engine != null) {
            byte[] byArray = new byte[128];
            try {
                this._engine.processBlock(byArray, 0, byArray, 0);
                this.fail("failed initialisation check");
            }
            catch (IllegalStateException illegalStateException) {}
            this.bufferSizeCheck(this._engine);
        }
    }

    static interface Instace {
        public AEADCipher CreateInstace();
    }
}

