/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.macs.SipHash;
import org.bouncycastle.crypto.modes.ChaCha20Poly1305;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.AEADTestUtil;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.Times;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ChaCha20Poly1305Test
extends SimpleTest {
    private static final String[][] TEST_VECTORS = new String[][]{{"Test Case 1", "808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9f", "4c616469657320616e642047656e746c656d656e206f662074686520636c617373206f66202739393a204966204920636f756c64206f6666657220796f75206f6e6c79206f6e652074697020666f7220746865206675747572652c2073756e73637265656e20776f756c642062652069742e", "50515253c0c1c2c3c4c5c6c7", "070000004041424344454647", "d31a8d34648e60db7b86afbc53ef7ec2a4aded51296e08fea9e2b5a736ee62d63dbea45e8ca9671282fafb69da92728b1a71de0a9e060b2905d6a5b67ecd3b3692ddbd7f2d778b8c9803aee328091b58fab324e4fad675945585808b4831d7bc3ff4def08e4b7a9de576d26586cec64b6116", "1ae10b594f09e26a7e902ecbd0600691"}};

    private void checkTestCase(ChaCha20Poly1305 chaCha20Poly1305, ChaCha20Poly1305 chaCha20Poly13052, String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws InvalidCipherTextException {
        byte[] byArray5 = new byte[chaCha20Poly1305.getOutputSize(byArray2.length)];
        if (byArray != null) {
            chaCha20Poly1305.processAADBytes(byArray, 0, byArray.length);
        }
        int n = chaCha20Poly1305.processBytes(byArray2, 0, byArray2.length, byArray5, 0);
        if (byArray5.length != (n += chaCha20Poly1305.doFinal(byArray5, n))) {
            this.fail("encryption reported incorrect length: " + string);
        }
        byte[] byArray6 = chaCha20Poly1305.getMac();
        byte[] byArray7 = new byte[byArray2.length];
        System.arraycopy(byArray5, 0, byArray7, 0, byArray7.length);
        byte[] byArray8 = new byte[byArray5.length - byArray2.length];
        System.arraycopy(byArray5, byArray2.length, byArray8, 0, byArray8.length);
        if (!this.areEqual(byArray3, byArray7)) {
            this.fail("incorrect encrypt in: " + string);
        }
        if (!this.areEqual(byArray4, byArray6)) {
            this.fail("getMac() returned wrong mac in: " + string);
        }
        if (!this.areEqual(byArray4, byArray8)) {
            this.fail("stream contained wrong mac in: " + string);
        }
        byte[] byArray9 = new byte[chaCha20Poly13052.getOutputSize(byArray5.length)];
        if (byArray != null) {
            chaCha20Poly13052.processAADBytes(byArray, 0, byArray.length);
        }
        n = chaCha20Poly13052.processBytes(byArray5, 0, byArray5.length, byArray9, 0);
        n += chaCha20Poly13052.doFinal(byArray9, n);
        byArray6 = chaCha20Poly13052.getMac();
        byArray7 = new byte[byArray3.length];
        System.arraycopy(byArray9, 0, byArray7, 0, byArray7.length);
        if (!this.areEqual(byArray2, byArray7)) {
            this.fail("incorrect decrypt in: " + string);
        }
    }

    public String getName() {
        return "ChaCha20Poly1305";
    }

    private ChaCha20Poly1305 initCipher(boolean bl, AEADParameters aEADParameters) {
        ChaCha20Poly1305 chaCha20Poly1305 = new ChaCha20Poly1305();
        chaCha20Poly1305.init(bl, aEADParameters);
        return chaCha20Poly1305;
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new ChaCha20Poly1305Test());
    }

    private static int nextInt(SecureRandom secureRandom, int n) {
        int n2;
        int n3;
        if ((n & -n) == n) {
            return (int)((long)n * (long)(secureRandom.nextInt() >>> 1) >> 31);
        }
        while ((n3 = secureRandom.nextInt() >>> 1) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    private void outputSizeTests() {
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = null;
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(byArray), 128, byArray2, byArray3);
        ChaCha20Poly1305 chaCha20Poly1305 = this.initCipher(true, aEADParameters);
        if (chaCha20Poly1305.getUpdateOutputSize(0) != 0) {
            this.fail("incorrect getUpdateOutputSize for initial 0 bytes encryption");
        }
        if (chaCha20Poly1305.getOutputSize(0) != 16) {
            this.fail("incorrect getOutputSize for initial 0 bytes encryption");
        }
        chaCha20Poly1305.init(false, aEADParameters);
        if (chaCha20Poly1305.getUpdateOutputSize(0) != 0) {
            this.fail("incorrect getUpdateOutputSize for initial 0 bytes decryption");
        }
        if (chaCha20Poly1305.getOutputSize(0) != 0) {
            this.fail("fragile getOutputSize for initial 0 bytes decryption");
        }
        if (chaCha20Poly1305.getOutputSize(16) != 0) {
            this.fail("incorrect getOutputSize for initial MAC-size bytes decryption");
        }
    }

    public void performTest() throws Exception {
        int n = 0;
        while (n < TEST_VECTORS.length) {
            this.runTestCase(TEST_VECTORS[n]);
            ++n;
        }
        this.outputSizeTests();
        this.randomTests();
        this.testExceptions();
    }

    private void randomTest(SecureRandom secureRandom) throws InvalidCipherTextException {
        byte[] byArray;
        int n = 32;
        byte[] byArray2 = new byte[n];
        secureRandom.nextBytes(byArray2);
        int n2 = secureRandom.nextInt() >>> 24;
        int n3 = secureRandom.nextInt() >>> 16;
        int n4 = secureRandom.nextInt() >>> 24;
        byte[] byArray3 = new byte[n2 + n3 + n4];
        secureRandom.nextBytes(byArray3);
        int n5 = secureRandom.nextInt() >>> 24;
        byte[] byArray4 = new byte[n5];
        secureRandom.nextBytes(byArray4);
        int n6 = secureRandom.nextInt() >>> 24;
        byte[] byArray5 = new byte[n6];
        secureRandom.nextBytes(byArray5);
        int n7 = 12;
        byte[] byArray6 = new byte[n7];
        secureRandom.nextBytes(byArray6);
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(byArray2), 128, byArray6, byArray4);
        ChaCha20Poly1305 chaCha20Poly1305 = this.initCipher(true, aEADParameters);
        int n8 = chaCha20Poly1305.getOutputSize(n3);
        byte[] byArray7 = new byte[n6 + n8];
        System.arraycopy(byArray5, 0, byArray7, 0, n6);
        int n9 = ChaCha20Poly1305Test.nextInt(secureRandom, n6 + 1);
        chaCha20Poly1305.processAADBytes(byArray7, 0, n9);
        chaCha20Poly1305.processAADBytes(byArray7, n9, n6 - n9);
        int n10 = chaCha20Poly1305.getUpdateOutputSize(n3);
        int n11 = chaCha20Poly1305.processBytes(byArray3, n2, n3, byArray7, n6);
        if (n10 != n11) {
            this.fail("encryption reported incorrect update length in randomised test");
        }
        if (n8 != (n11 += chaCha20Poly1305.doFinal(byArray7, n6 + n11))) {
            this.fail("encryption reported incorrect length in randomised test");
        }
        byte[] byArray8 = chaCha20Poly1305.getMac();
        byte[] byArray9 = new byte[n8 - n3];
        System.arraycopy(byArray7, n6 + n3, byArray9, 0, byArray9.length);
        if (!this.areEqual(byArray8, byArray9)) {
            this.fail("stream contained wrong mac in randomised test");
        }
        chaCha20Poly1305.init(false, aEADParameters);
        int n12 = secureRandom.nextInt() >>> 24;
        int n13 = chaCha20Poly1305.getOutputSize(n8);
        int n14 = secureRandom.nextInt() >>> 24;
        byte[] byArray10 = new byte[n12 + n13 + n14];
        n9 = ChaCha20Poly1305Test.nextInt(secureRandom, n6 + 1);
        chaCha20Poly1305.processAADBytes(byArray7, 0, n9);
        chaCha20Poly1305.processAADBytes(byArray7, n9, n6 - n9);
        n10 = chaCha20Poly1305.getUpdateOutputSize(n8);
        n11 = chaCha20Poly1305.processBytes(byArray7, n6, n8, byArray10, n12);
        if (n10 != n11) {
            this.fail("decryption reported incorrect update length in randomised test");
        }
        n11 += chaCha20Poly1305.doFinal(byArray10, n12 + n11);
        if (!this.areEqual(byArray3, n2, n2 + n3, byArray10, n12, n12 + n13)) {
            this.fail("incorrect decrypt in randomised test");
        }
        if (!this.areEqual(byArray8, byArray = chaCha20Poly1305.getMac())) {
            this.fail("decryption produced different mac from encryption");
        }
        chaCha20Poly1305.init(false, AEADTestUtil.reuseKey(aEADParameters));
        n12 = secureRandom.nextInt() >>> 24;
        n13 = chaCha20Poly1305.getOutputSize(n8);
        n14 = secureRandom.nextInt() >>> 24;
        byArray10 = new byte[n12 + n13 + n14];
        n9 = ChaCha20Poly1305Test.nextInt(secureRandom, n6 + 1);
        chaCha20Poly1305.processAADBytes(byArray7, 0, n9);
        chaCha20Poly1305.processAADBytes(byArray7, n9, n6 - n9);
        n11 = chaCha20Poly1305.processBytes(byArray7, n6, n8, byArray10, n12);
        n11 += chaCha20Poly1305.doFinal(byArray10, n12 + n11);
        if (!this.areEqual(byArray3, n2, n2 + n3, byArray10, n12, n12 + n13)) {
            this.fail("incorrect decrypt in randomised test");
        }
        if (!this.areEqual(byArray8, byArray = chaCha20Poly1305.getMac())) {
            this.fail("decryption produced different mac from encryption");
        }
    }

    private void randomTests() throws InvalidCipherTextException {
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(Times.nanoTime());
        int n = 0;
        while (n < 100) {
            this.randomTest(secureRandom);
            ++n;
        }
    }

    private void runTestCase(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws InvalidCipherTextException {
        byte[] byArray7 = new byte[byArray3.length / 2];
        byte[] byArray8 = new byte[byArray3.length - byArray3.length / 2];
        System.arraycopy(byArray3, 0, byArray7, 0, byArray7.length);
        System.arraycopy(byArray3, byArray7.length, byArray8, 0, byArray8.length);
        this.runTestCase(String.valueOf(string) + " all initial associated data", byArray, byArray2, byArray3, null, byArray4, byArray5, byArray6);
        this.runTestCase(String.valueOf(string) + " all subsequent associated data", byArray, byArray2, null, byArray3, byArray4, byArray5, byArray6);
        this.runTestCase(String.valueOf(string) + " split associated data", byArray, byArray2, byArray7, byArray8, byArray4, byArray5, byArray6);
    }

    private void runTestCase(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7) throws InvalidCipherTextException {
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(byArray), byArray7.length * 8, byArray2, byArray3);
        ChaCha20Poly1305 chaCha20Poly1305 = this.initCipher(true, aEADParameters);
        ChaCha20Poly1305 chaCha20Poly13052 = this.initCipher(false, aEADParameters);
        this.checkTestCase(chaCha20Poly1305, chaCha20Poly13052, string, byArray4, byArray5, byArray6, byArray7);
        chaCha20Poly1305 = this.initCipher(true, aEADParameters);
        this.checkTestCase(chaCha20Poly1305, chaCha20Poly13052, String.valueOf(string) + " (reused)", byArray4, byArray5, byArray6, byArray7);
        AEADParameters aEADParameters2 = AEADTestUtil.reuseKey(aEADParameters);
        try {
            chaCha20Poly1305.init(true, aEADParameters2);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("wrong message", "cannot reuse nonce for ChaCha20Poly1305 encryption".equals(illegalArgumentException.getMessage()));
        }
    }

    private void runTestCase(String[] stringArray) throws InvalidCipherTextException {
        int n = 0;
        String string = stringArray[n++];
        byte[] byArray = Hex.decode(stringArray[n++]);
        byte[] byArray2 = Hex.decode(stringArray[n++]);
        byte[] byArray3 = Hex.decode(stringArray[n++]);
        byte[] byArray4 = Hex.decode(stringArray[n++]);
        byte[] byArray5 = Hex.decode(stringArray[n++]);
        byte[] byArray6 = Hex.decode(stringArray[n++]);
        this.runTestCase(string, byArray, byArray4, byArray3, byArray2, byArray5, byArray6);
    }

    private void testExceptions() throws InvalidCipherTextException {
        ChaCha20Poly1305 chaCha20Poly1305 = new ChaCha20Poly1305();
        try {
            chaCha20Poly1305 = new ChaCha20Poly1305(new SipHash());
            this.fail("incorrect mac size not picked up");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            chaCha20Poly1305.init(false, new KeyParameter(new byte[32]));
            this.fail("illegal argument not picked up");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        AEADTestUtil.testTampering(this, chaCha20Poly1305, new AEADParameters(new KeyParameter(new byte[32]), 128, new byte[12]));
        byte[] byArray = Strings.toByteArray("Hello world!");
        byte[] byArray2 = new byte[100];
        chaCha20Poly1305 = new ChaCha20Poly1305();
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(new byte[32]), 128, new byte[12]);
        chaCha20Poly1305.init(true, aEADParameters);
        chaCha20Poly1305.processBytes(byArray, 0, byArray.length, byArray2, 0);
        chaCha20Poly1305.doFinal(byArray2, 0);
        try {
            chaCha20Poly1305.doFinal(byArray2, 0);
            this.fail("no exception on reuse");
        }
        catch (IllegalStateException illegalStateException) {
            this.isTrue("wrong message", illegalStateException.getMessage().equals("ChaCha20Poly1305 cannot be reused for encryption"));
        }
        try {
            chaCha20Poly1305.init(true, aEADParameters);
            this.fail("no exception on reuse");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("wrong message", illegalArgumentException.getMessage().equals("cannot reuse nonce for ChaCha20Poly1305 encryption"));
        }
    }
}

