/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.CSHAKEDigest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class CSHAKETest
extends SimpleTest {
    private void checkSHAKE(int n, CSHAKEDigest cSHAKEDigest, byte[] byArray) {
        SHAKEDigest sHAKEDigest = new SHAKEDigest(n);
        sHAKEDigest.update(byArray, 0, byArray.length);
        cSHAKEDigest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        sHAKEDigest.doFinal(byArray2, 0, byArray2.length);
        cSHAKEDigest.doFinal(byArray3, 0, byArray3.length);
        this.isTrue(Arrays.areEqual(byArray2, byArray3));
    }

    private void checkZeroPadZ() {
        byte[] byArray = new byte[20];
        CSHAKEDigest cSHAKEDigest = new CSHAKEDigest(256, new byte[0], new byte[265]);
        cSHAKEDigest.doOutput(byArray, 0, byArray.length);
        this.isTrue(this.areEqual(Hex.decode("6e393540387004f087c4180db008acf6825190cf"), byArray));
        CSHAKEDigest cSHAKEDigest2 = new CSHAKEDigest(128, new byte[0], new byte[329]);
        cSHAKEDigest2.doOutput(byArray, 0, byArray.length);
        this.isTrue(this.areEqual(Hex.decode("309bd7c285fcf8b839c9686b2cc00bd578947bee"), byArray));
        cSHAKEDigest2 = new CSHAKEDigest(128, new byte[29], new byte[300]);
        cSHAKEDigest2.doOutput(byArray, 0, byArray.length);
        this.isTrue(this.areEqual(Hex.decode("ff6aafd83b8d22fc3e2e9b9948b581967ed9c5e7"), byArray));
    }

    private void doFinalTest() {
        CSHAKEDigest cSHAKEDigest = new CSHAKEDigest(128, new byte[0], Strings.toByteArray("Email Signature"));
        cSHAKEDigest.update(Hex.decode("00010203"), 0, 4);
        byte[] byArray = new byte[32];
        cSHAKEDigest.doOutput(byArray, 0, byArray.length);
        this.isTrue(Arrays.areEqual(Hex.decode("c1c36925b6409a04f1b504fcbca9d82b4017277cb5ed2b2065fc1d3814d5aaf5"), byArray));
        cSHAKEDigest.doOutput(byArray, 0, byArray.length);
        this.isTrue(Arrays.areEqual(Hex.decode("c1c36925b6409a04f1b504fcbca9d82b4017277cb5ed2b2065fc1d3814d5aaf5"), byArray) ^ true);
        cSHAKEDigest.doFinal(byArray, 0, byArray.length);
        cSHAKEDigest.update(Hex.decode("00010203"), 0, 4);
        cSHAKEDigest.doFinal(byArray, 0, byArray.length);
        this.isTrue(Arrays.areEqual(Hex.decode("c1c36925b6409a04f1b504fcbca9d82b4017277cb5ed2b2065fc1d3814d5aaf5"), byArray));
        cSHAKEDigest.update(Hex.decode("00010203"), 0, 4);
        cSHAKEDigest.doOutput(byArray, 0, byArray.length);
        this.isTrue(Arrays.areEqual(Hex.decode("c1c36925b6409a04f1b504fcbca9d82b4017277cb5ed2b2065fc1d3814d5aaf5"), byArray));
        cSHAKEDigest.doFinal(byArray, 0, byArray.length);
        this.isTrue(Arrays.areEqual(Hex.decode("9cbce830079c452abdeb875366a49ebfe75b89ef17396e34898e904830b0e136"), byArray));
    }

    public String getName() {
        return "CSHAKE";
    }

    private void longBlockTest() {
        CSHAKEDigest cSHAKEDigest;
        byte[] byArray = new byte[16000];
        byte[] byArray2 = new byte[32];
        int n = 0;
        while (n != byArray.length) {
            byArray[n] = (byte)n;
            ++n;
        }
        byte[] byArray3 = Hex.decodeStrict("00010203");
        int n2 = 10000;
        while (n2 != byArray.length) {
            cSHAKEDigest = new CSHAKEDigest(128, new byte[0], Arrays.copyOfRange(byArray, 0, n2));
            cSHAKEDigest.update(byArray3, 0, 4);
            cSHAKEDigest.doFinal(byArray2, 0, 16);
            ++n2;
        }
        cSHAKEDigest = new CSHAKEDigest(256, new byte[0], new byte[200]);
        cSHAKEDigest.update(byArray, 0, 200);
        cSHAKEDigest.doFinal(byArray2, 0, 32);
        this.isTrue(Arrays.areEqual(Hex.decode("4a899b5be460d85a9789215bc17f88b8f8ac049bd3b519f561e7b5d3870dafa3"), byArray2));
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new CSHAKETest());
    }

    public void performTest() throws Exception {
        CSHAKEDigest cSHAKEDigest = new CSHAKEDigest(128, new byte[0], Strings.toByteArray("Email Signature"));
        cSHAKEDigest.update(Hex.decode("00010203"), 0, 4);
        byte[] byArray = new byte[32];
        cSHAKEDigest.doOutput(byArray, 0, byArray.length);
        this.isTrue("oops!", Arrays.areEqual(Hex.decode("c1c36925b6409a04f1b504fcbca9d82b4017277cb5ed2b2065fc1d3814d5aaf5"), byArray));
        cSHAKEDigest = new CSHAKEDigest(128, new byte[0], Strings.toByteArray("Email Signature"));
        cSHAKEDigest.update(Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7"), 0, 200);
        byArray = new byte[32];
        cSHAKEDigest.doOutput(byArray, 0, byArray.length);
        this.isTrue(Arrays.areEqual(Hex.decode("C5221D50E4F822D96A2E8881A961420F294B7B24FE3D2094BAED2C6524CC166B "), byArray));
        cSHAKEDigest = new CSHAKEDigest(256, new byte[0], Strings.toByteArray("Email Signature"));
        cSHAKEDigest.update(Hex.decode("00010203"), 0, 4);
        byArray = new byte[64];
        cSHAKEDigest.doOutput(byArray, 0, byArray.length);
        this.isTrue(Arrays.areEqual(Hex.decode("D008828E2B80AC9D2218FFEE1D070C48B8E4C87BFF32C9699D5B6896EEE0EDD164020E2BE0560858D9C00C037E34A96937C561A74C412BB4C746469527281C8C"), byArray));
        cSHAKEDigest = new CSHAKEDigest(256, new byte[0], Strings.toByteArray("Email Signature"));
        cSHAKEDigest.update(Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7"), 0, 200);
        byArray = new byte[64];
        cSHAKEDigest.doOutput(byArray, 0, byArray.length);
        this.isTrue(Arrays.areEqual(Hex.decode("07DC27B11E51FBAC75BC7B3C1D983E8B4B85FB1DEFAF218912AC86430273091727F42B17ED1DF63E8EC118F04B23633C1DFB1574C8FB55CB45DA8E25AFB092BB"), byArray));
        this.doFinalTest();
        this.longBlockTest();
        this.checkZeroPadZ();
        this.checkSHAKE(128, new CSHAKEDigest(128, new byte[0], new byte[0]), Hex.decode("eeaabeef"));
        this.checkSHAKE(256, new CSHAKEDigest(256, new byte[0], null), Hex.decode("eeaabeef"));
        this.checkSHAKE(128, new CSHAKEDigest(128, null, new byte[0]), Hex.decode("eeaabeef"));
        this.checkSHAKE(128, new CSHAKEDigest(128, null, null), Hex.decode("eeaabeef"));
        this.checkSHAKE(256, new CSHAKEDigest(256, null, null), Hex.decode("eeaabeef"));
    }
}

