/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.AESLightEngine;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.engines.CAST5Engine;
import org.bouncycastle.crypto.engines.CAST6Engine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.NoekeonEngine;
import org.bouncycastle.crypto.engines.RC6Engine;
import org.bouncycastle.crypto.engines.SEEDEngine;
import org.bouncycastle.crypto.engines.SerpentEngine;
import org.bouncycastle.crypto.engines.TEAEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.engines.XTEAEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.GOFBBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import org.bouncycastle.crypto.modes.PGPCFBBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class BlockCipherResetTest
extends SimpleTest {
    private void checkReset(String string, boolean bl, BlockCipher blockCipher, CipherParameters cipherParameters, boolean bl2, byte[] byArray, byte[] byArray2) throws InvalidCipherTextException {
        byte[] byArray3 = new byte[byArray2.length];
        BlockCipherResetTest.crypt(blockCipher, bl2, byArray, byArray3);
        if (bl) {
            BlockCipherResetTest.crypt(blockCipher, bl2, byArray, byArray3);
            if (!Arrays.areEqual(byArray3, byArray2)) {
                this.fail(String.valueOf(string) + (bl2 ? " encrypt" : " decrypt") + " did not reset cipher.");
            }
        }
        blockCipher.processBlock(byArray, 0, byArray3, 0);
        blockCipher.init(bl2, cipherParameters);
        try {
            BlockCipherResetTest.crypt(blockCipher, bl2, byArray, byArray3);
        }
        catch (DataLengthException dataLengthException) {
            this.fail(String.valueOf(string) + " init did not reset data.");
        }
        if (!Arrays.areEqual(byArray3, byArray2)) {
            this.fail(String.valueOf(string) + " init did not reset data.", new String(Hex.encode(byArray2)), new String(Hex.encode(byArray3)));
        }
        blockCipher.processBlock(byArray, 0, byArray3, 0);
        blockCipher.reset();
        try {
            BlockCipherResetTest.crypt(blockCipher, bl2, byArray, byArray3);
        }
        catch (DataLengthException dataLengthException) {
            this.fail(String.valueOf(string) + " reset did not reset data.");
        }
        if (!Arrays.areEqual(byArray3, byArray2)) {
            this.fail(String.valueOf(string) + " reset did not reset data.");
        }
    }

    private static void crypt(BlockCipher blockCipher, boolean bl, byte[] byArray, byte[] byArray2) throws InvalidCipherTextException {
        blockCipher.processBlock(byArray, 0, byArray2, 0);
        if (blockCipher.getAlgorithmName().indexOf("PGPCFBwithIV") > -1 && !bl) {
            blockCipher.processBlock(byArray, blockCipher.getBlockSize(), byArray2, 0);
        }
    }

    public String getName() {
        return "Block Cipher Reset";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new BlockCipherResetTest());
    }

    public void performTest() throws Exception {
        this.testReset("AESFastEngine", new AESFastEngine(), new AESFastEngine(), new KeyParameter(new byte[16]));
        this.testReset("AESEngine", new AESEngine(), new AESEngine(), new KeyParameter(new byte[16]));
        this.testReset("AESLightEngine", new AESLightEngine(), new AESLightEngine(), new KeyParameter(new byte[16]));
        this.testReset("Twofish", new TwofishEngine(), new TwofishEngine(), new KeyParameter(new byte[16]));
        this.testReset("NoekeonEngine", new NoekeonEngine(), new NoekeonEngine(), new KeyParameter(new byte[16]));
        this.testReset("SerpentEngine", new SerpentEngine(), new SerpentEngine(), new KeyParameter(new byte[16]));
        this.testReset("SEEDEngine", new SEEDEngine(), new SEEDEngine(), new KeyParameter(new byte[16]));
        this.testReset("CAST6Engine", new CAST6Engine(), new CAST6Engine(), new KeyParameter(new byte[16]));
        this.testReset("RC6Engine", new RC6Engine(), new RC6Engine(), new KeyParameter(new byte[16]));
        this.testReset("DESEngine", new DESEngine(), new DESEngine(), new KeyParameter(new byte[8]));
        this.testReset("BlowfishEngine", new BlowfishEngine(), new BlowfishEngine(), new KeyParameter(new byte[8]));
        this.testReset("CAST5Engine", new CAST5Engine(), new CAST5Engine(), new KeyParameter(new byte[8]));
        this.testReset("DESedeEngine", new DESedeEngine(), new DESedeEngine(), new KeyParameter(new byte[24]));
        this.testReset("TEAEngine", new TEAEngine(), new TEAEngine(), new KeyParameter(new byte[16]));
        this.testReset("XTEAEngine", new XTEAEngine(), new XTEAEngine(), new KeyParameter(new byte[16]));
        this.testModeReset("AES/CBC", CBCBlockCipher.newInstance(AESEngine.newInstance()), CBCBlockCipher.newInstance(AESEngine.newInstance()), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        this.testModeReset("AES/SIC", SICBlockCipher.newInstance(AESEngine.newInstance()), SICBlockCipher.newInstance(AESEngine.newInstance()), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        this.testModeReset("AES/CFB", CFBBlockCipher.newInstance(AESEngine.newInstance(), 128), CFBBlockCipher.newInstance(AESEngine.newInstance(), 128), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        this.testModeReset("AES/OFB", new OFBBlockCipher(AESEngine.newInstance(), 128), new OFBBlockCipher(AESEngine.newInstance(), 128), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        this.testModeReset("AES/GCTR", new GOFBBlockCipher(new DESEngine()), new GOFBBlockCipher(new DESEngine()), new ParametersWithIV(new KeyParameter(new byte[8]), new byte[8]));
        this.testModeReset("AES/OpenPGPCFB", new OpenPGPCFBBlockCipher(AESEngine.newInstance()), new OpenPGPCFBBlockCipher(AESEngine.newInstance()), new KeyParameter(new byte[16]));
        this.testModeReset("AES/PGPCFB", new PGPCFBBlockCipher(new AESEngine(), false), new PGPCFBBlockCipher(new AESEngine(), false), new KeyParameter(new byte[16]));
    }

    private void testModeReset(String string, BlockCipher blockCipher, BlockCipher blockCipher2, CipherParameters cipherParameters) throws InvalidCipherTextException {
        this.testReset(string, false, blockCipher, blockCipher2, cipherParameters);
    }

    private void testReset(String string, BlockCipher blockCipher, BlockCipher blockCipher2, CipherParameters cipherParameters) throws InvalidCipherTextException {
        this.testReset(string, true, blockCipher, blockCipher2, cipherParameters);
    }

    private void testReset(String string, boolean bl, BlockCipher blockCipher, BlockCipher blockCipher2, CipherParameters cipherParameters) throws InvalidCipherTextException {
        blockCipher.init(true, cipherParameters);
        byte[] byArray = new byte[blockCipher.getBlockSize()];
        byte[] byArray2 = new byte[blockCipher.getAlgorithmName().indexOf("PGPCFBwithIV") > -1 ? 2 * blockCipher.getBlockSize() + 2 : blockCipher.getBlockSize()];
        BlockCipherResetTest.crypt(blockCipher, true, byArray, byArray2);
        this.checkReset(string, bl, blockCipher, cipherParameters, true, byArray, byArray2);
        blockCipher2.init(false, cipherParameters);
        this.checkReset(string, bl, blockCipher2, cipherParameters, false, byArray2, byArray);
    }
}

