/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class BlockCipherMonteCarloTest
extends SimpleTest {
    int id;
    int iterations;
    BlockCipher engine;
    CipherParameters param;
    byte[] input;
    byte[] output;

    public BlockCipherMonteCarloTest(int n, int n2, BlockCipher blockCipher, CipherParameters cipherParameters, String string, String string2) {
        this.id = n;
        this.iterations = n2;
        this.engine = blockCipher;
        this.param = cipherParameters;
        this.input = Hex.decode(string);
        this.output = Hex.decode(string2);
    }

    public String getName() {
        return String.valueOf(this.engine.getAlgorithmName()) + " Monte Carlo Test " + this.id;
    }

    public void performTest() throws Exception {
        int n;
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher(this.engine);
        bufferedBlockCipher.init(true, this.param);
        byte[] byArray = new byte[this.input.length];
        System.arraycopy(this.input, 0, byArray, 0, byArray.length);
        int n2 = 0;
        while (n2 != this.iterations) {
            n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray, 0);
            bufferedBlockCipher.doFinal(byArray, n);
            ++n2;
        }
        if (!this.areEqual(byArray, this.output)) {
            this.fail("failed - expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(byArray)));
        }
        bufferedBlockCipher.init(false, this.param);
        n = 0;
        while (n != this.iterations) {
            int n3 = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray, 0);
            bufferedBlockCipher.doFinal(byArray, n3);
            ++n;
        }
        if (!this.areEqual(this.input, byArray)) {
            this.fail("failed reversal");
        }
    }
}

