/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.util.Random;
import org.bouncycastle.crypto.digests.Blake2sDigest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class Blake2sDigestTest
extends SimpleTest {
    private static final String[][] keyedTestVectors = new String[][]{{"", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "48a8997da407876b3d79c0d92325ad3b89cbb754d86ab71aee047ad345fd2c49"}, {"00", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "40d15fee7c328830166ac3f918650f807e7e01e177258cdc0a39b11f598066f1"}, {"0001", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "6bb71300644cd3991b26ccd4d274acd1adeab8b1d7914546c1198bbe9fc9d803"}, {"000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "172ffc67153d12e0ca76a8b6cd5d4731885b39ce0cac93a8972a18006c8b8baf"}, {"000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f505152535455565758595a5b5c5d5e5f606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "4f8ce1e51d2fe7f24043a904d898ebfc91975418753413aa099b795ecb35cedb"}, {"000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f505152535455565758595a5b5c5d5e5f606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeafb0b1b2b3b4b5b6b7b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfe", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "3fb735061abc519dfe979e54c1ee5bfad0a9d858b3315bad34bde999efd724dd"}};
    private static final String SELF_TEST_RESULT = "6A411F08CE25ADCDFB02ABA641451CEC53C598B24F4FC787FBDC88797F4C1DFE";
    private static final int[] SELF_TEST_DIGEST_LEN = new int[]{16, 20, 28, 32};
    private static final int[] SELF_TEST_INPUT_LEN;

    static {
        int[] nArray = new int[6];
        nArray[1] = 3;
        nArray[2] = 64;
        nArray[3] = 65;
        nArray[4] = 255;
        nArray[5] = 1024;
        SELF_TEST_INPUT_LEN = nArray;
    }

    public String getName() {
        return "BLAKE2s";
    }

    public static void main(String[] stringArray) throws Exception {
        SimpleTest.runTest(new Blake2sDigestTest());
    }

    public void performTest() throws Exception {
        this.testDigestWithKeyedTestVectors();
        this.testDigestWithKeyedTestVectorsAndRandomUpdate();
        this.testReset();
        this.runSelfTest();
        this.testNullKeyVsUnkeyed();
        this.testLengthConstruction();
    }

    public void runSelfTest() {
        Blake2sDigest blake2sDigest = new Blake2sDigest();
        byte[] byArray = new byte[32];
        int n = 0;
        while (n < 4) {
            int n2 = SELF_TEST_DIGEST_LEN[n];
            int n3 = 0;
            while (n3 < 6) {
                int n4 = SELF_TEST_INPUT_LEN[n3];
                byte[] byArray2 = Blake2sDigestTest.selfTestSequence(n4, n4);
                Blake2sDigest blake2sDigest2 = new Blake2sDigest(n2 * 8);
                blake2sDigest2.update(byArray2, 0, n4);
                blake2sDigest2.doFinal(byArray, 0);
                blake2sDigest.update(byArray, 0, n2);
                byte[] byArray3 = Blake2sDigestTest.selfTestSequence(n2, n2);
                Blake2sDigest blake2sDigest3 = new Blake2sDigest(byArray3, n2, null, null);
                blake2sDigest3.update(byArray2, 0, n4);
                blake2sDigest3.doFinal(byArray, 0);
                blake2sDigest.update(byArray, 0, n2);
                ++n3;
            }
            ++n;
        }
        byte[] byArray4 = new byte[32];
        blake2sDigest.doFinal(byArray4, 0);
        if (!this.areEqual(Hex.decode(SELF_TEST_RESULT), byArray4)) {
            this.fail("BLAKE2s mismatch on test vector ", SELF_TEST_RESULT, new String(Hex.encode(byArray4)));
        }
    }

    private static byte[] selfTestSequence(int n, int n2) {
        int n3 = -559068243 * n2;
        int n4 = 1;
        byte[] byArray = new byte[n];
        int n5 = 0;
        while (n5 < n) {
            int n6 = n3 + n4;
            n3 = n4;
            n4 = n6;
            byArray[n5] = (byte)(n6 >> 24 & 0xFF);
            ++n5;
        }
        return byArray;
    }

    public void testDigestWithKeyedTestVectors() {
        Blake2sDigest blake2sDigest = new Blake2sDigest(Hex.decode(keyedTestVectors[0][1]));
        int n = 0;
        while (n != keyedTestVectors.length) {
            String[] stringArray = keyedTestVectors[n];
            byte[] byArray = Hex.decode(stringArray[0]);
            blake2sDigest.reset();
            blake2sDigest.update(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[32];
            blake2sDigest.doFinal(byArray2, 0);
            if (!this.areEqual(Hex.decode(stringArray[2]), byArray2)) {
                this.fail("BLAKE2s mismatch on test vector ", stringArray[2], new String(Hex.encode(byArray2)));
            }
            ++n;
        }
    }

    public void testDigestWithKeyedTestVectorsAndRandomUpdate() {
        Blake2sDigest blake2sDigest = new Blake2sDigest(Hex.decode(keyedTestVectors[0][1]));
        Random random = new Random();
        int n = 0;
        while (n < 100) {
            int n2 = 0;
            while (n2 != keyedTestVectors.length) {
                String[] stringArray = keyedTestVectors[n2];
                byte[] byArray = Hex.decode(stringArray[0]);
                if (byArray.length >= 3) {
                    blake2sDigest.reset();
                    int n3 = (random.nextInt() & 0xFFFF) % byArray.length;
                    if (n3 > 0) {
                        blake2sDigest.update(byArray, 0, n3);
                    }
                    blake2sDigest.update(byArray[n3]);
                    if (n3 < byArray.length - 1) {
                        blake2sDigest.update(byArray, n3 + 1, byArray.length - (n3 + 1));
                    }
                    byte[] byArray2 = new byte[32];
                    blake2sDigest.doFinal(byArray2, 0);
                    if (!this.areEqual(Hex.decode(stringArray[2]), byArray2)) {
                        this.fail("BLAKE2s mismatch on test vector ", stringArray[2], new String(Hex.encode(byArray2)));
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private void testLengthConstruction() {
        try {
            new Blake2sDigest(-1);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("BLAKE2s digest bit length must be a multiple of 8 and not greater than 256", illegalArgumentException.getMessage());
        }
        try {
            new Blake2sDigest(9);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("BLAKE2s digest bit length must be a multiple of 8 and not greater than 256", illegalArgumentException.getMessage());
        }
        try {
            new Blake2sDigest(512);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("BLAKE2s digest bit length must be a multiple of 8 and not greater than 256", illegalArgumentException.getMessage());
        }
        try {
            new Blake2sDigest(null, -1, null, null);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("Invalid digest length (required: 1 - 32)", illegalArgumentException.getMessage());
        }
        try {
            new Blake2sDigest(null, 33, null, null);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("Invalid digest length (required: 1 - 32)", illegalArgumentException.getMessage());
        }
    }

    private void testNullKeyVsUnkeyed() {
        byte[] byArray = Strings.toByteArray("abc");
        int n = 1;
        while (n != 32) {
            Blake2sDigest blake2sDigest = new Blake2sDigest(n * 8);
            Blake2sDigest blake2sDigest2 = new Blake2sDigest(null, n, null, null);
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            blake2sDigest.update(byArray, 0, byArray.length);
            blake2sDigest2.update(byArray, 0, byArray.length);
            blake2sDigest.doFinal(byArray2, 0);
            blake2sDigest2.doFinal(byArray3, 0);
            this.isTrue(Arrays.areEqual(byArray2, byArray3));
            ++n;
        }
    }

    public void testReset() {
        byte[] byArray = new byte[32];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = n;
            n = (byte)(n + 1);
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        int n2 = 0;
        while (n2 < byArray2.length) {
            byArray2[n2] = n2;
            n2 = (byte)(n2 + 1);
        }
        Blake2sDigest blake2sDigest = new Blake2sDigest(byArray);
        blake2sDigest.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[blake2sDigest.getDigestSize()];
        blake2sDigest.doFinal(byArray3, 0);
        Blake2sDigest blake2sDigest2 = new Blake2sDigest(byArray);
        blake2sDigest2.update(byArray2, 0, byArray2.length);
        blake2sDigest2.reset();
        blake2sDigest2.update(byArray2, 0, byArray2.length);
        byte[] byArray4 = new byte[blake2sDigest.getDigestSize()];
        blake2sDigest2.doFinal(byArray4, 0);
        if (!this.areEqual(byArray3, byArray4)) {
            this.fail("BLAKE2s mismatch on test vector ", new String(Hex.encode(byArray3)), new String(Hex.encode(byArray4)));
        }
    }
}

