/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServiceConstraintsException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.RawAgreement;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.agreement.DHAgreement;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.agreement.DHStandardGroups;
import org.bouncycastle.crypto.agreement.DHUnifiedAgreement;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHCStagedAgreement;
import org.bouncycastle.crypto.agreement.ECDHCUnifiedAgreement;
import org.bouncycastle.crypto.agreement.ECMQVBasicAgreement;
import org.bouncycastle.crypto.agreement.ECVKOAgreement;
import org.bouncycastle.crypto.agreement.MQVBasicAgreement;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.agreement.X448Agreement;
import org.bouncycastle.crypto.agreement.XDHBasicAgreement;
import org.bouncycastle.crypto.agreement.XDHUnifiedAgreement;
import org.bouncycastle.crypto.constraints.BitsOfSecurityConstraint;
import org.bouncycastle.crypto.constraints.LegacyBitsOfSecurityConstraint;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.CramerShoupCoreEngine;
import org.bouncycastle.crypto.engines.ElGamalEngine;
import org.bouncycastle.crypto.engines.NaccacheSternEngine;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.CramerShoupKeyPairGenerator;
import org.bouncycastle.crypto.generators.CramerShoupParametersGenerator;
import org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.bouncycastle.crypto.generators.DHKeyPairGenerator;
import org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.generators.Ed448KeyPairGenerator;
import org.bouncycastle.crypto.generators.ElGamalKeyPairGenerator;
import org.bouncycastle.crypto.generators.GOST3410KeyPairGenerator;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.generators.NaccacheSternKeyPairGenerator;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import org.bouncycastle.crypto.kems.RSAKEMExtractor;
import org.bouncycastle.crypto.kems.RSAKEMGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.CramerShoupKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHMQVPrivateParameters;
import org.bouncycastle.crypto.params.DHMQVPublicParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.DHUPrivateParameters;
import org.bouncycastle.crypto.params.DHUPublicParameters;
import org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECDHUPrivateParameters;
import org.bouncycastle.crypto.params.ECDHUPublicParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.Ed448KeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.bouncycastle.crypto.params.GOST3410KeyGenerationParameters;
import org.bouncycastle.crypto.params.GOST3410Parameters;
import org.bouncycastle.crypto.params.MQVPrivateParameters;
import org.bouncycastle.crypto.params.MQVPublicParameters;
import org.bouncycastle.crypto.params.NaccacheSternKeyGenerationParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.ParametersWithUKM;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.X448KeyGenerationParameters;
import org.bouncycastle.crypto.params.XDHUPrivateParameters;
import org.bouncycastle.crypto.params.XDHUPublicParameters;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.DSTU4145Signer;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.ECGOST3410Signer;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed25519ctxSigner;
import org.bouncycastle.crypto.signers.Ed25519phSigner;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.crypto.signers.Ed448phSigner;
import org.bouncycastle.crypto.signers.GOST3410Signer;
import org.bouncycastle.crypto.signers.GenericSigner;
import org.bouncycastle.crypto.signers.ISO9796d2PSSSigner;
import org.bouncycastle.crypto.signers.ISO9796d2Signer;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.signers.X931Signer;
import org.bouncycastle.util.test.SimpleTest;

public class AsymmetricConstraintsTest
extends SimpleTest {
    private void dhTest(CipherParameters cipherParameters, CipherParameters cipherParameters2, DHUnifiedAgreement dHUnifiedAgreement) {
        try {
            dHUnifiedAgreement.init(cipherParameters2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
    }

    private void dhTest(CipherParameters cipherParameters, CipherParameters cipherParameters2, MQVBasicAgreement mQVBasicAgreement) {
        try {
            mQVBasicAgreement.init(cipherParameters2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
    }

    private void dhTest(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2, BasicAgreement basicAgreement) {
        try {
            basicAgreement.init(asymmetricKeyParameter2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
    }

    private void dhTest(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2, DHAgreement dHAgreement) {
        try {
            dHAgreement.init(asymmetricKeyParameter2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
    }

    private void dsaSignerTest(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2, DSA dSA) {
        dSA.init(false, asymmetricKeyParameter);
        try {
            dSA.init(true, asymmetricKeyParameter2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 112", cryptoServiceConstraintsException.getMessage());
        }
    }

    private void ecAgreementTest(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2, BasicAgreement basicAgreement) {
        try {
            basicAgreement.init(asymmetricKeyParameter2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 96", cryptoServiceConstraintsException.getMessage());
        }
    }

    private void ecAgreementTest(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2, ECVKOAgreement eCVKOAgreement) {
        try {
            eCVKOAgreement.init(new ParametersWithUKM(asymmetricKeyParameter2, new byte[32]));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 96", cryptoServiceConstraintsException.getMessage());
        }
    }

    private void ecAgreementTest(ECDHUPublicParameters eCDHUPublicParameters, ECDHUPrivateParameters eCDHUPrivateParameters, ECDHCUnifiedAgreement eCDHCUnifiedAgreement) {
        try {
            eCDHCUnifiedAgreement.init(eCDHUPrivateParameters);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 96", cryptoServiceConstraintsException.getMessage());
        }
    }

    private void ecAgreementTest(MQVPublicParameters mQVPublicParameters, MQVPrivateParameters mQVPrivateParameters, ECMQVBasicAgreement eCMQVBasicAgreement) {
        try {
            eCMQVBasicAgreement.init(mQVPrivateParameters);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 96", cryptoServiceConstraintsException.getMessage());
        }
    }

    private void ecSignerTest(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2, DSA dSA) {
        dSA.init(false, asymmetricKeyParameter);
        try {
            dSA.init(true, asymmetricKeyParameter2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 96", cryptoServiceConstraintsException.getMessage());
        }
    }

    private void ecSignerTest(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2, Signer signer) {
        signer.init(false, asymmetricKeyParameter);
        try {
            signer.init(true, asymmetricKeyParameter2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 96", cryptoServiceConstraintsException.getMessage());
        }
    }

    private void edwardsAgreementTest(CipherParameters cipherParameters, CipherParameters cipherParameters2, RawAgreement rawAgreement, String string) {
        try {
            rawAgreement.init(cipherParameters2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only " + string, cryptoServiceConstraintsException.getMessage());
        }
    }

    private void edwardsAgreementTest(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2, XDHBasicAgreement xDHBasicAgreement, String string) {
        try {
            xDHBasicAgreement.init(asymmetricKeyParameter2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only " + string, cryptoServiceConstraintsException.getMessage());
        }
    }

    private void edwardsSignerTest(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2, Signer signer, String string) {
        signer.init(false, asymmetricKeyParameter);
        try {
            signer.init(true, asymmetricKeyParameter2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only " + string, cryptoServiceConstraintsException.getMessage());
        }
    }

    public String getName() {
        return "AsymmetricConstraintsTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new AsymmetricConstraintsTest());
    }

    public void performTest() throws Exception {
        this.test1024bitDSA();
        this.test1024bitRSA();
        this.testEdwards();
        this.testEC();
        this.testDSA();
        this.testDH();
        this.testElgamal();
        this.testGost3410();
        this.testRSA();
        this.testRsaKEM();
        this.testECIESKEM();
        this.testSM2Cipher();
        this.testCramerShoup();
        this.testNaccacheStern();
    }

    private void signer1024Test(RSAKeyParameters rSAKeyParameters, RSAKeyParameters rSAKeyParameters2, Signer signer) {
        signer.init(false, rSAKeyParameters);
        try {
            signer.init(true, rSAKeyParameters2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 112 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
    }

    private void test1024bitDSA() {
        BigInteger bigInteger = new BigInteger("178011905478542266528237562450159990145232156369120674273274450314442865788737020770612695252123463079567156784778466449970650770920727857050009668388144034129745221171818506047231150039301079959358067395348717066319802262019714966524135060945913707594956514672855690606794135837542707371727429551343320695239");
        BigInteger bigInteger2 = new BigInteger("864205495604807476120572616017955259175325408501");
        BigInteger bigInteger3 = new BigInteger("174068207532402095185811980123523436538604490794561350978495831040599953488455823147851597408940950725307797094915759492368300574252438761037084473467180148876118103083043754985190983472601550494691329488083395492313850000361646482644608492304078721818959999056496097769368017749273708962006689187956744210730");
        BigInteger bigInteger4 = new BigInteger("774290984479563168206130828532207106685994961942");
        BigInteger bigInteger5 = new BigInteger("114139536920622570869938062331723306749387755293373930319777713731297469469109142401130232217217777321368184441397443931576984650449330134427587575682738623671153548160095548080912063040969633652666498299669170854742832973750730854597032012872351800053401243970059348061331526243448471205166130497310892424132");
        DSAPublicKeyParameters dSAPublicKeyParameters = new DSAPublicKeyParameters(bigInteger5, new DSAParameters(bigInteger, bigInteger2, bigInteger3));
        DSAPrivateKeyParameters dSAPrivateKeyParameters = new DSAPrivateKeyParameters(bigInteger4, new DSAParameters(bigInteger, bigInteger2, bigInteger3));
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128));
        DSASigner dSASigner = new DSASigner();
        try {
            dSASigner.init(true, dSAPrivateKeyParameters);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        dSASigner.init(false, dSAPublicKeyParameters);
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void test1024bitRSA() {
        BigInteger bigInteger = new BigInteger("dbe3d9e35c7b3791e235e9146a5e27be06f202bbd2bc4c772e892b6d613da42cea1f0bffdd45220c1e7e9a21f94b0d86363986238e07d8b28fabde84ed35f1620daef807f27e021be84c7dffecc1106ab414a004a06c410f7cf96c720fbc70a2b357a4edd709ed23c7dc6e6e01433cd8a3e5b49b09ef4f4b6b0086f2fb07b4d9", 16);
        BigInteger bigInteger2 = new BigInteger("10001", 16);
        BigInteger bigInteger3 = new BigInteger("2f06cbd29434c5edad335a65c359dfa604563dbf6d9257c8256bb09df3edfaeea02383ad74e514230362901433fc9927daf0f27f282105772ac2d71416a732b820163b22f7e808fa27af5d5e7952ba9f8ecd8e0724469a57bd0d3de828d4953aad0be5ed63ad5b726b012abf5540d4a766b6009124077aac577bcf2ef677531", 16);
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(112, 80));
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, bigInteger, bigInteger2);
        RSAKeyParameters rSAKeyParameters2 = new RSAKeyParameters(true, bigInteger, bigInteger3);
        RSAEngine rSAEngine = new RSAEngine();
        try {
            rSAEngine.init(true, rSAKeyParameters2);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 112 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        rSAEngine.init(false, rSAKeyParameters);
        try {
            rSAEngine.init(true, rSAKeyParameters);
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 112 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        this.signer1024Test(rSAKeyParameters, rSAKeyParameters2, new RSADigestSigner(SHA256Digest.newInstance()));
        this.signer1024Test(rSAKeyParameters, rSAKeyParameters2, new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)SHA256Digest.newInstance(), 20));
        this.signer1024Test(rSAKeyParameters, rSAKeyParameters2, new ISO9796d2PSSSigner(new RSAEngine(), SHA256Digest.newInstance(), 20));
        this.signer1024Test(rSAKeyParameters, rSAKeyParameters2, new ISO9796d2Signer(new RSAEngine(), SHA256Digest.newInstance()));
        this.signer1024Test(rSAKeyParameters, rSAKeyParameters2, new X931Signer(new RSAEngine(), SHA256Digest.newInstance()));
        this.signer1024Test(rSAKeyParameters, rSAKeyParameters2, new GenericSigner(new RSAEngine(), SHA256Digest.newInstance()));
        rSAEngine.init(false, rSAKeyParameters2);
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testCramerShoup() {
        SecureRandom secureRandom = new SecureRandom();
        CramerShoupKeyPairGenerator cramerShoupKeyPairGenerator = new CramerShoupKeyPairGenerator();
        CramerShoupParametersGenerator cramerShoupParametersGenerator = new CramerShoupParametersGenerator();
        cramerShoupParametersGenerator.init(1024, 1, secureRandom);
        cramerShoupKeyPairGenerator.init(new CramerShoupKeyGenerationParameters(secureRandom, cramerShoupParametersGenerator.generateParameters(DHStandardGroups.rfc2409_1024)));
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = cramerShoupKeyPairGenerator.generateKeyPair();
        CramerShoupCoreEngine cramerShoupCoreEngine = new CramerShoupCoreEngine();
        try {
            cramerShoupCoreEngine.init(true, asymmetricCipherKeyPair.getPublic());
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        cramerShoupCoreEngine.init(false, asymmetricCipherKeyPair.getPrivate());
        try {
            cramerShoupKeyPairGenerator.init(new CramerShoupKeyGenerationParameters(secureRandom, cramerShoupParametersGenerator.generateParameters(DHStandardGroups.rfc2409_1024)));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testDH() {
        SecureRandom secureRandom = new SecureRandom();
        DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
        dHKeyPairGenerator.init(new DHKeyGenerationParameters(secureRandom, DHStandardGroups.rfc2409_1024));
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128, 112));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        this.dhTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new DHAgreement());
        this.dhTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new DHBasicAgreement());
        this.dhTest((CipherParameters)new DHUPublicParameters((DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic()), (CipherParameters)new DHUPrivateParameters((DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()), new DHUnifiedAgreement());
        this.dhTest((CipherParameters)new DHMQVPublicParameters((DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic()), (CipherParameters)new DHMQVPrivateParameters((DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()), new MQVBasicAgreement());
        try {
            dHKeyPairGenerator.init(new DHKeyGenerationParameters(secureRandom, DHStandardGroups.rfc2409_768));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 20", cryptoServiceConstraintsException.getMessage());
        }
        try {
            DHBasicKeyPairGenerator dHBasicKeyPairGenerator = new DHBasicKeyPairGenerator();
            dHBasicKeyPairGenerator.init(new DHKeyGenerationParameters(secureRandom, DHStandardGroups.rfc2409_768));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 20", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testDSA() {
        DSAParameters dSAParameters = new DSAParameters(new BigInteger("F56C2A7D366E3EBDEAA1891FD2A0D099436438A673FED4D75F594959CFFEBCA7BE0FC72E4FE67D91D801CBA0693AC4ED9E411B41D19E2FD1699C4390AD27D94C69C0B143F1DC88932CFE2310C886412047BD9B1C7A67F8A25909132627F51A0C866877E672E555342BDF9355347DBD43B47156B2C20BAD9D2B071BC2FDCF9757F75C168C5D9FC43131BE162A0756D1BDEC2CA0EB0E3B018A8B38D3EF2487782AEB9FBF99D8B30499C55E4F61E5C7DCEE2A2BB55BD7F75FCDF00E48F2E8356BDB59D86114028F67B8E07B127744778AFF1CF1399A4D679D92FDE7D941C5C85C5D7BFF91BA69F9489D531D1EBFA727CFDA651390F8021719FA9F7216CEB177BD75", 16), new BigInteger("C24ED361870B61E0D367F008F99F8A1F75525889C89DB1B673C45AF5867CB467", 16), new BigInteger("8DC6CC814CAE4A1C05A3E186A6FE27EABA8CDB133FDCE14A963A92E809790CBA096EAA26140550C129FA2B98C16E84236AA33BF919CD6F587E048C52666576DB6E925C6CBE9B9EC5C16020F9A44C9F1C8F7A8E611C1F6EC2513EA6AA0B8D0F72FED73CA37DF240DB57BBB27431D618697B9E771B0B301D5DF05955425061A30DC6D33BB6D2A32BD0A75A0A71D2184F506372ABF84A56AEEEA8EB693BF29A640345FA1298A16E85421B2208D00068A5A42915F82CF0B858C8FA39D43D704B6927E0B2F916304E86FB6A1B487F07D8139E428BB096C6D67A76EC0B8D4EF274B8A2CF556D279AD267CCEF5AF477AFED029F485B5597739F5D0240F67C2D948A6279", 16));
        SecureRandom secureRandom = new SecureRandom();
        DSAKeyPairGenerator dSAKeyPairGenerator = new DSAKeyPairGenerator();
        dSAKeyPairGenerator.init(new DSAKeyGenerationParameters(secureRandom, dSAParameters));
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dSAKeyPairGenerator.generateKeyPair();
        this.dsaSignerTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new DSASigner());
        CryptoServicesRegistrar.setServicesConstraints(new BitsOfSecurityConstraint(256));
        try {
            dSAKeyPairGenerator.init(new DSAKeyGenerationParameters(secureRandom, dSAParameters));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 112", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testEC() {
        SecureRandom secureRandom = new SecureRandom();
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(new ECDomainParameters(X962NamedCurves.getByName("prime192v1")), secureRandom));
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        this.ecSignerTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new ECDSASigner());
        this.ecSignerTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new DSTU4145Signer());
        this.ecSignerTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new ECGOST3410Signer());
        this.ecSignerTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new SM2Signer());
        this.ecAgreementTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new ECDHBasicAgreement());
        this.ecAgreementTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new ECDHCBasicAgreement());
        this.ecAgreementTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new ECDHCStagedAgreement());
        this.ecAgreementTest(new ECDHUPublicParameters((ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic()), new ECDHUPrivateParameters((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()), new ECDHCUnifiedAgreement());
        this.ecAgreementTest(new MQVPublicParameters((ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic()), new MQVPrivateParameters((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()), new ECMQVBasicAgreement());
        this.ecAgreementTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new ECVKOAgreement(SHA256Digest.newInstance()));
        try {
            eCKeyPairGenerator.init(new ECKeyGenerationParameters(new ECDomainParameters(X962NamedCurves.getByName("prime192v1")), secureRandom));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 96", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testECIESKEM() {
        SecureRandom secureRandom = new SecureRandom();
        KDF2BytesGenerator kDF2BytesGenerator = new KDF2BytesGenerator(new SHA1Digest());
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(new ECDomainParameters(X962NamedCurves.getByName("prime192v1")), secureRandom));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        byte[] byArray = new byte[49];
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testEdwards() {
        SecureRandom secureRandom = new SecureRandom();
        Ed25519KeyPairGenerator ed25519KeyPairGenerator = new Ed25519KeyPairGenerator();
        ed25519KeyPairGenerator.init(new Ed25519KeyGenerationParameters(secureRandom));
        Ed448KeyPairGenerator ed448KeyPairGenerator = new Ed448KeyPairGenerator();
        ed448KeyPairGenerator.init(new Ed448KeyGenerationParameters(secureRandom));
        X25519KeyPairGenerator x25519KeyPairGenerator = new X25519KeyPairGenerator();
        x25519KeyPairGenerator.init(new X25519KeyGenerationParameters(secureRandom));
        X448KeyPairGenerator x448KeyPairGenerator = new X448KeyPairGenerator();
        x448KeyPairGenerator.init(new X448KeyGenerationParameters(secureRandom));
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = ed25519KeyPairGenerator.generateKeyPair();
        this.edwardsSignerTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new Ed25519Signer(), "128");
        this.edwardsSignerTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new Ed25519phSigner(new byte[1]), "128");
        this.edwardsSignerTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new Ed25519ctxSigner(new byte[1]), "128");
        asymmetricCipherKeyPair = ed448KeyPairGenerator.generateKeyPair();
        this.edwardsSignerTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new Ed448Signer(new byte[1]), "224");
        this.edwardsSignerTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new Ed448phSigner(new byte[1]), "224");
        asymmetricCipherKeyPair = x25519KeyPairGenerator.generateKeyPair();
        this.edwardsAgreementTest((CipherParameters)asymmetricCipherKeyPair.getPublic(), (CipherParameters)asymmetricCipherKeyPair.getPrivate(), new X25519Agreement(), "128");
        this.edwardsAgreementTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new XDHBasicAgreement(), "128");
        this.edwardsAgreementTest(new XDHUPublicParameters(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPublic()), new XDHUPrivateParameters(asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair.getPrivate()), new XDHUnifiedAgreement(new X25519Agreement()), "128");
        asymmetricCipherKeyPair = x448KeyPairGenerator.generateKeyPair();
        this.edwardsAgreementTest((CipherParameters)asymmetricCipherKeyPair.getPublic(), (CipherParameters)asymmetricCipherKeyPair.getPrivate(), new X448Agreement(), "224");
        this.edwardsAgreementTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new XDHBasicAgreement(), "224");
        try {
            ed25519KeyPairGenerator.init(new Ed25519KeyGenerationParameters(secureRandom));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        try {
            ed448KeyPairGenerator.init(new Ed448KeyGenerationParameters(secureRandom));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals("service does not provide 256 bits of security only 224", cryptoServiceConstraintsException.getMessage());
        }
        try {
            x25519KeyPairGenerator.init(new X25519KeyGenerationParameters(secureRandom));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        try {
            x448KeyPairGenerator.init(new X448KeyGenerationParameters(secureRandom));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 224", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testElgamal() {
        SecureRandom secureRandom = new SecureRandom();
        ElGamalKeyPairGenerator elGamalKeyPairGenerator = new ElGamalKeyPairGenerator();
        elGamalKeyPairGenerator.init(new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(DHStandardGroups.rfc2409_1024.getP(), DHStandardGroups.rfc2409_1024.getG())));
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = elGamalKeyPairGenerator.generateKeyPair();
        ElGamalEngine elGamalEngine = new ElGamalEngine();
        try {
            elGamalEngine.init(true, asymmetricCipherKeyPair.getPublic());
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        elGamalEngine.init(false, asymmetricCipherKeyPair.getPrivate());
        try {
            elGamalKeyPairGenerator.init(new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(DHStandardGroups.rfc2409_1024.getP(), DHStandardGroups.rfc2409_1024.getG())));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testGost3410() {
        GOST3410Parameters gOST3410Parameters = new GOST3410Parameters(new BigInteger("F56C2A7D366E3EBDEAA1891FD2A0D099436438A673FED4D75F594959CFFEBCA7BE0FC72E4FE67D91D801CBA0693AC4ED9E411B41D19E2FD1699C4390AD27D94C69C0B143F1DC88932CFE2310C886412047BD9B1C7A67F8A25909132627F51A0C866877E672E555342BDF9355347DBD43B47156B2C20BAD9D2B071BC2FDCF9757F75C168C5D9FC43131BE162A0756D1BDEC2CA0EB0E3B018A8B38D3EF2487782AEB9FBF99D8B30499C55E4F61E5C7DCEE2A2BB55BD7F75FCDF00E48F2E8356BDB59D86114028F67B8E07B127744778AFF1CF1399A4D679D92FDE7D941C5C85C5D7BFF91BA69F9489D531D1EBFA727CFDA651390F8021719FA9F7216CEB177BD75", 16), new BigInteger("C24ED361870B61E0D367F008F99F8A1F75525889C89DB1B673C45AF5867CB467", 16), new BigInteger("8DC6CC814CAE4A1C05A3E186A6FE27EABA8CDB133FDCE14A963A92E809790CBA096EAA26140550C129FA2B98C16E84236AA33BF919CD6F587E048C52666576DB6E925C6CBE9B9EC5C16020F9A44C9F1C8F7A8E611C1F6EC2513EA6AA0B8D0F72FED73CA37DF240DB57BBB27431D618697B9E771B0B301D5DF05955425061A30DC6D33BB6D2A32BD0A75A0A71D2184F506372ABF84A56AEEEA8EB693BF29A640345FA1298A16E85421B2208D00068A5A42915F82CF0B858C8FA39D43D704B6927E0B2F916304E86FB6A1B487F07D8139E428BB096C6D67A76EC0B8D4EF274B8A2CF556D279AD267CCEF5AF477AFED029F485B5597739F5D0240F67C2D948A6279", 16));
        SecureRandom secureRandom = new SecureRandom();
        GOST3410KeyPairGenerator gOST3410KeyPairGenerator = new GOST3410KeyPairGenerator();
        gOST3410KeyPairGenerator.init(new GOST3410KeyGenerationParameters(secureRandom, gOST3410Parameters));
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = gOST3410KeyPairGenerator.generateKeyPair();
        this.dsaSignerTest(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair.getPrivate(), new GOST3410Signer());
        CryptoServicesRegistrar.setServicesConstraints(new BitsOfSecurityConstraint(256));
        try {
            gOST3410KeyPairGenerator.init(new GOST3410KeyGenerationParameters(secureRandom, gOST3410Parameters));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 112", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testNaccacheStern() {
        SecureRandom secureRandom = new SecureRandom();
        NaccacheSternKeyPairGenerator naccacheSternKeyPairGenerator = new NaccacheSternKeyPairGenerator();
        naccacheSternKeyPairGenerator.init(new NaccacheSternKeyGenerationParameters(secureRandom, 1024, 8, 40));
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = naccacheSternKeyPairGenerator.generateKeyPair();
        NaccacheSternEngine naccacheSternEngine = new NaccacheSternEngine();
        try {
            naccacheSternEngine.init(true, asymmetricCipherKeyPair.getPublic());
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        naccacheSternEngine.init(false, asymmetricCipherKeyPair.getPrivate());
        try {
            naccacheSternKeyPairGenerator.init(new NaccacheSternKeyGenerationParameters(secureRandom, 1024, 8, 40));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testRSA() {
        SecureRandom secureRandom = new SecureRandom();
        RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
        rSAKeyPairGenerator.init(new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), secureRandom, 1024, 100));
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = rSAKeyPairGenerator.generateKeyPair();
        RSAEngine rSAEngine = new RSAEngine();
        try {
            rSAEngine.init(true, asymmetricCipherKeyPair.getPublic());
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        rSAEngine.init(false, asymmetricCipherKeyPair.getPrivate());
        try {
            rSAKeyPairGenerator.init(new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), secureRandom, 1024, 100));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testRsaKEM() {
        SecureRandom secureRandom = new SecureRandom();
        RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
        rSAKeyPairGenerator.init(new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), secureRandom, 1024, 100));
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(128, 80));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = rSAKeyPairGenerator.generateKeyPair();
        KDF2BytesGenerator kDF2BytesGenerator = new KDF2BytesGenerator(new SHA1Digest());
        SecureRandom secureRandom2 = new SecureRandom();
        RSAKEMGenerator rSAKEMGenerator = new RSAKEMGenerator(16, kDF2BytesGenerator, secureRandom2);
        try {
            rSAKEMGenerator.generateEncapsulated(asymmetricCipherKeyPair.getPublic());
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        RSAKEMExtractor rSAKEMExtractor = new RSAKEMExtractor((RSAKeyParameters)asymmetricCipherKeyPair.getPrivate(), 16, kDF2BytesGenerator);
        try {
            rSAKeyPairGenerator.init(new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), secureRandom, 1024, 100));
            this.fail("no exception");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 128 bits of security only 80", cryptoServiceConstraintsException.getMessage());
        }
        CryptoServicesRegistrar.setServicesConstraints(null);
    }

    private void testSM2Cipher() {
        SecureRandom secureRandom = new SecureRandom();
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(new ECDomainParameters(ECNamedCurveTable.getByName("P-256")), secureRandom));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        CryptoServicesRegistrar.setServicesConstraints(new LegacyBitsOfSecurityConstraint(256, 128));
        SM2Engine sM2Engine = new SM2Engine();
        try {
            sM2Engine.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPublic(), secureRandom));
            this.fail("no exception!");
        }
        catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
            this.isEquals(cryptoServiceConstraintsException.getMessage(), "service does not provide 256 bits of security only 128", cryptoServiceConstraintsException.getMessage());
        }
        sM2Engine.init(false, asymmetricCipherKeyPair.getPrivate());
        CryptoServicesRegistrar.setServicesConstraints(null);
    }
}

