/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Random;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.digests.AsconDigest;
import org.bouncycastle.crypto.digests.AsconXof;
import org.bouncycastle.crypto.engines.AsconEngine;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class AsconTest
extends SimpleTest {
    private static AsconDigest createDigest(AsconDigest.AsconParameters asconParameters) {
        return new AsconDigest(asconParameters);
    }

    private static AsconEngine createEngine(AsconEngine.AsconParameters asconParameters) {
        return new AsconEngine(asconParameters);
    }

    private static AsconXof createXof(AsconXof.AsconParameters asconParameters) {
        return new AsconXof(asconParameters);
    }

    public String getName() {
        return "Ascon";
    }

    private void implTestBufferingEngine(AsconEngine.AsconParameters asconParameters) throws Exception {
        Random random = new Random();
        int n = 256;
        byte[] byArray = new byte[n];
        random.nextBytes(byArray);
        AsconEngine asconEngine = AsconTest.createEngine(asconParameters);
        AsconTest.initEngine(asconEngine, true);
        byte[] byArray2 = new byte[asconEngine.getOutputSize(n)];
        random.nextBytes(byArray2);
        int n2 = asconEngine.processBytes(byArray, 0, n, byArray2, 0);
        n2 += asconEngine.doFinal(byArray2, n2);
        byte[] byArray3 = new byte[n2];
        int n3 = 1;
        while (n3 < n) {
            AsconEngine asconEngine2 = AsconTest.createEngine(asconParameters);
            AsconTest.initEngine(asconEngine2, true);
            random.nextBytes(byArray3);
            int n4 = asconEngine2.processBytes(byArray, 0, n3, byArray3, 0);
            if (asconEngine2.getUpdateOutputSize(0) != 0) {
                this.fail("");
            }
            n4 += asconEngine2.processBytes(byArray, n3, n - n3, byArray3, n4);
            if (!Arrays.areEqual(byArray2, 0, n2, byArray3, 0, n4 += asconEngine2.doFinal(byArray3, n4))) {
                this.fail("encryption failed with split: " + n3);
            }
            ++n3;
        }
        int n5 = 1;
        while (n5 < n2) {
            AsconEngine asconEngine3 = AsconTest.createEngine(asconParameters);
            AsconTest.initEngine(asconEngine3, false);
            random.nextBytes(byArray3);
            int n6 = asconEngine3.processBytes(byArray2, 0, n5, byArray3, 0);
            if (asconEngine3.getUpdateOutputSize(0) != 0) {
                this.fail("");
            }
            n6 += asconEngine3.processBytes(byArray2, n5, n2 - n5, byArray3, n6);
            if (!Arrays.areEqual(byArray, 0, n, byArray3, 0, n6 += asconEngine3.doFinal(byArray3, n6))) {
                this.fail("decryption failed with split: " + n5);
            }
            ++n5;
        }
    }

    private void implTestExceptionsDigest(AsconDigest.AsconParameters asconParameters) {
        AsconDigest asconDigest = AsconTest.createDigest(asconParameters);
        try {
            asconDigest.update(new byte[1], 1, 1);
            this.fail(String.valueOf(asconDigest.getAlgorithmName()) + ": input for update is too short");
        }
        catch (DataLengthException dataLengthException) {}
        try {
            asconDigest.doFinal(new byte[asconDigest.getDigestSize() - 1], 2);
            this.fail(String.valueOf(asconDigest.getAlgorithmName()) + ": output for dofinal is too short");
        }
        catch (OutputLengthException outputLengthException) {}
    }

    private void implTestExceptionsEngine(AsconEngine.AsconParameters asconParameters) throws Exception {
        int n;
        AsconEngine asconEngine = AsconTest.createEngine(asconParameters);
        int n2 = asconEngine.getKeyBytesSize();
        int n3 = asconEngine.getIVBytesSize();
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[]{};
        ParametersWithIV parametersWithIV = new ParametersWithIV(new KeyParameter(byArray), byArray2);
        try {
            asconEngine.processBytes(byArray3, 0, byArray3.length, null, 0);
            this.fail(String.valueOf(asconEngine.getAlgorithmName()) + " need to be initialized before processBytes");
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            asconEngine.processByte((byte)0, null, 0);
            this.fail(String.valueOf(asconEngine.getAlgorithmName()) + " need to be initialized before processByte");
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            asconEngine.reset();
            this.fail(String.valueOf(asconEngine.getAlgorithmName()) + " need to be initialized before reset");
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            asconEngine.doFinal(null, byArray3.length);
            this.fail(String.valueOf(asconEngine.getAlgorithmName()) + " need to be initialized before dofinal");
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            asconEngine.getMac();
            asconEngine.getOutputSize(0);
            asconEngine.getUpdateOutputSize(0);
        }
        catch (IllegalStateException illegalStateException) {
            this.fail(String.valueOf(asconEngine.getAlgorithmName()) + " functions can be called before initialization");
        }
        Random random = new Random();
        while ((n = random.nextInt(100)) == n2) {
        }
        byte[] byArray4 = new byte[n];
        while ((n = random.nextInt(100)) == n3) {
        }
        byte[] byArray5 = new byte[n];
        try {
            asconEngine.init(true, new ParametersWithIV(new KeyParameter(byArray4), byArray2));
            this.fail(String.valueOf(asconEngine.getAlgorithmName()) + " k size does not match");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            asconEngine.init(true, new ParametersWithIV(new KeyParameter(byArray), byArray5));
            this.fail(String.valueOf(asconEngine.getAlgorithmName()) + "iv size does not match");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            asconEngine.init(true, new AEADParameters(new KeyParameter(byArray), 0, byArray2));
            this.fail(String.valueOf(asconEngine.getAlgorithmName()) + " wrong type of CipherParameters");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        asconEngine.init(true, parametersWithIV);
        byte[] byArray6 = new byte[asconEngine.getOutputSize(byArray3.length)];
        try {
            asconEngine.doFinal(byArray6, byArray3.length);
        }
        catch (Exception exception) {
            this.fail(String.valueOf(asconEngine.getAlgorithmName()) + " allows no input for AAD and plaintext");
        }
        byte[] byArray7 = asconEngine.getMac();
        if (byArray7 == null) {
            this.fail("mac should not be empty after dofinal");
        }
        if (!this.areEqual(byArray7, byArray6)) {
            this.fail("mac should be equal when calling dofinal and getMac");
        }
        asconEngine.init(true, parametersWithIV);
        asconEngine.processAADByte((byte)0);
        byte[] byArray8 = new byte[asconEngine.getOutputSize(0)];
        asconEngine.doFinal(byArray8, 0);
        if (this.areEqual(byArray8, byArray7)) {
            this.fail("mac should not match");
        }
        asconEngine.init(true, parametersWithIV);
        asconEngine.processByte((byte)0, null, 0);
        try {
            asconEngine.processAADByte((byte)0);
            this.fail("processAADByte(s) cannot be called after encryption/decryption");
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            asconEngine.processAADBytes(new byte[1], 0, 1);
            this.fail("processAADByte(s) cannot be called once only");
        }
        catch (IllegalStateException illegalStateException) {}
        asconEngine.reset();
        try {
            asconEngine.processAADBytes(new byte[1], 1, 1);
            this.fail("input for processAADBytes is too short");
        }
        catch (DataLengthException dataLengthException) {}
        try {
            asconEngine.processBytes(new byte[1], 1, 1, byArray6, 0);
            this.fail("input for processBytes is too short");
        }
        catch (DataLengthException dataLengthException) {}
        asconEngine.init(true, parametersWithIV);
        try {
            int n4 = asconEngine.getUpdateOutputSize(64);
            asconEngine.processBytes(new byte[64], 0, 64, new byte[n4], 1);
            this.fail("output for processBytes is too short");
        }
        catch (OutputLengthException outputLengthException) {}
        try {
            asconEngine.doFinal(new byte[2], 2);
            this.fail("output for dofinal is too short");
        }
        catch (OutputLengthException outputLengthException) {}
        this.implTestExceptionsGetUpdateOutputSize(asconEngine, false, parametersWithIV, 100);
        this.implTestExceptionsGetUpdateOutputSize(asconEngine, true, parametersWithIV, 100);
        byArray8 = new byte[asconEngine.getOutputSize(0)];
        byArray7 = new byte[asconEngine.getOutputSize(0)];
        asconEngine.init(true, parametersWithIV);
        asconEngine.processAADBytes(new byte[2], 0, 2);
        asconEngine.doFinal(byArray8, 0);
        asconEngine.init(true, parametersWithIV);
        asconEngine.processAADByte((byte)0);
        asconEngine.processAADByte((byte)0);
        asconEngine.doFinal(byArray7, 0);
        if (!this.areEqual(byArray8, byArray7)) {
            this.fail("mac should match for the same AAD with different ways of inputing");
        }
        byte[] byArray9 = new byte[asconEngine.getOutputSize(10)];
        byte[] byArray10 = new byte[asconEngine.getOutputSize(10) + 2];
        byte[] byArray11 = new byte[5];
        byArray11[1] = 1;
        byArray11[2] = 2;
        byArray11[3] = 3;
        byArray11[4] = 4;
        byte[] byArray12 = byArray11;
        byte[] byArray13 = new byte[7];
        byArray13[2] = 1;
        byArray13[3] = 2;
        byArray13[4] = 3;
        byArray13[5] = 4;
        byArray13[6] = 5;
        byte[] byArray14 = byArray13;
        byte[] byArray15 = new byte[10];
        byArray15[1] = 1;
        byArray15[2] = 2;
        byArray15[3] = 3;
        byArray15[4] = 4;
        byArray15[5] = 5;
        byArray15[6] = 6;
        byArray15[7] = 7;
        byArray15[8] = 8;
        byArray15[9] = 9;
        byte[] byArray16 = byArray15;
        byte[] byArray17 = new byte[12];
        byArray17[2] = 1;
        byArray17[3] = 2;
        byArray17[4] = 3;
        byArray17[5] = 4;
        byArray17[6] = 5;
        byArray17[7] = 6;
        byArray17[8] = 7;
        byArray17[9] = 8;
        byArray17[10] = 9;
        byArray17[11] = 10;
        byte[] byArray18 = byArray17;
        byte[] byArray19 = new byte[byArray16.length];
        asconEngine.init(true, parametersWithIV);
        asconEngine.processAADBytes(byArray12, 0, byArray12.length);
        int n5 = asconEngine.processBytes(byArray16, 0, byArray16.length, byArray9, 0);
        asconEngine.doFinal(byArray9, n5);
        asconEngine.init(true, parametersWithIV);
        asconEngine.processAADBytes(byArray14, 1, byArray12.length);
        n5 = asconEngine.processBytes(byArray18, 1, byArray16.length, byArray10, 1);
        asconEngine.doFinal(byArray10, n5 + 1);
        byte[] byArray20 = new byte[byArray9.length];
        System.arraycopy(byArray10, 1, byArray20, 0, byArray9.length);
        if (!this.areEqual(byArray9, byArray20)) {
            this.fail("mac should match for the same AAD and message with different offset for both input and output");
        }
        asconEngine.init(false, parametersWithIV);
        asconEngine.processAADBytes(byArray12, 0, byArray12.length);
        n5 = asconEngine.processBytes(byArray9, 0, byArray9.length, byArray19, 0);
        asconEngine.doFinal(byArray19, n5);
        if (!this.areEqual(byArray16, byArray19)) {
            this.fail("The encryption and decryption does not recover the plaintext");
        }
        int n6 = byArray9.length - 1;
        byArray9[n6] = (byte)(byArray9[n6] ^ 1);
        asconEngine.init(false, parametersWithIV);
        asconEngine.processAADBytes(byArray12, 0, byArray12.length);
        n5 = asconEngine.processBytes(byArray9, 0, byArray9.length, byArray19, 0);
        try {
            asconEngine.doFinal(byArray19, n5);
            this.fail("The decryption should fail");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {}
        byte[] byArray21 = new byte[32 + random.nextInt(32)];
        random.nextBytes(byArray21);
        asconEngine.init(true, parametersWithIV);
        byte[] byArray22 = new byte[asconEngine.getOutputSize(byArray21.length)];
        byte[] byArray23 = new byte[byArray22.length];
        byte[] byArray24 = new byte[byArray22.length];
        asconEngine.processAADBytes(byArray12, 0, byArray12.length);
        n5 = asconEngine.processBytes(byArray21, 0, byArray21.length, byArray22, 0);
        asconEngine.doFinal(byArray22, n5);
        asconEngine.init(true, parametersWithIV);
        asconEngine.processAADBytes(byArray12, 0, byArray12.length);
        n5 = asconEngine.processBytes(byArray21, 0, byArray21.length / 2, byArray23, 0);
        n5 += asconEngine.processBytes(byArray21, byArray21.length / 2, byArray21.length - byArray21.length / 2, byArray23, n5);
        n5 += asconEngine.doFinal(byArray23, n5);
        asconEngine.init(true, parametersWithIV);
        int n7 = random.nextInt(byArray21.length - 1) + 1;
        asconEngine.processAADBytes(byArray12, 0, byArray12.length);
        n5 = asconEngine.processBytes(byArray21, 0, n7, byArray24, 0);
        n5 += asconEngine.processBytes(byArray21, n7, byArray21.length - n7, byArray24, n5);
        n5 += asconEngine.doFinal(byArray24, n5);
        if (!this.areEqual(byArray22, byArray23) || !this.areEqual(byArray22, byArray24)) {
            this.fail("Splitting input of plaintext should output the same ciphertext");
        }
    }

    private void implTestExceptionsGetUpdateOutputSize(AsconEngine asconEngine, boolean bl, CipherParameters cipherParameters, int n) {
        asconEngine.init(bl, cipherParameters);
        int n2 = asconEngine.getUpdateOutputSize(n);
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 <= n) {
            asconEngine.init(bl, cipherParameters);
            int n4 = asconEngine.getUpdateOutputSize(n3);
            if (n4 > 0) {
                try {
                    asconEngine.processBytes(byArray, 0, n3, byArray2, n2 - n4 + 1);
                    this.fail("output for processBytes is too short");
                }
                catch (OutputLengthException outputLengthException) {}
            } else {
                asconEngine.processBytes(byArray, 0, n3, null, 0);
            }
            ++n3;
        }
    }

    private void implTestExceptionsXof(AsconXof.AsconParameters asconParameters) {
        AsconXof asconXof = AsconTest.createXof(asconParameters);
        try {
            asconXof.update(new byte[1], 1, 1);
            this.fail(String.valueOf(asconXof.getAlgorithmName()) + ": input for update is too short");
        }
        catch (DataLengthException dataLengthException) {}
        try {
            asconXof.doFinal(new byte[asconXof.getDigestSize() - 1], 2);
            this.fail(String.valueOf(asconXof.getAlgorithmName()) + ": output for dofinal is too short");
        }
        catch (OutputLengthException outputLengthException) {}
    }

    private void implTestParametersDigest(AsconDigest.AsconParameters asconParameters, int n) {
        AsconDigest asconDigest = AsconTest.createDigest(asconParameters);
        if (asconDigest.getDigestSize() != n) {
            this.fail(String.valueOf(asconDigest.getAlgorithmName()) + ": digest size is not correct");
        }
    }

    private void implTestParametersEngine(AsconEngine.AsconParameters asconParameters, int n, int n2, int n3) {
        AsconEngine asconEngine = AsconTest.createEngine(asconParameters);
        if (asconEngine.getKeyBytesSize() != n) {
            this.fail("key bytes of " + asconEngine.getAlgorithmName() + " is not correct");
        }
        if (asconEngine.getIVBytesSize() != n2) {
            this.fail("iv bytes of " + asconEngine.getAlgorithmName() + " is not correct");
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(new KeyParameter(new byte[n]), new byte[n2]);
        asconEngine.init(true, parametersWithIV);
        if (asconEngine.getOutputSize(0) != n3) {
            this.fail("getOutputSize of " + asconEngine.getAlgorithmName() + " is incorrect for encryption");
        }
        asconEngine.init(false, parametersWithIV);
        if (asconEngine.getOutputSize(n3) != 0) {
            this.fail("getOutputSize of " + asconEngine.getAlgorithmName() + " is incorrect for decryption");
        }
    }

    private void implTestParametersXof(AsconXof.AsconParameters asconParameters, int n) {
        AsconXof asconXof = AsconTest.createXof(asconParameters);
        if (asconXof.getDigestSize() != n) {
            this.fail(String.valueOf(asconXof.getAlgorithmName()) + ": digest size is not correct");
        }
    }

    private void implTestVectorsDigest(AsconDigest.AsconParameters asconParameters, String string) throws Exception {
        String string2;
        Random random = new Random();
        AsconDigest asconDigest = AsconTest.createDigest(asconParameters);
        InputStream inputStream = TestResourceFinder.findTestResource("crypto/ascon", String.valueOf(string) + "_LWC_HASH_KAT_256.txt");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            int n = string2.indexOf(61);
            if (n < 0) {
                byte[] byArray = Hex.decode((String)hashMap.get("Msg"));
                byte[] byArray2 = Hex.decode((String)hashMap.get("MD"));
                byte[] byArray3 = new byte[asconDigest.getDigestSize()];
                asconDigest.update(byArray, 0, byArray.length);
                asconDigest.doFinal(byArray3, 0);
                if (!this.areEqual(byArray3, byArray2)) {
                    this.mismatch("Keystream " + hashMap.get("Count"), (String)hashMap.get("MD"), byArray3);
                }
                if (byArray.length > 1) {
                    int n2 = random.nextInt(byArray.length - 1) + 1;
                    asconDigest.update(byArray, 0, n2);
                    asconDigest.update(byArray, n2, byArray.length - n2);
                    asconDigest.doFinal(byArray3, 0);
                    if (!this.areEqual(byArray3, byArray2)) {
                        this.mismatch("Keystream " + hashMap.get("Count"), (String)hashMap.get("MD"), byArray3);
                    }
                }
                hashMap.clear();
                continue;
            }
            hashMap.put(string2.substring(0, n).trim(), string2.substring(n + 1).trim());
        }
    }

    private void implTestVectorsEngine(AsconEngine.AsconParameters asconParameters, String string) throws Exception {
        String string2;
        Random random = new Random();
        AsconEngine asconEngine = AsconTest.createEngine(asconParameters);
        InputStream inputStream = TestResourceFinder.findTestResource("crypto/ascon", "LWC_AEAD_KAT_" + string + ".txt");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            int n = string2.indexOf(61);
            if (n < 0) {
                byte[] byArray = Hex.decode((String)hashMap.get("Key"));
                byte[] byArray2 = Hex.decode((String)hashMap.get("Nonce"));
                byte[] byArray3 = Hex.decode((String)hashMap.get("AD"));
                byte[] byArray4 = Hex.decode((String)hashMap.get("PT"));
                byte[] byArray5 = Hex.decode((String)hashMap.get("CT"));
                ParametersWithIV parametersWithIV = new ParametersWithIV(new KeyParameter(byArray), byArray2);
                asconEngine.init(true, parametersWithIV);
                byte[] byArray6 = new byte[asconEngine.getOutputSize(byArray4.length)];
                random.nextBytes(byArray6);
                asconEngine.processAADBytes(byArray3, 0, byArray3.length);
                int n2 = asconEngine.processBytes(byArray4, 0, byArray4.length, byArray6, 0);
                n2 += asconEngine.doFinal(byArray6, n2);
                if (!this.areEqual(byArray6, 0, n2, byArray5, 0, byArray5.length)) {
                    this.mismatch("Keystream " + hashMap.get("Count"), (String)hashMap.get("CT"), byArray6);
                }
                asconEngine.init(false, parametersWithIV);
                byte[] byArray7 = new byte[asconEngine.getOutputSize(byArray5.length)];
                random.nextBytes(byArray7);
                asconEngine.processAADBytes(byArray3, 0, byArray3.length);
                int n3 = asconEngine.processBytes(byArray5, 0, byArray5.length, byArray7, 0);
                n3 += asconEngine.doFinal(byArray7, n3);
                if (!this.areEqual(byArray7, 0, n3, byArray4, 0, byArray4.length)) {
                    this.mismatch("Reccover Keystream " + hashMap.get("Count"), (String)hashMap.get("PT"), byArray7);
                }
                hashMap.clear();
                continue;
            }
            hashMap.put(string2.substring(0, n).trim(), string2.substring(n + 1).trim());
        }
    }

    private void implTestVectorsXof(AsconXof.AsconParameters asconParameters, String string) throws Exception {
        String string2;
        Random random = new Random();
        AsconXof asconXof = AsconTest.createXof(asconParameters);
        InputStream inputStream = TestResourceFinder.findTestResource("crypto/ascon", String.valueOf(string) + "_LWC_HASH_KAT_256.txt");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            int n = string2.indexOf(61);
            if (n < 0) {
                byte[] byArray = Hex.decode((String)hashMap.get("Msg"));
                byte[] byArray2 = Hex.decode((String)hashMap.get("MD"));
                byte[] byArray3 = new byte[asconXof.getDigestSize()];
                asconXof.update(byArray, 0, byArray.length);
                asconXof.doFinal(byArray3, 0);
                if (!this.areEqual(byArray3, byArray2)) {
                    this.mismatch("Keystream " + hashMap.get("Count"), (String)hashMap.get("MD"), byArray3);
                }
                if (byArray.length <= 1) continue;
                int n2 = random.nextInt(byArray.length - 1) + 1;
                asconXof.update(byArray, 0, n2);
                asconXof.update(byArray, n2, byArray.length - n2);
                asconXof.doFinal(byArray3, 0);
                if (this.areEqual(byArray3, byArray2)) continue;
                this.mismatch("Keystream " + hashMap.get("Count"), (String)hashMap.get("MD"), byArray3);
                continue;
            }
            hashMap.put(string2.substring(0, n).trim(), string2.substring(n + 1).trim());
        }
    }

    private static void initEngine(AsconEngine asconEngine, boolean bl) {
        int n = asconEngine.getKeyBytesSize();
        int n2 = asconEngine.getIVBytesSize();
        int n3 = n2 * 8;
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(new byte[n]), n3, new byte[n2], null);
        asconEngine.init(bl, aEADParameters);
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new AsconTest());
    }

    private void mismatch(String string, String string2, byte[] byArray) {
        this.fail("mismatch on " + string, string2, new String(Hex.encode(byArray)));
    }

    public void performTest() throws Exception {
        this.testBufferingEngine_ascon128();
        this.testBufferingEngine_ascon128a();
        this.testBufferingEngine_ascon80();
        this.testExceptionsDigest_AsconHash();
        this.testExceptionsDigest_AsconHashA();
        this.testExceptionsEngine_ascon128();
        this.testExceptionsEngine_ascon128a();
        this.testExceptionsEngine_ascon80pq();
        this.testExceptionsXof_AsconXof();
        this.testExceptionsXof_AsconXofA();
        this.testParametersDigest_AsconHash();
        this.testParametersDigest_AsconHashA();
        this.testParametersEngine_ascon128();
        this.testParametersEngine_ascon128a();
        this.testParametersEngine_ascon80pq();
        this.testParametersXof_AsconXof();
        this.testParametersXof_AsconXofA();
        this.testVectorsDigest_AsconHash();
        this.testVectorsDigest_AsconHashA();
        this.testVectorsEngine_ascon128();
        this.testVectorsEngine_ascon128a();
        this.testVectorsEngine_ascon80pq();
        this.testVectorsXof_AsconXof();
        this.testVectorsXof_AsconXofA();
    }

    public void testBufferingEngine_ascon128() throws Exception {
        this.implTestBufferingEngine(AsconEngine.AsconParameters.ascon128);
    }

    public void testBufferingEngine_ascon128a() throws Exception {
        this.implTestBufferingEngine(AsconEngine.AsconParameters.ascon128a);
    }

    public void testBufferingEngine_ascon80() throws Exception {
        this.implTestBufferingEngine(AsconEngine.AsconParameters.ascon80pq);
    }

    public void testExceptionsDigest_AsconHash() throws Exception {
        this.implTestExceptionsDigest(AsconDigest.AsconParameters.AsconHash);
    }

    public void testExceptionsDigest_AsconHashA() throws Exception {
        this.implTestExceptionsDigest(AsconDigest.AsconParameters.AsconHashA);
    }

    public void testExceptionsEngine_ascon128() throws Exception {
        this.implTestExceptionsEngine(AsconEngine.AsconParameters.ascon128);
    }

    public void testExceptionsEngine_ascon128a() throws Exception {
        this.implTestExceptionsEngine(AsconEngine.AsconParameters.ascon128a);
    }

    public void testExceptionsEngine_ascon80pq() throws Exception {
        this.implTestExceptionsEngine(AsconEngine.AsconParameters.ascon80pq);
    }

    public void testExceptionsXof_AsconXof() throws Exception {
        this.implTestExceptionsXof(AsconXof.AsconParameters.AsconXof);
    }

    public void testExceptionsXof_AsconXofA() throws Exception {
        this.implTestExceptionsXof(AsconXof.AsconParameters.AsconXofA);
    }

    public void testParametersDigest_AsconHash() throws Exception {
        this.implTestParametersDigest(AsconDigest.AsconParameters.AsconHash, 32);
    }

    public void testParametersDigest_AsconHashA() throws Exception {
        this.implTestParametersDigest(AsconDigest.AsconParameters.AsconHashA, 32);
    }

    public void testParametersEngine_ascon128() throws Exception {
        this.implTestParametersEngine(AsconEngine.AsconParameters.ascon128, 16, 16, 16);
    }

    public void testParametersEngine_ascon128a() throws Exception {
        this.implTestParametersEngine(AsconEngine.AsconParameters.ascon128a, 16, 16, 16);
    }

    public void testParametersEngine_ascon80pq() throws Exception {
        this.implTestParametersEngine(AsconEngine.AsconParameters.ascon80pq, 20, 16, 16);
    }

    public void testParametersXof_AsconXof() throws Exception {
        this.implTestParametersXof(AsconXof.AsconParameters.AsconXof, 32);
    }

    public void testParametersXof_AsconXofA() throws Exception {
        this.implTestParametersXof(AsconXof.AsconParameters.AsconXofA, 32);
    }

    public void testVectorsDigest_AsconHash() throws Exception {
        this.implTestVectorsDigest(AsconDigest.AsconParameters.AsconHash, "asconhash");
    }

    public void testVectorsDigest_AsconHashA() throws Exception {
        this.implTestVectorsDigest(AsconDigest.AsconParameters.AsconHashA, "asconhasha");
    }

    public void testVectorsEngine_ascon128() throws Exception {
        this.implTestVectorsEngine(AsconEngine.AsconParameters.ascon128, "128_128");
    }

    public void testVectorsEngine_ascon128a() throws Exception {
        this.implTestVectorsEngine(AsconEngine.AsconParameters.ascon128a, "128_128_a");
    }

    public void testVectorsEngine_ascon80pq() throws Exception {
        this.implTestVectorsEngine(AsconEngine.AsconParameters.ascon80pq, "160_128");
    }

    public void testVectorsXof_AsconXof() throws Exception {
        this.implTestVectorsXof(AsconXof.AsconParameters.AsconXof, "asconxof");
    }

    public void testVectorsXof_AsconXofA() throws Exception {
        this.implTestVectorsXof(AsconXof.AsconParameters.AsconXofA, "asconxofa");
    }
}

