/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESWrapPadEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.test.RNGUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class AESWrapPadTest
extends SimpleTest {
    private final int numOfRandomIterations = 100;

    public String getName() {
        return "AESWrapPad";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new AESWrapPadTest());
    }

    private void performFailTests() {
        byte[] byArray = Hex.decode("5840df6e29b02af1ab493b705bf16ea1ae8338f4dcc176a8");
        AESWrapPadEngine aESWrapPadEngine = new AESWrapPadEngine();
        aESWrapPadEngine.init(false, new KeyParameter(byArray));
        try {
            aESWrapPadEngine.unwrap(new byte[23], 0, 23);
            this.fail("Data which was not a multiple of 8 bytes was accepted");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {}
        try {
            aESWrapPadEngine.unwrap(new byte[0], 0, 0);
            this.fail("Data of zero bytes was accepted");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {}
        try {
            aESWrapPadEngine.unwrap(new byte[8], 0, 8);
            this.fail("Data which was not a multiple of 8 bytes was accepted");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {}
        try {
            aESWrapPadEngine.unwrap(Hex.decode("000000000000000000000000000000000000000000000000"), 0, 24);
            this.fail("Invalid data was accepted");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {}
        try {
            aESWrapPadEngine.unwrap(Hex.decode("000000000000000000000000000000000000000000000002"), 0, 24);
            this.fail("Invalid data was accepted");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {}
    }

    public void performTest() throws Exception {
        byte[] byArray = Hex.decode("5840df6e29b02af1ab493b705bf16ea1ae8338f4dcc176a8");
        byte[] byArray2 = Hex.decode("c37b7e6492584340bed12207808941155068f738");
        byte[] byArray3 = Hex.decode("138bdeaa9b8fa7fc61f97742e72248ee5ae6ae5360d1ae6a5f54f373fa543b6a");
        this.wrapAndUnwrap(byArray, byArray2, byArray3);
        byArray3 = Hex.decode("afbeb0f07dfbf5419200f2ccb50bb24f");
        byArray2 = Hex.decode("466f7250617369");
        this.wrapAndUnwrap(byArray, byArray2, byArray3);
        this.wrapWithIVTest();
        AESWrapPadEngine aESWrapPadEngine = new AESWrapPadEngine();
        byte[] byArray4 = new byte[5 + byArray2.length];
        System.arraycopy(byArray2, 0, byArray4, 5, byArray2.length);
        aESWrapPadEngine.init(true, new KeyParameter(byArray));
        byte[] byArray5 = aESWrapPadEngine.wrap(byArray4, 5, byArray2.length);
        if (!Arrays.areEqual(byArray5, byArray3)) {
            this.fail("failed offset wrap test expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray5)));
        }
        aESWrapPadEngine.init(false, new KeyParameter(byArray));
        byArray5 = new byte[6 + byArray3.length];
        System.arraycopy(byArray3, 0, byArray5, 6, byArray3.length);
        byArray4 = aESWrapPadEngine.unwrap(byArray5, 6, byArray3.length);
        if (!Arrays.areEqual(byArray4, byArray2)) {
            this.fail("failed offset unwrap test expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray4)));
        }
        SecureRandom secureRandom = new SecureRandom();
        int n = 0;
        while (n < 100) {
            boolean bl;
            int n2 = 128;
            boolean bl2 = bl = (secureRandom.nextInt() & 1) != 0;
            if (bl) {
                n2 = 256;
            }
            byArray = new byte[n2 / 8];
            secureRandom.nextBytes(byArray);
            int n3 = RNGUtils.nextInt(secureRandom, 24) + 8;
            byte[] byArray6 = new byte[n3];
            secureRandom.nextBytes(byArray6);
            this.wrapAndUnwrap(byArray, byArray6);
            ++n;
        }
        this.performFailTests();
    }

    private void wrapAndUnwrap(byte[] byArray, byte[] byArray2) throws Exception {
        AESWrapPadEngine aESWrapPadEngine = new AESWrapPadEngine();
        aESWrapPadEngine.init(true, new KeyParameter(byArray));
        byte[] byArray3 = aESWrapPadEngine.wrap(byArray2, 0, byArray2.length);
        aESWrapPadEngine.init(false, new KeyParameter(byArray));
        byte[] byArray4 = aESWrapPadEngine.unwrap(byArray3, 0, byArray3.length);
        if (!this.areEqual(byArray2, byArray4)) {
            this.fail("Unwrapped value does not match original.");
        }
    }

    private void wrapAndUnwrap(byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        AESWrapPadEngine aESWrapPadEngine = new AESWrapPadEngine();
        aESWrapPadEngine.init(true, new KeyParameter(byArray));
        byte[] byArray4 = aESWrapPadEngine.wrap(byArray2, 0, byArray2.length);
        if (!this.areEqual(byArray4, byArray3)) {
            this.fail("Wrapped value does not match expected.");
        }
        aESWrapPadEngine.init(false, new KeyParameter(byArray));
        byte[] byArray5 = aESWrapPadEngine.unwrap(byArray4, 0, byArray4.length);
        if (!this.areEqual(byArray2, byArray5)) {
            this.fail("Unwrapped value does not match original.");
        }
    }

    private void wrapWithIVTest() throws Exception {
        byte[] byArray = Hex.decode("5840df6e29b02af1ab493b705bf16ea1ae8338f4dcc176a8");
        byte[] byArray2 = Hex.decode("c37b7e6492584340bed12207808941155068f738");
        byte[] byArray3 = Hex.decode("5cbdb3fb71351d0e628b85dbcba1a1890d4db26d1335e11d1aabea11124caad0");
        AESWrapPadEngine aESWrapPadEngine = new AESWrapPadEngine();
        aESWrapPadEngine.init(true, new ParametersWithIV(new KeyParameter(byArray), Hex.decode("33333333")));
        byte[] byArray4 = aESWrapPadEngine.wrap(byArray2, 0, byArray2.length);
        if (!this.areEqual(byArray4, byArray3)) {
            this.fail("Wrapped value does not match expected.");
        }
        aESWrapPadEngine.init(false, new ParametersWithIV(new KeyParameter(byArray), Hex.decode("33333333")));
        byte[] byArray5 = aESWrapPadEngine.unwrap(byArray4, 0, byArray4.length);
        if (!this.areEqual(byArray2, byArray5)) {
            this.fail("Unwrapped value does not match original.");
        }
    }
}

