/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.DefaultBufferedBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.CTRModeCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.test.BlockCipherMonteCarloTest;
import org.bouncycastle.crypto.test.BlockCipherVectorTest;
import org.bouncycastle.crypto.test.CipherTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class AESTest
extends CipherTest {
    private static final byte[] tData = Hex.decode("AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114F3F6752AE8D7831138F041560631B1145A01020304050607");
    private static final byte[] outCBC1 = Hex.decode("a444a9a4d46eb30cb7ed34d62873a89f8fdf2bf8a54e1aeadd06fd85c9cb46f021ee7cd4f418fa0bb72e9d07c70d5d20");
    private static final byte[] outCBC2 = Hex.decode("585681354f0e01a86b32f94ebb6a675045d923cf201263c2aaecca2b4de82da0edd74ca5efd654c688f8a58e61955b11");
    private static final byte[] outSIC1 = Hex.decode("82a1744e8ebbd053ca72362d5e570326e0b6fdaf824ab673fbf029042886b23c75129a015852913790f81f94447475a0");
    private static final byte[] outSIC2 = Hex.decode("146cbb581d9e12c3333dd9c736fbb93043c92019f78580da48f81f80b3f551d58ea836fed480fc6912fefa9c5c89cc24");
    private static final byte[] outCFB1 = Hex.decode("82a1744e8ebbd053ca72362d5e5703264b4182de3208c374b8ac4fa36af9c5e5f4f87d1e3b67963d06acf5eb13914c90");
    private static final byte[] outCFB2 = Hex.decode("146cbb581d9e12c3333dd9c736fbb9303c8a3eb5185e2809e9d3c28e25cc2d2b6f5c11ee28d6530f72c412b1438a816a");
    private static final byte[] outOFB1 = Hex.decode("82a1744e8ebbd053ca72362d5e5703261ebf1fdbec05e57b3465b583132f84b43bf95b2c89040ad1677b22d42db69a7a");
    private static final byte[] outOFB2 = Hex.decode("146cbb581d9e12c3333dd9c736fbb9309ea4c2a7696c84959a2dada49f2f1c5905db1f0cec3a31acbc4701e74ab05e1f");
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(0, AESEngine.newInstance(), new KeyParameter(Hex.decode("80000000000000000000000000000000")), "00000000000000000000000000000000", "0EDD33D3C621E546455BD8BA1418BEC8"), new BlockCipherVectorTest(1, AESEngine.newInstance(), new KeyParameter(Hex.decode("00000000000000000000000000000080")), "00000000000000000000000000000000", "172AEAB3D507678ECAF455C12587ADB7"), new BlockCipherMonteCarloTest(2, 10000, AESEngine.newInstance(), new KeyParameter(Hex.decode("00000000000000000000000000000000")), "00000000000000000000000000000000", "C34C052CC0DA8D73451AFE5F03BE297F"), new BlockCipherMonteCarloTest(3, 10000, AESEngine.newInstance(), new KeyParameter(Hex.decode("5F060D3716B345C253F6749ABAC10917")), "355F697E8B868B65B25A04E18D782AFA", "ACC863637868E3E068D2FD6E3508454A"), new BlockCipherVectorTest(4, AESEngine.newInstance(), new KeyParameter(Hex.decode("000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "6CD02513E8D4DC986B4AFE087A60BD0C"), new BlockCipherMonteCarloTest(5, 10000, AESEngine.newInstance(), new KeyParameter(Hex.decode("AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114")), "F3F6752AE8D7831138F041560631B114", "77BA00ED5412DFF27C8ED91F3C376172"), new BlockCipherVectorTest(6, AESEngine.newInstance(), new KeyParameter(Hex.decode("0000000000000000000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "DDC6BF790C15760D8D9AEB6F9A75FD4E"), new BlockCipherMonteCarloTest(7, 10000, AESEngine.newInstance(), new KeyParameter(Hex.decode("28E79E2AFC5F7745FCCABE2F6257C2EF4C4EDFB37324814ED4137C288711A386")), "C737317FE0846F132B23C8C2A672CE22", "E58B82BFBA53C0040DC610C642121168"), new BlockCipherVectorTest(8, AESEngine.newInstance(), new KeyParameter(Hex.decode("80000000000000000000000000000000")), "00000000000000000000000000000000", "0EDD33D3C621E546455BD8BA1418BEC8"), new BlockCipherVectorTest(9, AESEngine.newInstance(), new KeyParameter(Hex.decode("00000000000000000000000000000080")), "00000000000000000000000000000000", "172AEAB3D507678ECAF455C12587ADB7"), new BlockCipherMonteCarloTest(10, 10000, AESEngine.newInstance(), new KeyParameter(Hex.decode("00000000000000000000000000000000")), "00000000000000000000000000000000", "C34C052CC0DA8D73451AFE5F03BE297F"), new BlockCipherMonteCarloTest(11, 10000, AESEngine.newInstance(), new KeyParameter(Hex.decode("5F060D3716B345C253F6749ABAC10917")), "355F697E8B868B65B25A04E18D782AFA", "ACC863637868E3E068D2FD6E3508454A"), new BlockCipherVectorTest(12, AESEngine.newInstance(), new KeyParameter(Hex.decode("000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "6CD02513E8D4DC986B4AFE087A60BD0C"), new BlockCipherMonteCarloTest(13, 10000, AESEngine.newInstance(), new KeyParameter(Hex.decode("AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114")), "F3F6752AE8D7831138F041560631B114", "77BA00ED5412DFF27C8ED91F3C376172"), new BlockCipherVectorTest(14, AESEngine.newInstance(), new KeyParameter(Hex.decode("0000000000000000000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "DDC6BF790C15760D8D9AEB6F9A75FD4E"), new BlockCipherMonteCarloTest(15, 10000, AESEngine.newInstance(), new KeyParameter(Hex.decode("28E79E2AFC5F7745FCCABE2F6257C2EF4C4EDFB37324814ED4137C288711A386")), "C737317FE0846F132B23C8C2A672CE22", "E58B82BFBA53C0040DC610C642121168"), new BlockCipherVectorTest(16, AESEngine.newInstance(), new KeyParameter(Hex.decode("80000000000000000000000000000000")), "00000000000000000000000000000000", "0EDD33D3C621E546455BD8BA1418BEC8"), new BlockCipherVectorTest(17, AESEngine.newInstance(), new KeyParameter(Hex.decode("00000000000000000000000000000080")), "00000000000000000000000000000000", "172AEAB3D507678ECAF455C12587ADB7"), new BlockCipherMonteCarloTest(18, 10000, AESEngine.newInstance(), new KeyParameter(Hex.decode("00000000000000000000000000000000")), "00000000000000000000000000000000", "C34C052CC0DA8D73451AFE5F03BE297F"), new BlockCipherMonteCarloTest(19, 10000, AESEngine.newInstance(), new KeyParameter(Hex.decode("5F060D3716B345C253F6749ABAC10917")), "355F697E8B868B65B25A04E18D782AFA", "ACC863637868E3E068D2FD6E3508454A"), new BlockCipherVectorTest(20, AESEngine.newInstance(), new KeyParameter(Hex.decode("000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "6CD02513E8D4DC986B4AFE087A60BD0C"), new BlockCipherMonteCarloTest(21, 10000, AESEngine.newInstance(), new KeyParameter(Hex.decode("AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114")), "F3F6752AE8D7831138F041560631B114", "77BA00ED5412DFF27C8ED91F3C376172"), new BlockCipherVectorTest(22, AESEngine.newInstance(), new KeyParameter(Hex.decode("0000000000000000000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "DDC6BF790C15760D8D9AEB6F9A75FD4E"), new BlockCipherMonteCarloTest(23, 10000, AESEngine.newInstance(), new KeyParameter(Hex.decode("28E79E2AFC5F7745FCCABE2F6257C2EF4C4EDFB37324814ED4137C288711A386")), "C737317FE0846F132B23C8C2A672CE22", "E58B82BFBA53C0040DC610C642121168")};
    private BlockCipher _engine = AESEngine.newInstance();
    static byte[] fileBytes = new byte[0];
    static byte[] iv = new byte[16];

    public AESTest() {
        super(tests, AESEngine.newInstance(), new KeyParameter(new byte[16]));
    }

    private void appendFile(byte[] byArray, SICBlockCipher sICBlockCipher) {
        sICBlockCipher.seekTo(fileBytes.length);
        byte[] byArray2 = new byte[byArray.length];
        sICBlockCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
        byte[] byArray3 = Arrays.copyOf(fileBytes, fileBytes.length + byArray2.length);
        System.arraycopy(byArray2, 0, byArray3, fileBytes.length, byArray2.length);
        fileBytes = byArray3;
    }

    private boolean areEqual(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2;
        while (n3 != byArray2.length) {
            if (byArray[n + n3 - n2] != byArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private void ctrCounterTest() {
        block2: {
            ParametersWithIV parametersWithIV = new ParametersWithIV(new KeyParameter(Hex.decode("5F060D3716B345C253F6749ABAC10917")), Hex.decode("000000000000000000000000000000"));
            CTRModeCipher cTRModeCipher = SICBlockCipher.newInstance(AESEngine.newInstance());
            cTRModeCipher.init(true, parametersWithIV);
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray = new byte[4097];
            byte[] byArray2 = new byte[4096];
            secureRandom.nextBytes(byArray2);
            cTRModeCipher.processBytes(byArray2, 0, byArray2.length, byArray, 0);
            cTRModeCipher.init(true, parametersWithIV);
            byArray2 = new byte[4097];
            cTRModeCipher.init(true, parametersWithIV);
            try {
                cTRModeCipher.processBytes(byArray2, 0, byArray2.length, byArray, 0);
                this.fail("out of range data not caught");
            }
            catch (IllegalStateException illegalStateException) {
                if ("Counter in CTR/SIC mode out of range.".equals(illegalStateException.getMessage())) break block2;
                this.fail("wrong exception");
            }
        }
    }

    private void ctrFragmentedTest() throws InvalidCipherTextException {
        CTRModeCipher cTRModeCipher = SICBlockCipher.newInstance(AESEngine.newInstance());
        KeyParameter keyParameter = new KeyParameter(Hex.decode("5F060D3716B345C253F6749ABAC10917"));
        byte[] byArray = new byte[tData.length];
        int n = 1;
        while (n < 16) {
            int n2;
            byte[] byArray2 = new byte[n];
            cTRModeCipher.init(true, new ParametersWithIV(keyParameter, new byte[16]));
            int n3 = 0;
            int n4 = 0;
            do {
                n2 = Math.min(n, tData.length - n3);
                System.arraycopy(tData, n3, byArray2, 0, n2);
                n4 += cTRModeCipher.processBytes(byArray2, 0, n2, byArray, n4);
            } while ((n3 += n2) < tData.length);
            if (!this.areEqual(outSIC1, byArray)) {
                this.fail("no match for fragmented check: " + n);
            }
            ++n;
        }
    }

    public String getName() {
        return "AES";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new AESTest());
    }

    private static SICBlockCipher newCipher() {
        SICBlockCipher sICBlockCipher = new SICBlockCipher(new AESEngine());
        byte[] byArray = "1234567890123456".getBytes();
        ParametersWithIV parametersWithIV = new ParametersWithIV(new KeyParameter(byArray), iv);
        sICBlockCipher.init(true, parametersWithIV);
        return sICBlockCipher;
    }

    public void performTest() throws Exception {
        byte[] byArray;
        super.performTest();
        byte[] byArray2 = new byte[16];
        this._engine.init(true, new KeyParameter(byArray2));
        try {
            byArray = new byte[6];
            this._engine.init(true, new KeyParameter(byArray));
            this.fail("failed key length check");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            byArray = new byte[16];
            this._engine.init(true, new ParametersWithIV(null, byArray));
            this.fail("failed parameter check");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.testNullCBC();
        this.testNullSIC();
        this.testNullOFB();
        this.testNullCFB();
        this.skipTest();
        this.ctrCounterTest();
        this.ctrFragmentedTest();
        this.testLastByte();
        this.testCounter();
    }

    private void skipTest() {
        long l;
        ParametersWithIV parametersWithIV = new ParametersWithIV(new KeyParameter(Hex.decode("5F060D3716B345C253F6749ABAC10917")), Hex.decode("00000000000000000000000000000000"));
        CTRModeCipher cTRModeCipher = SICBlockCipher.newInstance(AESEngine.newInstance());
        cTRModeCipher.init(true, parametersWithIV);
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[50000];
        byte[] byArray2 = new byte[50000];
        secureRandom.nextBytes(byArray);
        cTRModeCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
        byte[] byArray3 = new byte[20];
        cTRModeCipher.init(true, parametersWithIV);
        cTRModeCipher.skip(10L);
        if (cTRModeCipher.getPosition() != 10L) {
            this.fail("skip position incorrect - 10 got " + cTRModeCipher.getPosition());
        }
        cTRModeCipher.processBytes(byArray, 10, byArray3.length, byArray3, 0);
        if (!this.areEqual(byArray2, 10, byArray3, 0)) {
            this.fail("skip forward 10 failed");
        }
        cTRModeCipher.skip(1000L);
        if (cTRModeCipher.getPosition() != (long)(1010 + byArray3.length)) {
            this.fail("skip position incorrect - " + (1010 + byArray3.length) + " got " + cTRModeCipher.getPosition());
        }
        cTRModeCipher.processBytes(byArray, 1010 + byArray3.length, byArray3.length, byArray3, 0);
        if (!this.areEqual(byArray2, 1010 + byArray3.length, byArray3, 0)) {
            this.fail("skip forward 1000 failed");
        }
        cTRModeCipher.skip(-10L);
        if (cTRModeCipher.getPosition() != (long)(1010 + 2 * byArray3.length - 10)) {
            this.fail("skip position incorrect - " + (1010 + 2 * byArray3.length - 10) + " got " + cTRModeCipher.getPosition());
        }
        cTRModeCipher.processBytes(byArray, 1010 + 2 * byArray3.length - 10, byArray3.length, byArray3, 0);
        if (!this.areEqual(byArray2, 1010 + 2 * byArray3.length - 10, byArray3, 0)) {
            this.fail("skip back 10 failed");
        }
        cTRModeCipher.skip(-1000L);
        if (cTRModeCipher.getPosition() != 60L) {
            this.fail("skip position incorrect - 60 got " + cTRModeCipher.getPosition());
        }
        cTRModeCipher.processBytes(byArray, 60, byArray3.length, byArray3, 0);
        if (!this.areEqual(byArray2, 60, byArray3, 0)) {
            this.fail("skip back 1000 failed");
        }
        if ((l = cTRModeCipher.seekTo(1010L)) != 1010L) {
            this.fail("position incorrect - 1010 got " + l);
        }
        cTRModeCipher.processBytes(byArray, 1010, byArray3.length, byArray3, 0);
        if (!this.areEqual(byArray2, 1010, byArray3, 0)) {
            this.fail("seek to 1010 failed");
        }
        cTRModeCipher.reset();
        int n = 0;
        while (n != 5000) {
            cTRModeCipher.skip(n);
            if (cTRModeCipher.getPosition() != (long)n) {
                this.fail("skip forward at wrong position");
            }
            cTRModeCipher.processBytes(byArray, n, byArray3.length, byArray3, 0);
            if (!this.areEqual(byArray2, n, byArray3, 0)) {
                this.fail("skip forward i failed: " + n);
            }
            if (cTRModeCipher.getPosition() != (long)(n + byArray3.length)) {
                this.fail("cipher at wrong position: " + cTRModeCipher.getPosition() + " [" + n + "]");
            }
            cTRModeCipher.skip(-byArray3.length);
            if (cTRModeCipher.getPosition() != (long)n) {
                this.fail("skip back at wrong position");
            }
            cTRModeCipher.processBytes(byArray, n, byArray3.length, byArray3, 0);
            if (!this.areEqual(byArray2, n, byArray3, 0)) {
                this.fail("skip back i failed: " + n);
            }
            cTRModeCipher.reset();
            ++n;
        }
    }

    private void testCounter() {
        Random random = new Random();
        int n = 0;
        while (n < 255) {
            int n2 = iv.length - 1;
            iv[n2] = (byte)(iv[n2] + (byte)n);
            String string = " 1234567890jl\u00e5\u00ad\u0097\u00e7\u00ac\u0160\u00e4\u017e\u00b2";
            int n3 = 1000;
            while (n3 > 0) {
                string = String.valueOf(string) + (char)(97 + random.nextInt(26));
                this.verify(string);
                fileBytes = new byte[0];
                --n3;
            }
            ++n;
        }
    }

    private void testLastByte() throws Exception {
        CTRModeCipher cTRModeCipher = SICBlockCipher.newInstance(AESEngine.newInstance());
        byte[] byArray = new byte[15];
        byte[] byArray2 = new byte[16];
        Arrays.fill(byArray, (byte)10);
        cTRModeCipher.init(true, new ParametersWithIV(new KeyParameter(byArray2), byArray));
        int n = 255;
        cTRModeCipher.seekTo(n * 16);
        int n2 = 0;
        while (n2 < 15) {
            cTRModeCipher.returnByte((byte)0);
            ++n2;
        }
        cTRModeCipher.returnByte((byte)0);
        try {
            cTRModeCipher.returnByte((byte)0);
            this.fail("should not succed");
        }
        catch (Exception exception) {
            this.isEquals(exception.getMessage(), "Counter in CTR/SIC mode out of range.");
        }
    }

    private void testNullCBC() throws InvalidCipherTextException {
        DefaultBufferedBlockCipher defaultBufferedBlockCipher = new DefaultBufferedBlockCipher(new CBCBlockCipher(AESEngine.newInstance()));
        KeyParameter keyParameter = new KeyParameter(Hex.decode("5F060D3716B345C253F6749ABAC10917"));
        ((BufferedBlockCipher)defaultBufferedBlockCipher).init(true, new ParametersWithIV(keyParameter, new byte[16]));
        byte[] byArray = new byte[((BufferedBlockCipher)defaultBufferedBlockCipher).getOutputSize(tData.length)];
        int n = ((BufferedBlockCipher)defaultBufferedBlockCipher).processBytes(tData, 0, tData.length, byArray, 0);
        n += ((BufferedBlockCipher)defaultBufferedBlockCipher).doFinal(byArray, n);
        if (!this.areEqual(outCBC1, byArray)) {
            this.fail("no match on first nullCBC check");
        }
        ((BufferedBlockCipher)defaultBufferedBlockCipher).init(true, new ParametersWithIV(null, Hex.decode("000102030405060708090a0b0c0d0e0f")));
        n = ((BufferedBlockCipher)defaultBufferedBlockCipher).processBytes(tData, 0, tData.length, byArray, 0);
        n += ((BufferedBlockCipher)defaultBufferedBlockCipher).doFinal(byArray, n);
        if (!this.areEqual(outCBC2, byArray)) {
            this.fail("no match on second nullCBC check");
        }
    }

    private void testNullCFB() throws InvalidCipherTextException {
        DefaultBufferedBlockCipher defaultBufferedBlockCipher = new DefaultBufferedBlockCipher(new CFBBlockCipher(AESEngine.newInstance(), 128));
        KeyParameter keyParameter = new KeyParameter(Hex.decode("5F060D3716B345C253F6749ABAC10917"));
        ((BufferedBlockCipher)defaultBufferedBlockCipher).init(true, new ParametersWithIV(keyParameter, new byte[16]));
        byte[] byArray = new byte[((BufferedBlockCipher)defaultBufferedBlockCipher).getOutputSize(tData.length)];
        int n = ((BufferedBlockCipher)defaultBufferedBlockCipher).processBytes(tData, 0, tData.length, byArray, 0);
        n += ((BufferedBlockCipher)defaultBufferedBlockCipher).doFinal(byArray, n);
        if (!this.areEqual(outCFB1, byArray)) {
            this.fail("no match on first nullCFB check");
        }
        ((BufferedBlockCipher)defaultBufferedBlockCipher).init(true, new ParametersWithIV(null, Hex.decode("000102030405060708090a0b0c0d0e0f")));
        n = ((BufferedBlockCipher)defaultBufferedBlockCipher).processBytes(tData, 0, tData.length, byArray, 0);
        n += ((BufferedBlockCipher)defaultBufferedBlockCipher).doFinal(byArray, n);
        if (!this.areEqual(outCFB2, byArray)) {
            this.fail("no match on second nullCFB check");
        }
    }

    private void testNullOFB() throws InvalidCipherTextException {
        DefaultBufferedBlockCipher defaultBufferedBlockCipher = new DefaultBufferedBlockCipher(new OFBBlockCipher(AESEngine.newInstance(), 128));
        KeyParameter keyParameter = new KeyParameter(Hex.decode("5F060D3716B345C253F6749ABAC10917"));
        ((BufferedBlockCipher)defaultBufferedBlockCipher).init(true, new ParametersWithIV(keyParameter, new byte[16]));
        byte[] byArray = new byte[((BufferedBlockCipher)defaultBufferedBlockCipher).getOutputSize(tData.length)];
        int n = ((BufferedBlockCipher)defaultBufferedBlockCipher).processBytes(tData, 0, tData.length, byArray, 0);
        n += ((BufferedBlockCipher)defaultBufferedBlockCipher).doFinal(byArray, n);
        if (!this.areEqual(outOFB1, byArray)) {
            this.fail("no match on first nullOFB check");
        }
        ((BufferedBlockCipher)defaultBufferedBlockCipher).init(true, new ParametersWithIV(null, Hex.decode("000102030405060708090a0b0c0d0e0f")));
        n = ((BufferedBlockCipher)defaultBufferedBlockCipher).processBytes(tData, 0, tData.length, byArray, 0);
        n += ((BufferedBlockCipher)defaultBufferedBlockCipher).doFinal(byArray, n);
        if (!this.areEqual(outOFB2, byArray)) {
            this.fail("no match on second nullOFB check");
        }
    }

    private void testNullSIC() throws InvalidCipherTextException {
        DefaultBufferedBlockCipher defaultBufferedBlockCipher = new DefaultBufferedBlockCipher(SICBlockCipher.newInstance(AESEngine.newInstance()));
        KeyParameter keyParameter = new KeyParameter(Hex.decode("5F060D3716B345C253F6749ABAC10917"));
        ((BufferedBlockCipher)defaultBufferedBlockCipher).init(true, new ParametersWithIV(keyParameter, new byte[16]));
        byte[] byArray = new byte[((BufferedBlockCipher)defaultBufferedBlockCipher).getOutputSize(tData.length)];
        int n = ((BufferedBlockCipher)defaultBufferedBlockCipher).processBytes(tData, 0, tData.length, byArray, 0);
        n += ((BufferedBlockCipher)defaultBufferedBlockCipher).doFinal(byArray, n);
        if (!this.areEqual(outSIC1, byArray)) {
            this.fail("no match on first nullSIC check");
        }
        ((BufferedBlockCipher)defaultBufferedBlockCipher).init(true, new ParametersWithIV(null, Hex.decode("000102030405060708090a0b0c0d0e0f")));
        n = ((BufferedBlockCipher)defaultBufferedBlockCipher).processBytes(tData, 0, tData.length, byArray, 0);
        n += ((BufferedBlockCipher)defaultBufferedBlockCipher).doFinal(byArray, n);
        if (!this.areEqual(outSIC2, byArray)) {
            this.fail("no match on second nullSIC check");
        }
    }

    private void verify(String string) {
        SICBlockCipher sICBlockCipher = AESTest.newCipher();
        byte[] byArray = Strings.toUTF8ByteArray(string);
        this.appendFile(byArray, sICBlockCipher);
        this.appendFile(byArray, sICBlockCipher);
        this.appendFile(byArray, sICBlockCipher);
        byte[] byArray2 = new byte[fileBytes.length];
        AESTest.newCipher().processBytes(fileBytes, 0, fileBytes.length, byArray2, 0);
        String string2 = Strings.fromUTF8ByteArray(byArray2);
        if (!string2.equals(String.valueOf(string) + string + string)) {
            throw new RuntimeException("fail");
        }
    }
}

