/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestFailedException;

public class AEADTestUtil {
    private static void checkReset(Test test, AEADCipher aEADCipher, CipherParameters cipherParameters, boolean bl, byte[] byArray, byte[] byArray2) throws InvalidCipherTextException {
        byte[] byArray3 = new byte[byArray2.length];
        AEADTestUtil.crypt(aEADCipher, byArray, byArray3);
        AEADTestUtil.crypt(aEADCipher, byArray, byArray3);
        if (!Arrays.areEqual(byArray3, byArray2)) {
            AEADTestUtil.fail(test, String.valueOf(bl ? "Encrypt" : "Decrypt") + " did not reset cipher.");
        }
        aEADCipher.processBytes(byArray, 0, 100, byArray3, 0);
        aEADCipher.init(bl, cipherParameters);
        try {
            AEADTestUtil.crypt(aEADCipher, byArray, byArray3);
        }
        catch (DataLengthException dataLengthException) {
            AEADTestUtil.fail(test, "Init did not reset data.");
        }
        if (!Arrays.areEqual(byArray3, byArray2)) {
            AEADTestUtil.fail(test, "Init did not reset data.", new String(Hex.encode(byArray2)), new String(Hex.encode(byArray3)));
        }
        aEADCipher.processAADBytes(byArray, 0, 100);
        aEADCipher.init(bl, cipherParameters);
        try {
            AEADTestUtil.crypt(aEADCipher, byArray, byArray3);
        }
        catch (DataLengthException dataLengthException) {
            AEADTestUtil.fail(test, "Init did not reset additional data.");
        }
        if (!Arrays.areEqual(byArray3, byArray2)) {
            AEADTestUtil.fail(test, "Init did not reset additional data.");
        }
        aEADCipher.processBytes(byArray, 0, 100, byArray3, 0);
        aEADCipher.reset();
        try {
            AEADTestUtil.crypt(aEADCipher, byArray, byArray3);
        }
        catch (DataLengthException dataLengthException) {
            AEADTestUtil.fail(test, "Init did not reset data.");
        }
        if (!Arrays.areEqual(byArray3, byArray2)) {
            AEADTestUtil.fail(test, "Reset did not reset data.");
        }
        aEADCipher.processAADBytes(byArray, 0, 100);
        aEADCipher.reset();
        try {
            AEADTestUtil.crypt(aEADCipher, byArray, byArray3);
        }
        catch (DataLengthException dataLengthException) {
            AEADTestUtil.fail(test, "Init did not reset data.");
        }
        if (!Arrays.areEqual(byArray3, byArray2)) {
            AEADTestUtil.fail(test, "Reset did not reset additional data.");
        }
    }

    private static void crypt(AEADCipher aEADCipher, byte[] byArray, byte[] byArray2) throws InvalidCipherTextException {
        int n = aEADCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
        aEADCipher.doFinal(byArray2, n);
    }

    private static void fail(Test test, String string) {
        throw new TestFailedException(SimpleTestResult.failed(test, string));
    }

    private static void fail(Test test, String string, String string2, String string3) {
        throw new TestFailedException(SimpleTestResult.failed(test, string, string2, string3));
    }

    static AEADParameters reuseKey(AEADParameters aEADParameters) {
        return new AEADParameters(null, aEADParameters.getMacSize(), aEADParameters.getNonce(), aEADParameters.getAssociatedText());
    }

    public static void testBufferSizeChecks(Test test, AEADBlockCipher aEADBlockCipher, AEADParameters aEADParameters) throws IllegalStateException, InvalidCipherTextException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = aEADBlockCipher.getUnderlyingCipher().getBlockSize();
        int n6 = n5 * 10;
        byte[] byArray = new byte[n6];
        aEADBlockCipher.init(true, aEADParameters);
        int n7 = aEADBlockCipher.getUpdateOutputSize(byArray.length);
        byte[] byArray2 = new byte[aEADBlockCipher.getOutputSize(byArray.length)];
        try {
            aEADBlockCipher.processBytes(new byte[n6 - 1], 0, n6, new byte[n7], 0);
            AEADTestUtil.fail(test, "processBytes should validate input buffer length");
        }
        catch (DataLengthException dataLengthException) {}
        aEADBlockCipher.reset();
        if (n7 > 0) {
            n4 = 0;
            n3 = 0;
            while (n3 < byArray.length) {
                if (aEADBlockCipher.getUpdateOutputSize(1) != 0) {
                    n4 = n3 + 1;
                    break;
                }
                aEADBlockCipher.processByte(byArray[n3], byArray2, 0);
                ++n3;
            }
            if (n4 == 0) {
                AEADTestUtil.fail(test, "Failed to find output trigger size");
            }
            try {
                aEADBlockCipher.processByte(byArray[0], new byte[aEADBlockCipher.getUpdateOutputSize(1) - 1], 0);
                AEADTestUtil.fail(test, "Encrypt processByte should validate output buffer length");
            }
            catch (OutputLengthException outputLengthException) {}
            aEADBlockCipher.reset();
            try {
                aEADBlockCipher.processBytes(byArray, 0, n4, new byte[aEADBlockCipher.getUpdateOutputSize(n4) - 1], 0);
                AEADTestUtil.fail(test, "Encrypt processBytes should validate output buffer length");
            }
            catch (OutputLengthException outputLengthException) {}
            aEADBlockCipher.reset();
        }
        n4 = aEADBlockCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
        n4 += aEADBlockCipher.doFinal(byArray2, n4);
        n3 = aEADBlockCipher.getMac().length;
        aEADBlockCipher.reset();
        try {
            aEADBlockCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
            aEADBlockCipher.doFinal(new byte[aEADBlockCipher.getOutputSize(0) - 1], 0);
            AEADTestUtil.fail(test, "Encrypt doFinal should validate output buffer length");
        }
        catch (OutputLengthException outputLengthException) {}
        aEADBlockCipher.init(false, aEADParameters);
        n7 = aEADBlockCipher.getUpdateOutputSize(n4);
        if (n7 > 0) {
            n2 = 0;
            n = 0;
            while (n < byArray.length) {
                if (aEADBlockCipher.getUpdateOutputSize(1) != 0) {
                    n2 = n + 1;
                    break;
                }
                aEADBlockCipher.processByte(byArray2[n], byArray, 0);
                ++n;
            }
            if (n2 == 0) {
                AEADTestUtil.fail(test, "Failed to find output trigger size");
            }
            try {
                aEADBlockCipher.processByte(byArray2[0], new byte[aEADBlockCipher.getUpdateOutputSize(1) - 1], 0);
                AEADTestUtil.fail(test, "Decrypt processByte should validate output buffer length");
            }
            catch (OutputLengthException outputLengthException) {}
            aEADBlockCipher.reset();
            try {
                aEADBlockCipher.processBytes(byArray2, 0, n2, new byte[aEADBlockCipher.getUpdateOutputSize(n2) - 1], 0);
                AEADTestUtil.fail(test, "Decrypt processBytes should validate output buffer length");
            }
            catch (OutputLengthException outputLengthException) {}
        }
        aEADBlockCipher.reset();
        try {
            if (aEADBlockCipher.processBytes(byArray2, 0, n3 - 1, byArray, 0) != 0) {
                AEADTestUtil.fail(test, "AE cipher unexpectedly produced output");
            }
            aEADBlockCipher.doFinal(new byte[0], 0);
            AEADTestUtil.fail(test, "Decrypt doFinal should check ciphertext length");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {}
        try {
            n2 = 2;
            while (n2 < byArray.length) {
                aEADBlockCipher.init(true, aEADParameters);
                n = aEADBlockCipher.processBytes(byArray, 0, n2, byArray2, 0);
                n += aEADBlockCipher.doFinal(byArray2, n);
                aEADBlockCipher.init(false, aEADParameters);
                aEADBlockCipher.processBytes(byArray2, 0, n - 1, byArray, 0);
                if (aEADBlockCipher.processByte(byArray2[n - 1], byArray, 0) == 0) {
                    aEADBlockCipher.doFinal(new byte[aEADBlockCipher.getOutputSize(0) - 1], 0);
                    AEADTestUtil.fail(test, "Decrypt doFinal should check output length");
                    aEADBlockCipher.reset();
                    try {
                        aEADBlockCipher.processBytes(byArray2, 0, n4 - 1, byArray, 0);
                        aEADBlockCipher.doFinal(new byte[aEADBlockCipher.getOutputSize(0) - 1], 0);
                        AEADTestUtil.fail(test, "Decrypt doFinal should check ciphertext length");
                    }
                    catch (InvalidCipherTextException invalidCipherTextException) {}
                    aEADBlockCipher.reset();
                }
                ++n2;
            }
            AEADTestUtil.fail(test, "Decrypt doFinal test couldn't find a ciphertext length that buffered for doFinal");
        }
        catch (OutputLengthException outputLengthException) {}
    }

    public static void testOutputSizes(Test test, AEADBlockCipher aEADBlockCipher, AEADParameters aEADParameters) throws IllegalStateException, InvalidCipherTextException {
        int n = aEADBlockCipher.getUnderlyingCipher().getBlockSize() * 10;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n * 2];
        aEADBlockCipher.init(true, aEADParameters);
        aEADBlockCipher.doFinal(byArray2, 0);
        int n2 = aEADBlockCipher.getMac().length;
        aEADBlockCipher.init(false, aEADParameters);
        int n3 = 0;
        while (n3 < n2) {
            aEADBlockCipher.reset();
            if (aEADBlockCipher.getUpdateOutputSize(n3) != 0) {
                AEADTestUtil.fail(test, "AE cipher should not produce update output with ciphertext length <= macSize");
            }
            if (aEADBlockCipher.getOutputSize(n3) != 0) {
                AEADTestUtil.fail(test, "AE cipher should not produce output with ciphertext length <= macSize");
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < byArray.length) {
            int n5;
            int n6;
            aEADBlockCipher.init(true, aEADParameters);
            int n7 = aEADBlockCipher.getUpdateOutputSize(n4);
            int n8 = aEADBlockCipher.getOutputSize(n4);
            if (n7 < 0) {
                AEADTestUtil.fail(test, "Encryption update output size should not be < 0 for size " + n4);
            }
            if (n8 < 0) {
                AEADTestUtil.fail(test, "Encryption update output size should not be < 0 for size " + n4);
            }
            if (n7 != (n6 = aEADBlockCipher.processBytes(byArray, 0, n4, byArray2, 0))) {
                AEADTestUtil.fail(test, "Encryption update output size did not match calculated for plaintext length " + n4, String.valueOf(n7), String.valueOf(n6));
            }
            if (n8 != (n6 += aEADBlockCipher.doFinal(byArray2, n6))) {
                AEADTestUtil.fail(test, "Encryption actual final output size did not match calculated for plaintext length " + n4, String.valueOf(n8), String.valueOf(n6));
            }
            aEADBlockCipher.init(false, aEADParameters);
            int n9 = aEADBlockCipher.getUpdateOutputSize(n6);
            int n10 = aEADBlockCipher.getOutputSize(n6);
            if (n10 != n4) {
                AEADTestUtil.fail(test, "Decryption update output size did not original plaintext length " + n4, String.valueOf(n9), String.valueOf(n4));
            }
            if (n9 != (n5 = aEADBlockCipher.processBytes(byArray2, 0, n6, byArray, 0))) {
                AEADTestUtil.fail(test, "Decryption update output size did not match calculated for plaintext length " + n4, String.valueOf(n9), String.valueOf(n5));
            }
            if (n10 != (n5 += aEADBlockCipher.doFinal(byArray, n5))) {
                AEADTestUtil.fail(test, "Decryption update output size did not match calculated for plaintext length " + n4, String.valueOf(n10), String.valueOf(n5));
            }
            ++n4;
        }
    }

    public static void testReset(Test test, AEADCipher aEADCipher, AEADBlockCipher aEADBlockCipher, CipherParameters cipherParameters) throws InvalidCipherTextException {
        aEADCipher.init(true, cipherParameters);
        byte[] byArray = new byte[1000];
        byte[] byArray2 = new byte[aEADCipher.getOutputSize(byArray.length)];
        AEADTestUtil.crypt(aEADCipher, byArray, byArray2);
        AEADTestUtil.checkReset(test, aEADCipher, cipherParameters, true, byArray, byArray2);
        aEADBlockCipher.init(false, cipherParameters);
        AEADTestUtil.checkReset(test, aEADBlockCipher, cipherParameters, false, byArray2, byArray);
    }

    public static void testTampering(Test test, AEADCipher aEADCipher, CipherParameters cipherParameters) throws InvalidCipherTextException {
        byte[] byArray = new byte[1000];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)n;
            ++n;
        }
        aEADCipher.init(true, cipherParameters);
        byte[] byArray2 = new byte[aEADCipher.getOutputSize(byArray.length)];
        int n2 = aEADCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
        aEADCipher.doFinal(byArray2, n2);
        int n3 = aEADCipher.getMac().length;
        aEADCipher.init(false, cipherParameters);
        byte[] byArray3 = new byte[byArray2.length];
        byte[] byArray4 = new byte[byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        byArray3[0] = (byte)(byArray3[0] + 1);
        aEADCipher.processBytes(byArray3, 0, byArray3.length, byArray4, 0);
        try {
            aEADCipher.doFinal(byArray4, 0);
            throw new TestFailedException(new SimpleTestResult(false, String.valueOf(String.valueOf(test)) + " : tampering of ciphertext not detected."));
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            aEADCipher.init(false, cipherParameters);
            byte[] byArray5 = new byte[n3 - 1];
            System.arraycopy(byArray2, 0, byArray5, 0, byArray5.length);
            aEADCipher.processBytes(byArray5, 0, byArray5.length, byArray4, 0);
            try {
                aEADCipher.doFinal(byArray4, 0);
                AEADTestUtil.fail(test, "tampering of ciphertext not detected.");
            }
            catch (InvalidCipherTextException invalidCipherTextException2) {}
            return;
        }
    }
}

