/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.prng;

import java.security.SecureRandom;
import org.bouncycastle.crypto.prng.EntropySource;
import org.bouncycastle.crypto.prng.EntropySourceProvider;
import org.bouncycastle.crypto.prng.SP800SecureRandom;
import org.bouncycastle.crypto.prng.X931SecureRandom;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom secureRandom, boolean bl) {
        this._sr = secureRandom;
        this._predictionResistant = bl;
    }

    public EntropySource get(final int n) {
        return new EntropySource(){

            public int entropySize() {
                return n;
            }

            public byte[] getEntropy() {
                if (_sr instanceof SP800SecureRandom || _sr instanceof X931SecureRandom) {
                    byte[] byArray = new byte[(n + 7) / 8];
                    _sr.nextBytes(byArray);
                    return byArray;
                }
                return _sr.generateSeed((n + 7) / 8);
            }

            public boolean isPredictionResistant() {
                return _predictionResistant;
            }
        };
    }
}

