/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.params;

import org.bouncycastle.crypto.params.DESParameters;

public class DESedeParameters
extends DESParameters {
    public static final int DES_EDE_KEY_LENGTH = 24;

    public DESedeParameters(byte[] byArray) {
        super(byArray);
        if (DESedeParameters.isWeakKey(byArray, 0, byArray.length)) {
            throw new IllegalArgumentException("attempt to create weak DESede key");
        }
    }

    public static boolean isReal2Key(byte[] byArray, int n) {
        boolean bl = false;
        int n2 = n;
        while (n2 != n + 8) {
            if (byArray[n2] != byArray[n2 + 8]) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public static boolean isReal3Key(byte[] byArray, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = n;
        while (n2 != n + 8) {
            bl |= byArray[n2] != byArray[n2 + 8];
            bl2 |= byArray[n2] != byArray[n2 + 16];
            bl3 |= byArray[n2 + 8] != byArray[n2 + 16];
            ++n2;
        }
        return bl && bl2 && bl3;
    }

    public static boolean isRealEDEKey(byte[] byArray, int n) {
        return byArray.length == 16 ? DESedeParameters.isReal2Key(byArray, n) : DESedeParameters.isReal3Key(byArray, n);
    }

    public static boolean isWeakKey(byte[] byArray, int n) {
        return DESedeParameters.isWeakKey(byArray, n, byArray.length - n);
    }

    public static boolean isWeakKey(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (DESParameters.isWeakKey(byArray, n3)) {
                return true;
            }
            n3 += 8;
        }
        return false;
    }
}

