/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.StreamBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.ParametersWithSBox;

public class GCFBBlockCipher
extends StreamBlockCipher {
    private static final byte[] C;
    private final CFBBlockCipher cfbEngine;
    private KeyParameter key;
    private long counter = 0L;
    private boolean forEncryption;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 105;
        byArray[2] = 114;
        byArray[3] = 34;
        byArray[4] = 100;
        byArray[5] = -55;
        byArray[6] = 4;
        byArray[7] = 35;
        byArray[8] = -115;
        byArray[9] = 58;
        byArray[10] = -37;
        byArray[11] = -106;
        byArray[12] = 70;
        byArray[13] = -23;
        byArray[14] = 42;
        byArray[15] = -60;
        byArray[16] = 24;
        byArray[17] = -2;
        byArray[18] = -84;
        byArray[19] = -108;
        byArray[21] = -19;
        byArray[22] = 7;
        byArray[23] = 18;
        byArray[24] = -64;
        byArray[25] = -122;
        byArray[26] = -36;
        byArray[27] = -62;
        byArray[28] = -17;
        byArray[29] = 76;
        byArray[30] = -87;
        byArray[31] = 43;
        C = byArray;
    }

    public GCFBBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.cfbEngine = new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8);
    }

    protected byte calculateByte(byte by) {
        if (this.counter > 0L && this.counter % 1024L == 0L) {
            BlockCipher blockCipher = this.cfbEngine.getUnderlyingCipher();
            blockCipher.init(false, this.key);
            byte[] byArray = new byte[32];
            blockCipher.processBlock(C, 0, byArray, 0);
            blockCipher.processBlock(C, 8, byArray, 8);
            blockCipher.processBlock(C, 16, byArray, 16);
            blockCipher.processBlock(C, 24, byArray, 24);
            this.key = new KeyParameter(byArray);
            blockCipher.init(true, this.key);
            byte[] byArray2 = this.cfbEngine.getCurrentIV();
            blockCipher.processBlock(byArray2, 0, byArray2, 0);
            this.cfbEngine.init(this.forEncryption, new ParametersWithIV(this.key, byArray2));
        }
        ++this.counter;
        return this.cfbEngine.calculateByte(by);
    }

    public String getAlgorithmName() {
        String string = this.cfbEngine.getAlgorithmName();
        return String.valueOf(string.substring(0, string.indexOf(47))) + "/G" + string.substring(string.indexOf(47) + 1);
    }

    public int getBlockSize() {
        return this.cfbEngine.getBlockSize();
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.counter = 0L;
        this.cfbEngine.init(bl, cipherParameters);
        this.forEncryption = bl;
        if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters = ((ParametersWithIV)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof ParametersWithSBox) {
            cipherParameters = ((ParametersWithSBox)cipherParameters).getParameters();
        }
        this.key = (KeyParameter)cipherParameters;
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n, this.cfbEngine.getBlockSize(), byArray2, n2);
        return this.cfbEngine.getBlockSize();
    }

    public void reset() {
        this.counter = 0L;
        this.cfbEngine.reset();
    }
}

