/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.macs;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.engines.Zuc128CoreEngine;
import org.bouncycastle.crypto.engines.Zuc256CoreEngine;

public final class Zuc256Mac
implements Mac {
    private static final int TOPBIT = 128;
    private final InternalZuc256Engine theEngine;
    private final int theMacLength;
    private final int[] theMac;
    private final int[] theKeyStream;
    private Zuc256CoreEngine theState;
    private int theWordIndex;
    private int theByteIndex;

    public Zuc256Mac(int n) {
        this.theEngine = new InternalZuc256Engine(n);
        this.theMacLength = n;
        int n2 = n / 32;
        this.theMac = new int[n2];
        this.theKeyStream = new int[n2 + 1];
    }

    public int doFinal(byte[] byArray, int n) {
        this.shift4Final();
        this.updateMac(this.theByteIndex * 8);
        int n2 = 0;
        while (n2 < this.theMac.length) {
            Zuc128CoreEngine.encode32be(this.theMac[n2], byArray, n + n2 * 4);
            ++n2;
        }
        this.reset();
        return this.getMacSize();
    }

    public String getAlgorithmName() {
        return "Zuc256Mac-" + this.theMacLength;
    }

    private int getKeyStreamWord(int n, int n2) {
        int n3 = this.theKeyStream[(this.theWordIndex + n) % this.theKeyStream.length];
        if (n2 == 0) {
            return n3;
        }
        int n4 = this.theKeyStream[(this.theWordIndex + n + 1) % this.theKeyStream.length];
        return n3 << n2 | n4 >>> 32 - n2;
    }

    public int getMacSize() {
        return this.theMacLength / 8;
    }

    public void init(CipherParameters cipherParameters) {
        this.theEngine.init(true, cipherParameters);
        this.theState = (Zuc256CoreEngine)this.theEngine.copy();
        this.initKeyStream();
    }

    private void initKeyStream() {
        int n = 0;
        while (n < this.theMac.length) {
            this.theMac[n] = this.theEngine.createKeyStreamWord();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.theKeyStream.length - 1) {
            this.theKeyStream[n2] = this.theEngine.createKeyStreamWord();
            ++n2;
        }
        this.theWordIndex = this.theKeyStream.length - 1;
        this.theByteIndex = 3;
    }

    public void reset() {
        if (this.theState != null) {
            this.theEngine.reset(this.theState);
        }
        this.initKeyStream();
    }

    private void shift4Final() {
        this.theByteIndex = (this.theByteIndex + 1) % 4;
        if (this.theByteIndex == 0) {
            this.theWordIndex = (this.theWordIndex + 1) % this.theKeyStream.length;
        }
    }

    private void shift4NextByte() {
        this.theByteIndex = (this.theByteIndex + 1) % 4;
        if (this.theByteIndex == 0) {
            this.theKeyStream[this.theWordIndex] = this.theEngine.createKeyStreamWord();
            this.theWordIndex = (this.theWordIndex + 1) % this.theKeyStream.length;
        }
    }

    public void update(byte by) {
        this.shift4NextByte();
        int n = this.theByteIndex * 8;
        int n2 = 128;
        int n3 = 0;
        while (n2 > 0) {
            if ((by & n2) != 0) {
                this.updateMac(n + n3);
            }
            n2 >>= 1;
            ++n3;
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.update(byArray[n + n3]);
            ++n3;
        }
    }

    private void updateMac(int n) {
        int n2 = 0;
        while (n2 < this.theMac.length) {
            int n3 = n2;
            this.theMac[n3] = this.theMac[n3] ^ this.getKeyStreamWord(n2, n);
            ++n2;
        }
    }

    private static class InternalZuc256Engine
    extends Zuc256CoreEngine {
        public InternalZuc256Engine(int n) {
            super(n);
        }

        int createKeyStreamWord() {
            return super.makeKeyStreamWord();
        }
    }
}

