/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RC2Parameters;

public class RC2Engine
implements BlockCipher {
    private static byte[] piTable;
    private static final int BLOCK_SIZE = 8;
    private int[] workingKey;
    private boolean encrypting;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = -39;
        byArray[1] = 120;
        byArray[2] = -7;
        byArray[3] = -60;
        byArray[4] = 25;
        byArray[5] = -35;
        byArray[6] = -75;
        byArray[7] = -19;
        byArray[8] = 40;
        byArray[9] = -23;
        byArray[10] = -3;
        byArray[11] = 121;
        byArray[12] = 74;
        byArray[13] = -96;
        byArray[14] = -40;
        byArray[15] = -99;
        byArray[16] = -58;
        byArray[17] = 126;
        byArray[18] = 55;
        byArray[19] = -125;
        byArray[20] = 43;
        byArray[21] = 118;
        byArray[22] = 83;
        byArray[23] = -114;
        byArray[24] = 98;
        byArray[25] = 76;
        byArray[26] = 100;
        byArray[27] = -120;
        byArray[28] = 68;
        byArray[29] = -117;
        byArray[30] = -5;
        byArray[31] = -94;
        byArray[32] = 23;
        byArray[33] = -102;
        byArray[34] = 89;
        byArray[35] = -11;
        byArray[36] = -121;
        byArray[37] = -77;
        byArray[38] = 79;
        byArray[39] = 19;
        byArray[40] = 97;
        byArray[41] = 69;
        byArray[42] = 109;
        byArray[43] = -115;
        byArray[44] = 9;
        byArray[45] = -127;
        byArray[46] = 125;
        byArray[47] = 50;
        byArray[48] = -67;
        byArray[49] = -113;
        byArray[50] = 64;
        byArray[51] = -21;
        byArray[52] = -122;
        byArray[53] = -73;
        byArray[54] = 123;
        byArray[55] = 11;
        byArray[56] = -16;
        byArray[57] = -107;
        byArray[58] = 33;
        byArray[59] = 34;
        byArray[60] = 92;
        byArray[61] = 107;
        byArray[62] = 78;
        byArray[63] = -126;
        byArray[64] = 84;
        byArray[65] = -42;
        byArray[66] = 101;
        byArray[67] = -109;
        byArray[68] = -50;
        byArray[69] = 96;
        byArray[70] = -78;
        byArray[71] = 28;
        byArray[72] = 115;
        byArray[73] = 86;
        byArray[74] = -64;
        byArray[75] = 20;
        byArray[76] = -89;
        byArray[77] = -116;
        byArray[78] = -15;
        byArray[79] = -36;
        byArray[80] = 18;
        byArray[81] = 117;
        byArray[82] = -54;
        byArray[83] = 31;
        byArray[84] = 59;
        byArray[85] = -66;
        byArray[86] = -28;
        byArray[87] = -47;
        byArray[88] = 66;
        byArray[89] = 61;
        byArray[90] = -44;
        byArray[91] = 48;
        byArray[92] = -93;
        byArray[93] = 60;
        byArray[94] = -74;
        byArray[95] = 38;
        byArray[96] = 111;
        byArray[97] = -65;
        byArray[98] = 14;
        byArray[99] = -38;
        byArray[100] = 70;
        byArray[101] = 105;
        byArray[102] = 7;
        byArray[103] = 87;
        byArray[104] = 39;
        byArray[105] = -14;
        byArray[106] = 29;
        byArray[107] = -101;
        byArray[108] = -68;
        byArray[109] = -108;
        byArray[110] = 67;
        byArray[111] = 3;
        byArray[112] = -8;
        byArray[113] = 17;
        byArray[114] = -57;
        byArray[115] = -10;
        byArray[116] = -112;
        byArray[117] = -17;
        byArray[118] = 62;
        byArray[119] = -25;
        byArray[120] = 6;
        byArray[121] = -61;
        byArray[122] = -43;
        byArray[123] = 47;
        byArray[124] = -56;
        byArray[125] = 102;
        byArray[126] = 30;
        byArray[127] = -41;
        byArray[128] = 8;
        byArray[129] = -24;
        byArray[130] = -22;
        byArray[131] = -34;
        byArray[132] = -128;
        byArray[133] = 82;
        byArray[134] = -18;
        byArray[135] = -9;
        byArray[136] = -124;
        byArray[137] = -86;
        byArray[138] = 114;
        byArray[139] = -84;
        byArray[140] = 53;
        byArray[141] = 77;
        byArray[142] = 106;
        byArray[143] = 42;
        byArray[144] = -106;
        byArray[145] = 26;
        byArray[146] = -46;
        byArray[147] = 113;
        byArray[148] = 90;
        byArray[149] = 21;
        byArray[150] = 73;
        byArray[151] = 116;
        byArray[152] = 75;
        byArray[153] = -97;
        byArray[154] = -48;
        byArray[155] = 94;
        byArray[156] = 4;
        byArray[157] = 24;
        byArray[158] = -92;
        byArray[159] = -20;
        byArray[160] = -62;
        byArray[161] = -32;
        byArray[162] = 65;
        byArray[163] = 110;
        byArray[164] = 15;
        byArray[165] = 81;
        byArray[166] = -53;
        byArray[167] = -52;
        byArray[168] = 36;
        byArray[169] = -111;
        byArray[170] = -81;
        byArray[171] = 80;
        byArray[172] = -95;
        byArray[173] = -12;
        byArray[174] = 112;
        byArray[175] = 57;
        byArray[176] = -103;
        byArray[177] = 124;
        byArray[178] = 58;
        byArray[179] = -123;
        byArray[180] = 35;
        byArray[181] = -72;
        byArray[182] = -76;
        byArray[183] = 122;
        byArray[184] = -4;
        byArray[185] = 2;
        byArray[186] = 54;
        byArray[187] = 91;
        byArray[188] = 37;
        byArray[189] = 85;
        byArray[190] = -105;
        byArray[191] = 49;
        byArray[192] = 45;
        byArray[193] = 93;
        byArray[194] = -6;
        byArray[195] = -104;
        byArray[196] = -29;
        byArray[197] = -118;
        byArray[198] = -110;
        byArray[199] = -82;
        byArray[200] = 5;
        byArray[201] = -33;
        byArray[202] = 41;
        byArray[203] = 16;
        byArray[204] = 103;
        byArray[205] = 108;
        byArray[206] = -70;
        byArray[207] = -55;
        byArray[208] = -45;
        byArray[210] = -26;
        byArray[211] = -49;
        byArray[212] = -31;
        byArray[213] = -98;
        byArray[214] = -88;
        byArray[215] = 44;
        byArray[216] = 99;
        byArray[217] = 22;
        byArray[218] = 1;
        byArray[219] = 63;
        byArray[220] = 88;
        byArray[221] = -30;
        byArray[222] = -119;
        byArray[223] = -87;
        byArray[224] = 13;
        byArray[225] = 56;
        byArray[226] = 52;
        byArray[227] = 27;
        byArray[228] = -85;
        byArray[229] = 51;
        byArray[230] = -1;
        byArray[231] = -80;
        byArray[232] = -69;
        byArray[233] = 72;
        byArray[234] = 12;
        byArray[235] = 95;
        byArray[236] = -71;
        byArray[237] = -79;
        byArray[238] = -51;
        byArray[239] = 46;
        byArray[240] = -59;
        byArray[241] = -13;
        byArray[242] = -37;
        byArray[243] = 71;
        byArray[244] = -27;
        byArray[245] = -91;
        byArray[246] = -100;
        byArray[247] = 119;
        byArray[248] = 10;
        byArray[249] = -90;
        byArray[250] = 32;
        byArray[251] = 104;
        byArray[252] = -2;
        byArray[253] = 127;
        byArray[254] = -63;
        byArray[255] = -83;
        piTable = byArray;
    }

    private void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ((byArray[n + 7] & 0xFF) << 8) + (byArray[n + 6] & 0xFF);
        int n4 = ((byArray[n + 5] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
        int n5 = ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
        int n6 = ((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF);
        int n7 = 60;
        while (n7 >= 44) {
            n3 = this.rotateWordLeft(n3, 11) - ((n6 & ~n4) + (n5 & n4) + this.workingKey[n7 + 3]);
            n4 = this.rotateWordLeft(n4, 13) - ((n3 & ~n5) + (n6 & n5) + this.workingKey[n7 + 2]);
            n5 = this.rotateWordLeft(n5, 14) - ((n4 & ~n6) + (n3 & n6) + this.workingKey[n7 + 1]);
            n6 = this.rotateWordLeft(n6, 15) - ((n5 & ~n3) + (n4 & n3) + this.workingKey[n7]);
            n7 -= 4;
        }
        n3 -= this.workingKey[n4 & 0x3F];
        n4 -= this.workingKey[n5 & 0x3F];
        n5 -= this.workingKey[n6 & 0x3F];
        n6 -= this.workingKey[n3 & 0x3F];
        int n8 = 40;
        while (n8 >= 20) {
            n3 = this.rotateWordLeft(n3, 11) - ((n6 & ~n4) + (n5 & n4) + this.workingKey[n8 + 3]);
            n4 = this.rotateWordLeft(n4, 13) - ((n3 & ~n5) + (n6 & n5) + this.workingKey[n8 + 2]);
            n5 = this.rotateWordLeft(n5, 14) - ((n4 & ~n6) + (n3 & n6) + this.workingKey[n8 + 1]);
            n6 = this.rotateWordLeft(n6, 15) - ((n5 & ~n3) + (n4 & n3) + this.workingKey[n8]);
            n8 -= 4;
        }
        n3 -= this.workingKey[n4 & 0x3F];
        n4 -= this.workingKey[n5 & 0x3F];
        n5 -= this.workingKey[n6 & 0x3F];
        n6 -= this.workingKey[n3 & 0x3F];
        int n9 = 16;
        while (n9 >= 0) {
            n3 = this.rotateWordLeft(n3, 11) - ((n6 & ~n4) + (n5 & n4) + this.workingKey[n9 + 3]);
            n4 = this.rotateWordLeft(n4, 13) - ((n3 & ~n5) + (n6 & n5) + this.workingKey[n9 + 2]);
            n5 = this.rotateWordLeft(n5, 14) - ((n4 & ~n6) + (n3 & n6) + this.workingKey[n9 + 1]);
            n6 = this.rotateWordLeft(n6, 15) - ((n5 & ~n3) + (n4 & n3) + this.workingKey[n9]);
            n9 -= 4;
        }
        byArray2[n2] = (byte)n6;
        byArray2[n2 + 1] = (byte)(n6 >> 8);
        byArray2[n2 + 2] = (byte)n5;
        byArray2[n2 + 3] = (byte)(n5 >> 8);
        byArray2[n2 + 4] = (byte)n4;
        byArray2[n2 + 5] = (byte)(n4 >> 8);
        byArray2[n2 + 6] = (byte)n3;
        byArray2[n2 + 7] = (byte)(n3 >> 8);
    }

    private void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ((byArray[n + 7] & 0xFF) << 8) + (byArray[n + 6] & 0xFF);
        int n4 = ((byArray[n + 5] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
        int n5 = ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
        int n6 = ((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF);
        int n7 = 0;
        while (n7 <= 16) {
            n6 = this.rotateWordLeft(n6 + (n5 & ~n3) + (n4 & n3) + this.workingKey[n7], 1);
            n5 = this.rotateWordLeft(n5 + (n4 & ~n6) + (n3 & n6) + this.workingKey[n7 + 1], 2);
            n4 = this.rotateWordLeft(n4 + (n3 & ~n5) + (n6 & n5) + this.workingKey[n7 + 2], 3);
            n3 = this.rotateWordLeft(n3 + (n6 & ~n4) + (n5 & n4) + this.workingKey[n7 + 3], 5);
            n7 += 4;
        }
        n4 += this.workingKey[(n5 += this.workingKey[(n6 += this.workingKey[n3 & 0x3F]) & 0x3F]) & 0x3F];
        n3 += this.workingKey[n4 & 0x3F];
        int n8 = 20;
        while (n8 <= 40) {
            n6 = this.rotateWordLeft(n6 + (n5 & ~n3) + (n4 & n3) + this.workingKey[n8], 1);
            n5 = this.rotateWordLeft(n5 + (n4 & ~n6) + (n3 & n6) + this.workingKey[n8 + 1], 2);
            n4 = this.rotateWordLeft(n4 + (n3 & ~n5) + (n6 & n5) + this.workingKey[n8 + 2], 3);
            n3 = this.rotateWordLeft(n3 + (n6 & ~n4) + (n5 & n4) + this.workingKey[n8 + 3], 5);
            n8 += 4;
        }
        n4 += this.workingKey[(n5 += this.workingKey[(n6 += this.workingKey[n3 & 0x3F]) & 0x3F]) & 0x3F];
        n3 += this.workingKey[n4 & 0x3F];
        int n9 = 44;
        while (n9 < 64) {
            n6 = this.rotateWordLeft(n6 + (n5 & ~n3) + (n4 & n3) + this.workingKey[n9], 1);
            n5 = this.rotateWordLeft(n5 + (n4 & ~n6) + (n3 & n6) + this.workingKey[n9 + 1], 2);
            n4 = this.rotateWordLeft(n4 + (n3 & ~n5) + (n6 & n5) + this.workingKey[n9 + 2], 3);
            n3 = this.rotateWordLeft(n3 + (n6 & ~n4) + (n5 & n4) + this.workingKey[n9 + 3], 5);
            n9 += 4;
        }
        byArray2[n2] = (byte)n6;
        byArray2[n2 + 1] = (byte)(n6 >> 8);
        byArray2[n2 + 2] = (byte)n5;
        byArray2[n2 + 3] = (byte)(n5 >> 8);
        byArray2[n2 + 4] = (byte)n4;
        byArray2[n2 + 5] = (byte)(n4 >> 8);
        byArray2[n2 + 6] = (byte)n3;
        byArray2[n2 + 7] = (byte)(n3 >> 8);
    }

    private int[] generateWorkingKey(byte[] byArray, int n) {
        int n2;
        int n3;
        int[] nArray = new int[128];
        int n4 = 0;
        while (n4 != byArray.length) {
            nArray[n4] = byArray[n4] & 0xFF;
            ++n4;
        }
        int n5 = byArray.length;
        if (n5 < 128) {
            n3 = 0;
            n2 = nArray[n5 - 1];
            do {
                n2 = piTable[n2 + nArray[n3++] & 0xFF] & 0xFF;
                nArray[n5++] = n2;
            } while (n5 < 128);
        }
        n5 = n + 7 >> 3;
        nArray[128 - n5] = n2 = piTable[nArray[128 - n5] & 255 >> (7 & -n)] & 0xFF;
        n3 = 128 - n5 - 1;
        while (n3 >= 0) {
            nArray[n3] = n2 = piTable[n2 ^ nArray[n3 + n5]] & 0xFF;
            --n3;
        }
        int[] nArray2 = new int[64];
        int n6 = 0;
        while (n6 != nArray2.length) {
            nArray2[n6] = nArray[2 * n6] + (nArray[2 * n6 + 1] << 8);
            ++n6;
        }
        return nArray2;
    }

    public String getAlgorithmName() {
        return "RC2";
    }

    public int getBlockSize() {
        return 8;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        byte[] byArray;
        this.encrypting = bl;
        if (cipherParameters instanceof RC2Parameters) {
            RC2Parameters rC2Parameters = (RC2Parameters)cipherParameters;
            this.workingKey = this.generateWorkingKey(rC2Parameters.getKey(), rC2Parameters.getEffectiveKeyBits());
            byArray = rC2Parameters.getKey();
        } else if (cipherParameters instanceof KeyParameter) {
            byArray = ((KeyParameter)cipherParameters).getKey();
            this.workingKey = this.generateWorkingKey(byArray, byArray.length * 8);
        } else {
            throw new IllegalArgumentException("invalid parameter passed to RC2 init - " + cipherParameters.getClass().getName());
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), byArray.length * 8, cipherParameters, Utils.getPurpose(bl)));
    }

    public final int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.workingKey == null) {
            throw new IllegalStateException("RC2 engine not initialised");
        }
        if (n + 8 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + 8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.encrypting) {
            this.encryptBlock(byArray, n, byArray2, n2);
        } else {
            this.decryptBlock(byArray, n, byArray2, n2);
        }
        return 8;
    }

    public void reset() {
    }

    private int rotateWordLeft(int n, int n2) {
        return (n &= 0xFFFF) << n2 | n >> 16 - n2;
    }
}

