/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.params.KeyParameter;

public class CamelliaLightEngine
implements BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final int MASK8 = 255;
    private boolean initialized = false;
    private int _keySize;
    private boolean forEncryption;
    private int[] subkey = new int[96];
    private int[] kw = new int[8];
    private int[] ke = new int[12];
    private static final int[] SIGMA = new int[]{-1600231809, 1003262091, -1233459112, 1286239154, -957401297, -380665154, 1426019237, -237801700, 283453434, -563598051, -1336506174, -1276722691};
    private static final byte[] SBOX1;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 112;
        byArray[1] = -126;
        byArray[2] = 44;
        byArray[3] = -20;
        byArray[4] = -77;
        byArray[5] = 39;
        byArray[6] = -64;
        byArray[7] = -27;
        byArray[8] = -28;
        byArray[9] = -123;
        byArray[10] = 87;
        byArray[11] = 53;
        byArray[12] = -22;
        byArray[13] = 12;
        byArray[14] = -82;
        byArray[15] = 65;
        byArray[16] = 35;
        byArray[17] = -17;
        byArray[18] = 107;
        byArray[19] = -109;
        byArray[20] = 69;
        byArray[21] = 25;
        byArray[22] = -91;
        byArray[23] = 33;
        byArray[24] = -19;
        byArray[25] = 14;
        byArray[26] = 79;
        byArray[27] = 78;
        byArray[28] = 29;
        byArray[29] = 101;
        byArray[30] = -110;
        byArray[31] = -67;
        byArray[32] = -122;
        byArray[33] = -72;
        byArray[34] = -81;
        byArray[35] = -113;
        byArray[36] = 124;
        byArray[37] = -21;
        byArray[38] = 31;
        byArray[39] = -50;
        byArray[40] = 62;
        byArray[41] = 48;
        byArray[42] = -36;
        byArray[43] = 95;
        byArray[44] = 94;
        byArray[45] = -59;
        byArray[46] = 11;
        byArray[47] = 26;
        byArray[48] = -90;
        byArray[49] = -31;
        byArray[50] = 57;
        byArray[51] = -54;
        byArray[52] = -43;
        byArray[53] = 71;
        byArray[54] = 93;
        byArray[55] = 61;
        byArray[56] = -39;
        byArray[57] = 1;
        byArray[58] = 90;
        byArray[59] = -42;
        byArray[60] = 81;
        byArray[61] = 86;
        byArray[62] = 108;
        byArray[63] = 77;
        byArray[64] = -117;
        byArray[65] = 13;
        byArray[66] = -102;
        byArray[67] = 102;
        byArray[68] = -5;
        byArray[69] = -52;
        byArray[70] = -80;
        byArray[71] = 45;
        byArray[72] = 116;
        byArray[73] = 18;
        byArray[74] = 43;
        byArray[75] = 32;
        byArray[76] = -16;
        byArray[77] = -79;
        byArray[78] = -124;
        byArray[79] = -103;
        byArray[80] = -33;
        byArray[81] = 76;
        byArray[82] = -53;
        byArray[83] = -62;
        byArray[84] = 52;
        byArray[85] = 126;
        byArray[86] = 118;
        byArray[87] = 5;
        byArray[88] = 109;
        byArray[89] = -73;
        byArray[90] = -87;
        byArray[91] = 49;
        byArray[92] = -47;
        byArray[93] = 23;
        byArray[94] = 4;
        byArray[95] = -41;
        byArray[96] = 20;
        byArray[97] = 88;
        byArray[98] = 58;
        byArray[99] = 97;
        byArray[100] = -34;
        byArray[101] = 27;
        byArray[102] = 17;
        byArray[103] = 28;
        byArray[104] = 50;
        byArray[105] = 15;
        byArray[106] = -100;
        byArray[107] = 22;
        byArray[108] = 83;
        byArray[109] = 24;
        byArray[110] = -14;
        byArray[111] = 34;
        byArray[112] = -2;
        byArray[113] = 68;
        byArray[114] = -49;
        byArray[115] = -78;
        byArray[116] = -61;
        byArray[117] = -75;
        byArray[118] = 122;
        byArray[119] = -111;
        byArray[120] = 36;
        byArray[121] = 8;
        byArray[122] = -24;
        byArray[123] = -88;
        byArray[124] = 96;
        byArray[125] = -4;
        byArray[126] = 105;
        byArray[127] = 80;
        byArray[128] = -86;
        byArray[129] = -48;
        byArray[130] = -96;
        byArray[131] = 125;
        byArray[132] = -95;
        byArray[133] = -119;
        byArray[134] = 98;
        byArray[135] = -105;
        byArray[136] = 84;
        byArray[137] = 91;
        byArray[138] = 30;
        byArray[139] = -107;
        byArray[140] = -32;
        byArray[141] = -1;
        byArray[142] = 100;
        byArray[143] = -46;
        byArray[144] = 16;
        byArray[145] = -60;
        byArray[147] = 72;
        byArray[148] = -93;
        byArray[149] = -9;
        byArray[150] = 117;
        byArray[151] = -37;
        byArray[152] = -118;
        byArray[153] = 3;
        byArray[154] = -26;
        byArray[155] = -38;
        byArray[156] = 9;
        byArray[157] = 63;
        byArray[158] = -35;
        byArray[159] = -108;
        byArray[160] = -121;
        byArray[161] = 92;
        byArray[162] = -125;
        byArray[163] = 2;
        byArray[164] = -51;
        byArray[165] = 74;
        byArray[166] = -112;
        byArray[167] = 51;
        byArray[168] = 115;
        byArray[169] = 103;
        byArray[170] = -10;
        byArray[171] = -13;
        byArray[172] = -99;
        byArray[173] = 127;
        byArray[174] = -65;
        byArray[175] = -30;
        byArray[176] = 82;
        byArray[177] = -101;
        byArray[178] = -40;
        byArray[179] = 38;
        byArray[180] = -56;
        byArray[181] = 55;
        byArray[182] = -58;
        byArray[183] = 59;
        byArray[184] = -127;
        byArray[185] = -106;
        byArray[186] = 111;
        byArray[187] = 75;
        byArray[188] = 19;
        byArray[189] = -66;
        byArray[190] = 99;
        byArray[191] = 46;
        byArray[192] = -23;
        byArray[193] = 121;
        byArray[194] = -89;
        byArray[195] = -116;
        byArray[196] = -97;
        byArray[197] = 110;
        byArray[198] = -68;
        byArray[199] = -114;
        byArray[200] = 41;
        byArray[201] = -11;
        byArray[202] = -7;
        byArray[203] = -74;
        byArray[204] = 47;
        byArray[205] = -3;
        byArray[206] = -76;
        byArray[207] = 89;
        byArray[208] = 120;
        byArray[209] = -104;
        byArray[210] = 6;
        byArray[211] = 106;
        byArray[212] = -25;
        byArray[213] = 70;
        byArray[214] = 113;
        byArray[215] = -70;
        byArray[216] = -44;
        byArray[217] = 37;
        byArray[218] = -85;
        byArray[219] = 66;
        byArray[220] = -120;
        byArray[221] = -94;
        byArray[222] = -115;
        byArray[223] = -6;
        byArray[224] = 114;
        byArray[225] = 7;
        byArray[226] = -71;
        byArray[227] = 85;
        byArray[228] = -8;
        byArray[229] = -18;
        byArray[230] = -84;
        byArray[231] = 10;
        byArray[232] = 54;
        byArray[233] = 73;
        byArray[234] = 42;
        byArray[235] = 104;
        byArray[236] = 60;
        byArray[237] = 56;
        byArray[238] = -15;
        byArray[239] = -92;
        byArray[240] = 64;
        byArray[241] = 40;
        byArray[242] = -45;
        byArray[243] = 123;
        byArray[244] = -69;
        byArray[245] = -55;
        byArray[246] = 67;
        byArray[247] = -63;
        byArray[248] = 21;
        byArray[249] = -29;
        byArray[250] = -83;
        byArray[251] = -12;
        byArray[252] = 119;
        byArray[253] = -57;
        byArray[254] = -128;
        byArray[255] = -98;
        SBOX1 = byArray;
    }

    public CamelliaLightEngine() {
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), this.bitsOfSecurity()));
    }

    private int bitsOfSecurity() {
        return this._keySize * 8;
    }

    private int bytes2int(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            n2 = (n2 << 8) + (byArray[n3 + n] & 0xFF);
            ++n3;
        }
        return n2;
    }

    private void camelliaF2(int[] nArray, int[] nArray2, int n) {
        int n2 = nArray[0] ^ nArray2[n];
        int n3 = this.sbox4(n2 & 0xFF);
        n3 |= this.sbox3(n2 >>> 8 & 0xFF) << 8;
        n3 |= this.sbox2(n2 >>> 16 & 0xFF) << 16;
        n3 |= (SBOX1[n2 >>> 24 & 0xFF] & 0xFF) << 24;
        int n4 = nArray[1] ^ nArray2[1 + n];
        int n5 = SBOX1[n4 & 0xFF] & 0xFF;
        n5 |= this.sbox4(n4 >>> 8 & 0xFF) << 8;
        n5 |= this.sbox3(n4 >>> 16 & 0xFF) << 16;
        n5 |= this.sbox2(n4 >>> 24 & 0xFF) << 24;
        n5 = CamelliaLightEngine.leftRotate(n5, 8);
        n3 ^= n5;
        n5 = CamelliaLightEngine.leftRotate(n5, 8) ^ n3;
        n3 = CamelliaLightEngine.rightRotate(n3, 8) ^ n5;
        nArray[2] = nArray[2] ^ (CamelliaLightEngine.leftRotate(n5, 16) ^ n3);
        nArray[3] = nArray[3] ^ CamelliaLightEngine.leftRotate(n3, 8);
        n2 = nArray[2] ^ nArray2[2 + n];
        n3 = this.sbox4(n2 & 0xFF);
        n3 |= this.sbox3(n2 >>> 8 & 0xFF) << 8;
        n3 |= this.sbox2(n2 >>> 16 & 0xFF) << 16;
        n3 |= (SBOX1[n2 >>> 24 & 0xFF] & 0xFF) << 24;
        n4 = nArray[3] ^ nArray2[3 + n];
        n5 = SBOX1[n4 & 0xFF] & 0xFF;
        n5 |= this.sbox4(n4 >>> 8 & 0xFF) << 8;
        n5 |= this.sbox3(n4 >>> 16 & 0xFF) << 16;
        n5 |= this.sbox2(n4 >>> 24 & 0xFF) << 24;
        n5 = CamelliaLightEngine.leftRotate(n5, 8);
        n3 ^= n5;
        n5 = CamelliaLightEngine.leftRotate(n5, 8) ^ n3;
        n3 = CamelliaLightEngine.rightRotate(n3, 8) ^ n5;
        nArray[0] = nArray[0] ^ (CamelliaLightEngine.leftRotate(n5, 16) ^ n3);
        nArray[1] = nArray[1] ^ CamelliaLightEngine.leftRotate(n3, 8);
    }

    private void camelliaFLs(int[] nArray, int[] nArray2, int n) {
        nArray[1] = nArray[1] ^ CamelliaLightEngine.leftRotate(nArray[0] & nArray2[n], 1);
        nArray[0] = nArray[0] ^ (nArray2[1 + n] | nArray[1]);
        nArray[2] = nArray[2] ^ (nArray2[3 + n] | nArray[3]);
        nArray[3] = nArray[3] ^ CamelliaLightEngine.leftRotate(nArray2[2 + n] & nArray[2], 1);
    }

    private static void decroldq(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        nArray2[2 + n3] = nArray[n2] << n | nArray[1 + n2] >>> 32 - n;
        nArray2[3 + n3] = nArray[1 + n2] << n | nArray[2 + n2] >>> 32 - n;
        nArray2[n3] = nArray[2 + n2] << n | nArray[3 + n2] >>> 32 - n;
        nArray2[1 + n3] = nArray[3 + n2] << n | nArray[n2] >>> 32 - n;
        nArray[n2] = nArray2[2 + n3];
        nArray[1 + n2] = nArray2[3 + n3];
        nArray[2 + n2] = nArray2[n3];
        nArray[3 + n2] = nArray2[1 + n3];
    }

    private static void decroldqo32(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        nArray2[2 + n3] = nArray[1 + n2] << n - 32 | nArray[2 + n2] >>> 64 - n;
        nArray2[3 + n3] = nArray[2 + n2] << n - 32 | nArray[3 + n2] >>> 64 - n;
        nArray2[n3] = nArray[3 + n2] << n - 32 | nArray[n2] >>> 64 - n;
        nArray2[1 + n3] = nArray[n2] << n - 32 | nArray[1 + n2] >>> 64 - n;
        nArray[n2] = nArray2[2 + n3];
        nArray[1 + n2] = nArray2[3 + n3];
        nArray[2 + n2] = nArray2[n3];
        nArray[3 + n2] = nArray2[1 + n3];
    }

    public String getAlgorithmName() {
        return "Camellia";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("only simple KeyParameter expected.");
        }
        this.setKey(bl, ((KeyParameter)cipherParameters).getKey());
        this.initialized = true;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), this.bitsOfSecurity(), cipherParameters, Utils.getPurpose(bl)));
    }

    private void int2bytes(int n, byte[] byArray, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            byArray[3 - n3 + n2] = (byte)n;
            n >>>= 8;
            ++n3;
        }
    }

    private byte lRot8(byte by, int n) {
        return (byte)(by << n | (by & 0xFF) >>> 8 - n);
    }

    private static int leftRotate(int n, int n2) {
        return (n << n2) + (n >>> 32 - n2);
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("Camellia is not initialized");
        }
        if (n + 16 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + 16 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this._keySize == 16) {
            return this.processBlock128(byArray, n, byArray2, n2);
        }
        return this.processBlock192or256(byArray, n, byArray2, n2);
    }

    private int processBlock128(byte[] byArray, int n, byte[] byArray2, int n2) {
        int[] nArray = new int[4];
        int n3 = 0;
        while (n3 < 4) {
            nArray[n3] = this.bytes2int(byArray, n + n3 * 4) ^ this.kw[n3];
            ++n3;
        }
        this.camelliaF2(nArray, this.subkey, 0);
        this.camelliaF2(nArray, this.subkey, 4);
        this.camelliaF2(nArray, this.subkey, 8);
        this.camelliaFLs(nArray, this.ke, 0);
        this.camelliaF2(nArray, this.subkey, 12);
        this.camelliaF2(nArray, this.subkey, 16);
        this.camelliaF2(nArray, this.subkey, 20);
        this.camelliaFLs(nArray, this.ke, 4);
        this.camelliaF2(nArray, this.subkey, 24);
        this.camelliaF2(nArray, this.subkey, 28);
        this.camelliaF2(nArray, this.subkey, 32);
        nArray[2] = nArray[2] ^ this.kw[4];
        nArray[3] = nArray[3] ^ this.kw[5];
        nArray[0] = nArray[0] ^ this.kw[6];
        nArray[1] = nArray[1] ^ this.kw[7];
        this.int2bytes(nArray[2], byArray2, n2);
        this.int2bytes(nArray[3], byArray2, n2 + 4);
        this.int2bytes(nArray[0], byArray2, n2 + 8);
        this.int2bytes(nArray[1], byArray2, n2 + 12);
        return 16;
    }

    private int processBlock192or256(byte[] byArray, int n, byte[] byArray2, int n2) {
        int[] nArray = new int[4];
        int n3 = 0;
        while (n3 < 4) {
            nArray[n3] = this.bytes2int(byArray, n + n3 * 4) ^ this.kw[n3];
            ++n3;
        }
        this.camelliaF2(nArray, this.subkey, 0);
        this.camelliaF2(nArray, this.subkey, 4);
        this.camelliaF2(nArray, this.subkey, 8);
        this.camelliaFLs(nArray, this.ke, 0);
        this.camelliaF2(nArray, this.subkey, 12);
        this.camelliaF2(nArray, this.subkey, 16);
        this.camelliaF2(nArray, this.subkey, 20);
        this.camelliaFLs(nArray, this.ke, 4);
        this.camelliaF2(nArray, this.subkey, 24);
        this.camelliaF2(nArray, this.subkey, 28);
        this.camelliaF2(nArray, this.subkey, 32);
        this.camelliaFLs(nArray, this.ke, 8);
        this.camelliaF2(nArray, this.subkey, 36);
        this.camelliaF2(nArray, this.subkey, 40);
        this.camelliaF2(nArray, this.subkey, 44);
        nArray[2] = nArray[2] ^ this.kw[4];
        nArray[3] = nArray[3] ^ this.kw[5];
        nArray[0] = nArray[0] ^ this.kw[6];
        nArray[1] = nArray[1] ^ this.kw[7];
        this.int2bytes(nArray[2], byArray2, n2);
        this.int2bytes(nArray[3], byArray2, n2 + 4);
        this.int2bytes(nArray[0], byArray2, n2 + 8);
        this.int2bytes(nArray[1], byArray2, n2 + 12);
        return 16;
    }

    public void reset() {
    }

    private static int rightRotate(int n, int n2) {
        return (n >>> n2) + (n << 32 - n2);
    }

    private static void roldq(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        nArray2[n3] = nArray[n2] << n | nArray[1 + n2] >>> 32 - n;
        nArray2[1 + n3] = nArray[1 + n2] << n | nArray[2 + n2] >>> 32 - n;
        nArray2[2 + n3] = nArray[2 + n2] << n | nArray[3 + n2] >>> 32 - n;
        nArray2[3 + n3] = nArray[3 + n2] << n | nArray[n2] >>> 32 - n;
        nArray[n2] = nArray2[n3];
        nArray[1 + n2] = nArray2[1 + n3];
        nArray[2 + n2] = nArray2[2 + n3];
        nArray[3 + n2] = nArray2[3 + n3];
    }

    private static void roldqo32(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        nArray2[n3] = nArray[1 + n2] << n - 32 | nArray[2 + n2] >>> 64 - n;
        nArray2[1 + n3] = nArray[2 + n2] << n - 32 | nArray[3 + n2] >>> 64 - n;
        nArray2[2 + n3] = nArray[3 + n2] << n - 32 | nArray[n2] >>> 64 - n;
        nArray2[3 + n3] = nArray[n2] << n - 32 | nArray[1 + n2] >>> 64 - n;
        nArray[n2] = nArray2[n3];
        nArray[1 + n2] = nArray2[1 + n3];
        nArray[2 + n2] = nArray2[2 + n3];
        nArray[3 + n2] = nArray2[3 + n3];
    }

    private int sbox2(int n) {
        return this.lRot8(SBOX1[n], 1) & 0xFF;
    }

    private int sbox3(int n) {
        return this.lRot8(SBOX1[n], 7) & 0xFF;
    }

    private int sbox4(int n) {
        return SBOX1[this.lRot8((byte)n, 1) & 0xFF] & 0xFF;
    }

    private void setKey(boolean bl, byte[] byArray) {
        this.forEncryption = bl;
        int[] nArray = new int[8];
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        this._keySize = byArray.length;
        switch (byArray.length) {
            case 16: {
                nArray[0] = this.bytes2int(byArray, 0);
                nArray[1] = this.bytes2int(byArray, 4);
                nArray[2] = this.bytes2int(byArray, 8);
                nArray[3] = this.bytes2int(byArray, 12);
                nArray[7] = 0;
                nArray[6] = 0;
                nArray[5] = 0;
                nArray[4] = 0;
                break;
            }
            case 24: {
                nArray[0] = this.bytes2int(byArray, 0);
                nArray[1] = this.bytes2int(byArray, 4);
                nArray[2] = this.bytes2int(byArray, 8);
                nArray[3] = this.bytes2int(byArray, 12);
                nArray[4] = this.bytes2int(byArray, 16);
                nArray[5] = this.bytes2int(byArray, 20);
                nArray[6] = ~nArray[4];
                nArray[7] = ~nArray[5];
                break;
            }
            case 32: {
                nArray[0] = this.bytes2int(byArray, 0);
                nArray[1] = this.bytes2int(byArray, 4);
                nArray[2] = this.bytes2int(byArray, 8);
                nArray[3] = this.bytes2int(byArray, 12);
                nArray[4] = this.bytes2int(byArray, 16);
                nArray[5] = this.bytes2int(byArray, 20);
                nArray[6] = this.bytes2int(byArray, 24);
                nArray[7] = this.bytes2int(byArray, 28);
                break;
            }
            default: {
                throw new IllegalArgumentException("key sizes are only 16/24/32 bytes.");
            }
        }
        int n = 0;
        while (n < 4) {
            nArray2[n] = nArray[n] ^ nArray[n + 4];
            ++n;
        }
        this.camelliaF2(nArray2, SIGMA, 0);
        int n2 = 0;
        while (n2 < 4) {
            int n3 = n2;
            nArray2[n3] = nArray2[n3] ^ nArray[n2];
            ++n2;
        }
        this.camelliaF2(nArray2, SIGMA, 4);
        if (this._keySize == 16) {
            if (bl) {
                this.kw[0] = nArray[0];
                this.kw[1] = nArray[1];
                this.kw[2] = nArray[2];
                this.kw[3] = nArray[3];
                CamelliaLightEngine.roldq(15, nArray, 0, this.subkey, 4);
                CamelliaLightEngine.roldq(30, nArray, 0, this.subkey, 12);
                CamelliaLightEngine.roldq(15, nArray, 0, nArray4, 0);
                this.subkey[18] = nArray4[2];
                this.subkey[19] = nArray4[3];
                CamelliaLightEngine.roldq(17, nArray, 0, this.ke, 4);
                CamelliaLightEngine.roldq(17, nArray, 0, this.subkey, 24);
                CamelliaLightEngine.roldq(17, nArray, 0, this.subkey, 32);
                this.subkey[0] = nArray2[0];
                this.subkey[1] = nArray2[1];
                this.subkey[2] = nArray2[2];
                this.subkey[3] = nArray2[3];
                CamelliaLightEngine.roldq(15, nArray2, 0, this.subkey, 8);
                CamelliaLightEngine.roldq(15, nArray2, 0, this.ke, 0);
                CamelliaLightEngine.roldq(15, nArray2, 0, nArray4, 0);
                this.subkey[16] = nArray4[0];
                this.subkey[17] = nArray4[1];
                CamelliaLightEngine.roldq(15, nArray2, 0, this.subkey, 20);
                CamelliaLightEngine.roldqo32(34, nArray2, 0, this.subkey, 28);
                CamelliaLightEngine.roldq(17, nArray2, 0, this.kw, 4);
            } else {
                this.kw[4] = nArray[0];
                this.kw[5] = nArray[1];
                this.kw[6] = nArray[2];
                this.kw[7] = nArray[3];
                CamelliaLightEngine.decroldq(15, nArray, 0, this.subkey, 28);
                CamelliaLightEngine.decroldq(30, nArray, 0, this.subkey, 20);
                CamelliaLightEngine.decroldq(15, nArray, 0, nArray4, 0);
                this.subkey[16] = nArray4[0];
                this.subkey[17] = nArray4[1];
                CamelliaLightEngine.decroldq(17, nArray, 0, this.ke, 0);
                CamelliaLightEngine.decroldq(17, nArray, 0, this.subkey, 8);
                CamelliaLightEngine.decroldq(17, nArray, 0, this.subkey, 0);
                this.subkey[34] = nArray2[0];
                this.subkey[35] = nArray2[1];
                this.subkey[32] = nArray2[2];
                this.subkey[33] = nArray2[3];
                CamelliaLightEngine.decroldq(15, nArray2, 0, this.subkey, 24);
                CamelliaLightEngine.decroldq(15, nArray2, 0, this.ke, 4);
                CamelliaLightEngine.decroldq(15, nArray2, 0, nArray4, 0);
                this.subkey[18] = nArray4[2];
                this.subkey[19] = nArray4[3];
                CamelliaLightEngine.decroldq(15, nArray2, 0, this.subkey, 12);
                CamelliaLightEngine.decroldqo32(34, nArray2, 0, this.subkey, 4);
                CamelliaLightEngine.roldq(17, nArray2, 0, this.kw, 0);
            }
        } else {
            int n4 = 0;
            while (n4 < 4) {
                nArray3[n4] = nArray2[n4] ^ nArray[n4 + 4];
                ++n4;
            }
            this.camelliaF2(nArray3, SIGMA, 8);
            if (bl) {
                this.kw[0] = nArray[0];
                this.kw[1] = nArray[1];
                this.kw[2] = nArray[2];
                this.kw[3] = nArray[3];
                CamelliaLightEngine.roldqo32(45, nArray, 0, this.subkey, 16);
                CamelliaLightEngine.roldq(15, nArray, 0, this.ke, 4);
                CamelliaLightEngine.roldq(17, nArray, 0, this.subkey, 32);
                CamelliaLightEngine.roldqo32(34, nArray, 0, this.subkey, 44);
                CamelliaLightEngine.roldq(15, nArray, 4, this.subkey, 4);
                CamelliaLightEngine.roldq(15, nArray, 4, this.ke, 0);
                CamelliaLightEngine.roldq(30, nArray, 4, this.subkey, 24);
                CamelliaLightEngine.roldqo32(34, nArray, 4, this.subkey, 36);
                CamelliaLightEngine.roldq(15, nArray2, 0, this.subkey, 8);
                CamelliaLightEngine.roldq(30, nArray2, 0, this.subkey, 20);
                this.ke[8] = nArray2[1];
                this.ke[9] = nArray2[2];
                this.ke[10] = nArray2[3];
                this.ke[11] = nArray2[0];
                CamelliaLightEngine.roldqo32(49, nArray2, 0, this.subkey, 40);
                this.subkey[0] = nArray3[0];
                this.subkey[1] = nArray3[1];
                this.subkey[2] = nArray3[2];
                this.subkey[3] = nArray3[3];
                CamelliaLightEngine.roldq(30, nArray3, 0, this.subkey, 12);
                CamelliaLightEngine.roldq(30, nArray3, 0, this.subkey, 28);
                CamelliaLightEngine.roldqo32(51, nArray3, 0, this.kw, 4);
            } else {
                this.kw[4] = nArray[0];
                this.kw[5] = nArray[1];
                this.kw[6] = nArray[2];
                this.kw[7] = nArray[3];
                CamelliaLightEngine.decroldqo32(45, nArray, 0, this.subkey, 28);
                CamelliaLightEngine.decroldq(15, nArray, 0, this.ke, 4);
                CamelliaLightEngine.decroldq(17, nArray, 0, this.subkey, 12);
                CamelliaLightEngine.decroldqo32(34, nArray, 0, this.subkey, 0);
                CamelliaLightEngine.decroldq(15, nArray, 4, this.subkey, 40);
                CamelliaLightEngine.decroldq(15, nArray, 4, this.ke, 8);
                CamelliaLightEngine.decroldq(30, nArray, 4, this.subkey, 20);
                CamelliaLightEngine.decroldqo32(34, nArray, 4, this.subkey, 8);
                CamelliaLightEngine.decroldq(15, nArray2, 0, this.subkey, 36);
                CamelliaLightEngine.decroldq(30, nArray2, 0, this.subkey, 24);
                this.ke[2] = nArray2[1];
                this.ke[3] = nArray2[2];
                this.ke[0] = nArray2[3];
                this.ke[1] = nArray2[0];
                CamelliaLightEngine.decroldqo32(49, nArray2, 0, this.subkey, 4);
                this.subkey[46] = nArray3[0];
                this.subkey[47] = nArray3[1];
                this.subkey[44] = nArray3[2];
                this.subkey[45] = nArray3[3];
                CamelliaLightEngine.decroldq(30, nArray3, 0, this.subkey, 32);
                CamelliaLightEngine.decroldq(30, nArray3, 0, this.subkey, 16);
                CamelliaLightEngine.roldqo32(51, nArray3, 0, this.kw, 0);
            }
        }
    }
}

