/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String STRICT_LENGTH_ENABLED_PROPERTY = "org.bouncycastle.pkcs1.strict";
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "org.bouncycastle.pkcs1.not_strict";
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private boolean useStrictLength;
    private int pLen = -1;
    private byte[] fallback = null;
    private byte[] blockBuffer;

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
    }

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher, int n) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
        this.pLen = n;
    }

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher, byte[] byArray) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
        this.fallback = byArray;
        this.pLen = byArray.length;
    }

    private static int checkPkcs1Encoding1(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = -(byArray[0] & 0xFF ^ 1);
        int n5 = 1;
        while (n5 < byArray.length) {
            n = byArray[n5] & 0xFF;
            int n6 = n - 1 >> 31;
            int n7 = (n ^ 0xFF) - 1 >> 31;
            n3 ^= n5 & ~n2 & n6;
            n4 |= ~((n2 |= n6) | n7);
            ++n5;
        }
        n = byArray.length - 1 - n3;
        return n | (n4 |= n3 - 9) >> 31;
    }

    private static int checkPkcs1Encoding2(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = -(byArray[0] & 0xFF ^ 2);
        int n5 = 1;
        while (n5 < byArray.length) {
            n = byArray[n5] & 0xFF;
            int n6 = n - 1 >> 31;
            n3 ^= n5 & ~n2 & n6;
            n2 |= n6;
            ++n5;
        }
        n = byArray.length - 1 - n3;
        return n | (n4 |= n3 - 9) >> 31;
    }

    private static int checkPkcs1Encoding2(byte[] byArray, int n) {
        int n2 = -(byArray[0] & 0xFF ^ 2);
        int n3 = byArray.length - 1 - n;
        n2 |= n3 - 9;
        int n4 = 1;
        while (n4 < n3) {
            n2 |= (byArray[n4] & 0xFF) - 1;
            ++n4;
        }
        return (n2 |= -(byArray[n3] & 0xFF)) >> 31;
    }

    private byte[] decodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        byte[] byArray2;
        if (this.forPrivateKey && this.pLen != -1) {
            return this.decodeBlockOrRandom(byArray, n, n2);
        }
        int n3 = this.engine.getOutputBlockSize();
        byte[] byArray3 = this.engine.processBlock(byArray, n, n2);
        boolean bl = this.useStrictLength & byArray3.length != n3;
        byte[] byArray4 = byArray3;
        if (byArray3.length < n3) {
            byArray4 = this.blockBuffer;
        }
        int n4 = this.forPrivateKey ? PKCS1Encoding.checkPkcs1Encoding2(byArray4) : PKCS1Encoding.checkPkcs1Encoding1(byArray4);
        try {
            if (n4 < 0) {
                throw new InvalidCipherTextException("block incorrect");
            }
            if (bl) {
                throw new InvalidCipherTextException("block incorrect size");
            }
            byte[] byArray5 = new byte[n4];
            System.arraycopy(byArray4, byArray4.length - n4, byArray5, 0, n4);
            byArray2 = byArray5;
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Arrays.fill(byArray3, (byte)0);
            Arrays.fill(this.blockBuffer, 0, Math.max(0, this.blockBuffer.length - byArray3.length), (byte)0);
            throw throwable;
        }
        Arrays.fill(byArray3, (byte)0);
        Arrays.fill(this.blockBuffer, 0, Math.max(0, this.blockBuffer.length - byArray3.length), (byte)0);
        return byArray2;
    }

    private byte[] decodeBlockOrRandom(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        byte[] byArray2;
        if (!this.forPrivateKey) {
            throw new InvalidCipherTextException("sorry, this method is only for decryption, not for signing");
        }
        int n3 = this.pLen;
        byte[] byArray3 = this.fallback;
        if (this.fallback == null) {
            byArray3 = new byte[n3];
            this.random.nextBytes(byArray3);
        }
        int n4 = 0;
        int n5 = this.engine.getOutputBlockSize();
        byte[] byArray4 = byArray2 = this.engine.processBlock(byArray, n, n2);
        if (byArray2.length != n5 && (this.useStrictLength || byArray2.length < n5)) {
            byArray4 = this.blockBuffer;
        }
        n4 |= PKCS1Encoding.checkPkcs1Encoding2(byArray4, n3);
        int n6 = byArray4.length - n3;
        byte[] byArray5 = new byte[n3];
        int n7 = 0;
        while (n7 < n3) {
            byArray5[n7] = (byte)(byArray4[n6 + n7] & ~n4 | byArray3[n7] & n4);
            ++n7;
        }
        Arrays.fill(byArray2, (byte)0);
        Arrays.fill(this.blockBuffer, 0, Math.max(0, this.blockBuffer.length - byArray2.length), (byte)0);
        return byArray5;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] encodeBlock(byte[] var1_1, int var2_2, int var3_3) throws InvalidCipherTextException {
        block5: {
            block4: {
                if (var3_3 > this.getInputBlockSize()) {
                    throw new IllegalArgumentException("input data too large");
                }
                var4_4 = new byte[this.engine.getInputBlockSize()];
                if (!this.forPrivateKey) break block4;
                var4_4[0] = 1;
                var5_5 = 1;
                while (var5_5 != var4_4.length - var3_3 - 1) {
                    var4_4[var5_5] = -1;
                    ++var5_5;
                }
                break block5;
            }
            this.random.nextBytes(var4_4);
            var4_4[0] = 2;
            var5_6 = 1;
            ** GOTO lbl21
            {
                var4_4[var5_6] = (byte)this.random.nextInt();
                do {
                    if (var4_4[var5_6] == 0) continue block1;
                    ++var5_6;
lbl21:
                    // 2 sources

                } while (var5_6 != var4_4.length - var3_3 - 1);
            }
        }
        var4_4[var4_4.length - var3_3 - 1] = 0;
        System.arraycopy(var1_1, var2_2, var4_4, var4_4.length - var3_3, var3_3);
        return this.engine.processBlock(var4_4, 0, var4_4.length);
    }

    public int getInputBlockSize() {
        int n = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return n - 10;
        }
        return n;
    }

    public int getOutputBlockSize() {
        int n = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n;
        }
        return n - 10;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
            if (!asymmetricKeyParameter.isPrivate() && bl) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
        }
        this.engine.init(bl, cipherParameters);
        this.forPrivateKey = asymmetricKeyParameter.isPrivate();
        this.forEncryption = bl;
        this.blockBuffer = new byte[this.engine.getOutputBlockSize()];
        if (this.pLen > 0 && this.fallback == null && this.random == null) {
            throw new IllegalArgumentException("encoder requires random");
        }
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n, n2);
        }
        return this.decodeBlock(byArray, n, n2);
    }

    private boolean useStrict() {
        if (Properties.isOverrideSetTo(NOT_STRICT_LENGTH_ENABLED_PROPERTY, true)) {
            return false;
        }
        return Properties.isOverrideSetTo(STRICT_LENGTH_ENABLED_PROPERTY, false) ^ true;
    }
}

