/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private final AsymmetricBlockCipher engine;
    private final Digest mgf1Hash;
    private final int mgf1NoMemoLimit;
    private final byte[] defHash;
    private SecureRandom random;
    private boolean forEncryption;

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this(asymmetricBlockCipher, DigestFactory.createSHA1(), null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray) {
        this.engine = asymmetricBlockCipher;
        this.mgf1Hash = digest2;
        this.mgf1NoMemoLimit = OAEPEncoding.getMGF1NoMemoLimit(digest2);
        this.defHash = new byte[digest.getDigestSize()];
        digest.reset();
        if (byArray != null) {
            digest.update(byArray, 0, byArray.length);
        }
        digest.doFinal(this.defHash, 0);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, byte[] byArray) {
        this(asymmetricBlockCipher, digest, digest, byArray);
    }

    public byte[] decodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        int n3 = this.getOutputBlockSize() >> 31;
        byte[] byArray2 = new byte[this.engine.getOutputBlockSize()];
        byte[] byArray3 = this.engine.processBlock(byArray, n, n2);
        n3 |= byArray2.length - byArray3.length >> 31;
        int n4 = Math.min(byArray2.length, byArray3.length);
        System.arraycopy(byArray3, 0, byArray2, byArray2.length - n4, n4);
        Arrays.fill(byArray3, (byte)0);
        this.mgf1Hash.reset();
        this.maskGeneratorFunction1(byArray2, this.defHash.length, byArray2.length - this.defHash.length, byArray2, 0, this.defHash.length);
        this.maskGeneratorFunction1(byArray2, 0, this.defHash.length, byArray2, this.defHash.length, byArray2.length - this.defHash.length);
        int n5 = 0;
        while (n5 != this.defHash.length) {
            n3 |= this.defHash[n5] ^ byArray2[this.defHash.length + n5];
            ++n5;
        }
        int n6 = -1;
        int n7 = 2 * this.defHash.length;
        while (n7 != byArray2.length) {
            int n8 = byArray2[n7] & 0xFF;
            int n9 = (-n8 & n6) >> 31;
            n6 += n7 & n9;
            ++n7;
        }
        n3 |= n6 >> 31;
        if ((n3 |= byArray2[++n6] ^ 1) != 0) {
            Arrays.fill(byArray2, (byte)0);
            throw new InvalidCipherTextException("data wrong");
        }
        byte[] byArray4 = new byte[byArray2.length - ++n6];
        System.arraycopy(byArray2, n6, byArray4, 0, byArray4.length);
        Arrays.fill(byArray2, (byte)0);
        return byArray4;
    }

    public byte[] encodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        int n3 = this.getInputBlockSize();
        if (n2 > n3) {
            throw new DataLengthException("input data too long");
        }
        byte[] byArray2 = new byte[n3 + 1 + 2 * this.defHash.length];
        System.arraycopy(byArray, n, byArray2, byArray2.length - n2, n2);
        byArray2[byArray2.length - n2 - 1] = 1;
        System.arraycopy(this.defHash, 0, byArray2, this.defHash.length, this.defHash.length);
        byte[] byArray3 = new byte[this.defHash.length];
        this.random.nextBytes(byArray3);
        System.arraycopy(byArray3, 0, byArray2, 0, this.defHash.length);
        this.mgf1Hash.reset();
        this.maskGeneratorFunction1(byArray3, 0, byArray3.length, byArray2, this.defHash.length, byArray2.length - this.defHash.length);
        this.maskGeneratorFunction1(byArray2, this.defHash.length, byArray2.length - this.defHash.length, byArray2, 0, this.defHash.length);
        return this.engine.processBlock(byArray2, 0, byArray2.length);
    }

    public int getInputBlockSize() {
        int n = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return n - 1 - 2 * this.defHash.length;
        }
        return n;
    }

    private static int getMGF1NoMemoLimit(Digest digest) {
        if (digest instanceof Memoable && digest instanceof ExtendedDigest) {
            return ((ExtendedDigest)digest).getByteLength() - 1;
        }
        return Integer.MAX_VALUE;
    }

    public int getOutputBlockSize() {
        int n = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n;
        }
        return n - 1 - 2 * this.defHash.length;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        SecureRandom secureRandom = null;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            secureRandom = parametersWithRandom.getRandom();
        }
        this.random = bl ? CryptoServicesRegistrar.getSecureRandom(secureRandom) : null;
        this.forEncryption = bl;
        this.engine.init(bl, cipherParameters);
    }

    /*
     * Unable to fully structure code
     */
    private void maskGeneratorFunction1(byte[] var1_1, int var2_2, int var3_3, byte[] var4_4, int var5_5, int var6_6) {
        block2: {
            var7_7 = this.mgf1Hash.getDigestSize();
            var8_8 = new byte[var7_7];
            var9_9 = new byte[4];
            var10_10 = 0;
            var11_11 = var5_5 + var6_6;
            var12_12 = var11_11 - var7_7;
            var13_13 = var5_5;
            this.mgf1Hash.update(var1_1, var2_2, var3_3);
            if (var3_3 <= this.mgf1NoMemoLimit) ** GOTO lbl29
            var14_14 = (Memoable)this.mgf1Hash;
            var15_15 = var14_14.copy();
            while (var13_13 < var12_12) {
                Pack.intToBigEndian(var10_10++, var9_9, 0);
                this.mgf1Hash.update(var9_9, 0, var9_9.length);
                this.mgf1Hash.doFinal(var8_8, 0);
                var14_14.reset(var15_15);
                Bytes.xorTo(var7_7, var8_8, 0, var4_4, var13_13);
                var13_13 += var7_7;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                Pack.intToBigEndian(var10_10++, var9_9, 0);
                this.mgf1Hash.update(var9_9, 0, var9_9.length);
                this.mgf1Hash.doFinal(var8_8, 0);
                this.mgf1Hash.update(var1_1, var2_2, var3_3);
                Bytes.xorTo(var7_7, var8_8, 0, var4_4, var13_13);
                var13_13 += var7_7;
lbl29:
                // 2 sources

                ** while (var13_13 < var12_12)
            }
        }
        Pack.intToBigEndian(var10_10, var9_9, 0);
        this.mgf1Hash.update(var9_9, 0, var9_9.length);
        this.mgf1Hash.doFinal(var8_8, 0);
        Bytes.xorTo(var11_11 - var13_13, var8_8, 0, var4_4, var13_13);
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n, n2);
        }
        return this.decodeBlock(byArray, n, n2);
    }
}

