/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public final class WhirlpoolDigest
implements ExtendedDigest,
Memoable {
    private static final int BITCOUNT_ARRAY_SIZE = 32;
    private static final int BYTE_LENGTH = 64;
    private static final int DIGEST_LENGTH_BYTES = 64;
    private static final int REDUCTION_POLYNOMIAL = 285;
    private static final int ROUNDS = 10;
    private static final int[] SBOX;
    private static final long[] C0;
    private static final long[] C1;
    private static final long[] C2;
    private static final long[] C3;
    private static final long[] C4;
    private static final long[] C5;
    private static final long[] C6;
    private static final long[] C7;
    private static final short[] EIGHT;
    private final long[] _rc = new long[11];
    private final CryptoServicePurpose purpose;
    private byte[] _buffer = new byte[64];
    private int _bufferPos = 0;
    private short[] _bitCount = new short[32];
    private long[] _hash = new long[8];
    private long[] _K = new long[8];
    private long[] _L = new long[8];
    private long[] _block = new long[8];
    private long[] _state = new long[8];

    static {
        int[] nArray = new int[256];
        nArray[0] = 24;
        nArray[1] = 35;
        nArray[2] = 198;
        nArray[3] = 232;
        nArray[4] = 135;
        nArray[5] = 184;
        nArray[6] = 1;
        nArray[7] = 79;
        nArray[8] = 54;
        nArray[9] = 166;
        nArray[10] = 210;
        nArray[11] = 245;
        nArray[12] = 121;
        nArray[13] = 111;
        nArray[14] = 145;
        nArray[15] = 82;
        nArray[16] = 96;
        nArray[17] = 188;
        nArray[18] = 155;
        nArray[19] = 142;
        nArray[20] = 163;
        nArray[21] = 12;
        nArray[22] = 123;
        nArray[23] = 53;
        nArray[24] = 29;
        nArray[25] = 224;
        nArray[26] = 215;
        nArray[27] = 194;
        nArray[28] = 46;
        nArray[29] = 75;
        nArray[30] = 254;
        nArray[31] = 87;
        nArray[32] = 21;
        nArray[33] = 119;
        nArray[34] = 55;
        nArray[35] = 229;
        nArray[36] = 159;
        nArray[37] = 240;
        nArray[38] = 74;
        nArray[39] = 218;
        nArray[40] = 88;
        nArray[41] = 201;
        nArray[42] = 41;
        nArray[43] = 10;
        nArray[44] = 177;
        nArray[45] = 160;
        nArray[46] = 107;
        nArray[47] = 133;
        nArray[48] = 189;
        nArray[49] = 93;
        nArray[50] = 16;
        nArray[51] = 244;
        nArray[52] = 203;
        nArray[53] = 62;
        nArray[54] = 5;
        nArray[55] = 103;
        nArray[56] = 228;
        nArray[57] = 39;
        nArray[58] = 65;
        nArray[59] = 139;
        nArray[60] = 167;
        nArray[61] = 125;
        nArray[62] = 149;
        nArray[63] = 216;
        nArray[64] = 251;
        nArray[65] = 238;
        nArray[66] = 124;
        nArray[67] = 102;
        nArray[68] = 221;
        nArray[69] = 23;
        nArray[70] = 71;
        nArray[71] = 158;
        nArray[72] = 202;
        nArray[73] = 45;
        nArray[74] = 191;
        nArray[75] = 7;
        nArray[76] = 173;
        nArray[77] = 90;
        nArray[78] = 131;
        nArray[79] = 51;
        nArray[80] = 99;
        nArray[81] = 2;
        nArray[82] = 170;
        nArray[83] = 113;
        nArray[84] = 200;
        nArray[85] = 25;
        nArray[86] = 73;
        nArray[87] = 217;
        nArray[88] = 242;
        nArray[89] = 227;
        nArray[90] = 91;
        nArray[91] = 136;
        nArray[92] = 154;
        nArray[93] = 38;
        nArray[94] = 50;
        nArray[95] = 176;
        nArray[96] = 233;
        nArray[97] = 15;
        nArray[98] = 213;
        nArray[99] = 128;
        nArray[100] = 190;
        nArray[101] = 205;
        nArray[102] = 52;
        nArray[103] = 72;
        nArray[104] = 255;
        nArray[105] = 122;
        nArray[106] = 144;
        nArray[107] = 95;
        nArray[108] = 32;
        nArray[109] = 104;
        nArray[110] = 26;
        nArray[111] = 174;
        nArray[112] = 180;
        nArray[113] = 84;
        nArray[114] = 147;
        nArray[115] = 34;
        nArray[116] = 100;
        nArray[117] = 241;
        nArray[118] = 115;
        nArray[119] = 18;
        nArray[120] = 64;
        nArray[121] = 8;
        nArray[122] = 195;
        nArray[123] = 236;
        nArray[124] = 219;
        nArray[125] = 161;
        nArray[126] = 141;
        nArray[127] = 61;
        nArray[128] = 151;
        nArray[130] = 207;
        nArray[131] = 43;
        nArray[132] = 118;
        nArray[133] = 130;
        nArray[134] = 214;
        nArray[135] = 27;
        nArray[136] = 181;
        nArray[137] = 175;
        nArray[138] = 106;
        nArray[139] = 80;
        nArray[140] = 69;
        nArray[141] = 243;
        nArray[142] = 48;
        nArray[143] = 239;
        nArray[144] = 63;
        nArray[145] = 85;
        nArray[146] = 162;
        nArray[147] = 234;
        nArray[148] = 101;
        nArray[149] = 186;
        nArray[150] = 47;
        nArray[151] = 192;
        nArray[152] = 222;
        nArray[153] = 28;
        nArray[154] = 253;
        nArray[155] = 77;
        nArray[156] = 146;
        nArray[157] = 117;
        nArray[158] = 6;
        nArray[159] = 138;
        nArray[160] = 178;
        nArray[161] = 230;
        nArray[162] = 14;
        nArray[163] = 31;
        nArray[164] = 98;
        nArray[165] = 212;
        nArray[166] = 168;
        nArray[167] = 150;
        nArray[168] = 249;
        nArray[169] = 197;
        nArray[170] = 37;
        nArray[171] = 89;
        nArray[172] = 132;
        nArray[173] = 114;
        nArray[174] = 57;
        nArray[175] = 76;
        nArray[176] = 94;
        nArray[177] = 120;
        nArray[178] = 56;
        nArray[179] = 140;
        nArray[180] = 209;
        nArray[181] = 165;
        nArray[182] = 226;
        nArray[183] = 97;
        nArray[184] = 179;
        nArray[185] = 33;
        nArray[186] = 156;
        nArray[187] = 30;
        nArray[188] = 67;
        nArray[189] = 199;
        nArray[190] = 252;
        nArray[191] = 4;
        nArray[192] = 81;
        nArray[193] = 153;
        nArray[194] = 109;
        nArray[195] = 13;
        nArray[196] = 250;
        nArray[197] = 223;
        nArray[198] = 126;
        nArray[199] = 36;
        nArray[200] = 59;
        nArray[201] = 171;
        nArray[202] = 206;
        nArray[203] = 17;
        nArray[204] = 143;
        nArray[205] = 78;
        nArray[206] = 183;
        nArray[207] = 235;
        nArray[208] = 60;
        nArray[209] = 129;
        nArray[210] = 148;
        nArray[211] = 247;
        nArray[212] = 185;
        nArray[213] = 19;
        nArray[214] = 44;
        nArray[215] = 211;
        nArray[216] = 231;
        nArray[217] = 110;
        nArray[218] = 196;
        nArray[219] = 3;
        nArray[220] = 86;
        nArray[221] = 68;
        nArray[222] = 127;
        nArray[223] = 169;
        nArray[224] = 42;
        nArray[225] = 187;
        nArray[226] = 193;
        nArray[227] = 83;
        nArray[228] = 220;
        nArray[229] = 11;
        nArray[230] = 157;
        nArray[231] = 108;
        nArray[232] = 49;
        nArray[233] = 116;
        nArray[234] = 246;
        nArray[235] = 70;
        nArray[236] = 172;
        nArray[237] = 137;
        nArray[238] = 20;
        nArray[239] = 225;
        nArray[240] = 22;
        nArray[241] = 58;
        nArray[242] = 105;
        nArray[243] = 9;
        nArray[244] = 112;
        nArray[245] = 182;
        nArray[246] = 208;
        nArray[247] = 237;
        nArray[248] = 204;
        nArray[249] = 66;
        nArray[250] = 152;
        nArray[251] = 164;
        nArray[252] = 40;
        nArray[253] = 92;
        nArray[254] = 248;
        nArray[255] = 134;
        SBOX = nArray;
        C0 = new long[256];
        C1 = new long[256];
        C2 = new long[256];
        C3 = new long[256];
        C4 = new long[256];
        C5 = new long[256];
        C6 = new long[256];
        C7 = new long[256];
        EIGHT = new short[32];
        WhirlpoolDigest.EIGHT[31] = 8;
        int n = 0;
        while (n < 256) {
            int n2 = SBOX[n];
            int n3 = WhirlpoolDigest.mulX(n2);
            int n4 = WhirlpoolDigest.mulX(n3);
            int n5 = n4 ^ n2;
            int n6 = WhirlpoolDigest.mulX(n4);
            int n7 = n6 ^ n2;
            WhirlpoolDigest.C0[n] = WhirlpoolDigest.packIntoLong(n2, n2, n4, n2, n6, n5, n3, n7);
            WhirlpoolDigest.C1[n] = WhirlpoolDigest.packIntoLong(n7, n2, n2, n4, n2, n6, n5, n3);
            WhirlpoolDigest.C2[n] = WhirlpoolDigest.packIntoLong(n3, n7, n2, n2, n4, n2, n6, n5);
            WhirlpoolDigest.C3[n] = WhirlpoolDigest.packIntoLong(n5, n3, n7, n2, n2, n4, n2, n6);
            WhirlpoolDigest.C4[n] = WhirlpoolDigest.packIntoLong(n6, n5, n3, n7, n2, n2, n4, n2);
            WhirlpoolDigest.C5[n] = WhirlpoolDigest.packIntoLong(n2, n6, n5, n3, n7, n2, n2, n4);
            WhirlpoolDigest.C6[n] = WhirlpoolDigest.packIntoLong(n4, n2, n6, n5, n3, n7, n2, n2);
            WhirlpoolDigest.C7[n] = WhirlpoolDigest.packIntoLong(n2, n4, n2, n6, n5, n3, n7, n2);
            ++n;
        }
    }

    public WhirlpoolDigest() {
        this(CryptoServicePurpose.ANY);
    }

    public WhirlpoolDigest(CryptoServicePurpose cryptoServicePurpose) {
        this._rc[0] = 0L;
        int n = 1;
        while (n <= 10) {
            int n2 = 8 * (n - 1);
            this._rc[n] = C0[n2] & 0xFF00000000000000L ^ C1[n2 + 1] & 0xFF000000000000L ^ C2[n2 + 2] & 0xFF0000000000L ^ C3[n2 + 3] & 0xFF00000000L ^ C4[n2 + 4] & 0xFF000000L ^ C5[n2 + 5] & 0xFF0000L ^ C6[n2 + 6] & 0xFF00L ^ C7[n2 + 7] & 0xFFL;
            ++n;
        }
        this.purpose = cryptoServicePurpose;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties(this, this.getDigestSize(), cryptoServicePurpose));
    }

    public WhirlpoolDigest(WhirlpoolDigest whirlpoolDigest) {
        this.purpose = whirlpoolDigest.purpose;
        this.reset(whirlpoolDigest);
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties(this, this.getDigestSize(), this.purpose));
    }

    public Memoable copy() {
        return new WhirlpoolDigest(this);
    }

    private byte[] copyBitLength() {
        byte[] byArray = new byte[32];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(this._bitCount[n] & 0xFF);
            ++n;
        }
        return byArray;
    }

    public int doFinal(byte[] byArray, int n) {
        this.finish();
        Pack.longToBigEndian(this._hash, byArray, n);
        this.reset();
        return this.getDigestSize();
    }

    private void finish() {
        byte[] byArray = this.copyBitLength();
        int n = this._bufferPos++;
        this._buffer[n] = (byte)(this._buffer[n] | 0x80);
        if (this._bufferPos == this._buffer.length) {
            this.processFilledBuffer(this._buffer, 0);
        }
        if (this._bufferPos > 32) {
            while (this._bufferPos != 0) {
                this.update((byte)0);
            }
        }
        while (this._bufferPos <= 32) {
            this.update((byte)0);
        }
        System.arraycopy(byArray, 0, this._buffer, 32, byArray.length);
        this.processFilledBuffer(this._buffer, 0);
    }

    public String getAlgorithmName() {
        return "Whirlpool";
    }

    public int getByteLength() {
        return 64;
    }

    public int getDigestSize() {
        return 64;
    }

    private void increment() {
        int n = 0;
        int n2 = this._bitCount.length - 1;
        while (n2 >= 0) {
            int n3 = (this._bitCount[n2] & 0xFF) + EIGHT[n2] + n;
            n = n3 >>> 8;
            this._bitCount[n2] = (short)(n3 & 0xFF);
            --n2;
        }
    }

    private static int mulX(int n) {
        return n << 1 ^ -(n >>> 7) & 0x11D;
    }

    private static long packIntoLong(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return (long)n << 56 ^ (long)n2 << 48 ^ (long)n3 << 40 ^ (long)n4 << 32 ^ (long)n5 << 24 ^ (long)n6 << 16 ^ (long)n7 << 8 ^ (long)n8;
    }

    protected void processBlock() {
        int n;
        int n2 = 0;
        while (n2 < 8) {
            this._K[n2] = this._hash[n2];
            this._state[n2] = this._block[n2] ^ this._K[n2];
            ++n2;
        }
        int n3 = 1;
        while (n3 <= 10) {
            n = 0;
            while (n < 8) {
                this._L[n] = 0L;
                int n4 = n;
                this._L[n4] = this._L[n4] ^ C0[(int)(this._K[n & 7] >>> 56) & 0xFF];
                int n5 = n;
                this._L[n5] = this._L[n5] ^ C1[(int)(this._K[n - 1 & 7] >>> 48) & 0xFF];
                int n6 = n;
                this._L[n6] = this._L[n6] ^ C2[(int)(this._K[n - 2 & 7] >>> 40) & 0xFF];
                int n7 = n;
                this._L[n7] = this._L[n7] ^ C3[(int)(this._K[n - 3 & 7] >>> 32) & 0xFF];
                int n8 = n;
                this._L[n8] = this._L[n8] ^ C4[(int)(this._K[n - 4 & 7] >>> 24) & 0xFF];
                int n9 = n;
                this._L[n9] = this._L[n9] ^ C5[(int)(this._K[n - 5 & 7] >>> 16) & 0xFF];
                int n10 = n;
                this._L[n10] = this._L[n10] ^ C6[(int)(this._K[n - 6 & 7] >>> 8) & 0xFF];
                int n11 = n;
                this._L[n11] = this._L[n11] ^ C7[(int)this._K[n - 7 & 7] & 0xFF];
                ++n;
            }
            System.arraycopy(this._L, 0, this._K, 0, this._K.length);
            this._K[0] = this._K[0] ^ this._rc[n3];
            int n12 = 0;
            while (n12 < 8) {
                this._L[n12] = this._K[n12];
                int n13 = n12;
                this._L[n13] = this._L[n13] ^ C0[(int)(this._state[n12 & 7] >>> 56) & 0xFF];
                int n14 = n12;
                this._L[n14] = this._L[n14] ^ C1[(int)(this._state[n12 - 1 & 7] >>> 48) & 0xFF];
                int n15 = n12;
                this._L[n15] = this._L[n15] ^ C2[(int)(this._state[n12 - 2 & 7] >>> 40) & 0xFF];
                int n16 = n12;
                this._L[n16] = this._L[n16] ^ C3[(int)(this._state[n12 - 3 & 7] >>> 32) & 0xFF];
                int n17 = n12;
                this._L[n17] = this._L[n17] ^ C4[(int)(this._state[n12 - 4 & 7] >>> 24) & 0xFF];
                int n18 = n12;
                this._L[n18] = this._L[n18] ^ C5[(int)(this._state[n12 - 5 & 7] >>> 16) & 0xFF];
                int n19 = n12;
                this._L[n19] = this._L[n19] ^ C6[(int)(this._state[n12 - 6 & 7] >>> 8) & 0xFF];
                int n20 = n12;
                this._L[n20] = this._L[n20] ^ C7[(int)this._state[n12 - 7 & 7] & 0xFF];
                ++n12;
            }
            System.arraycopy(this._L, 0, this._state, 0, this._state.length);
            ++n3;
        }
        n = 0;
        while (n < 8) {
            int n21 = n;
            this._hash[n21] = this._hash[n21] ^ (this._state[n] ^ this._block[n]);
            ++n;
        }
    }

    private void processFilledBuffer(byte[] byArray, int n) {
        Pack.bigEndianToLong(this._buffer, 0, this._block);
        this.processBlock();
        this._bufferPos = 0;
        Arrays.fill(this._buffer, (byte)0);
    }

    public void reset() {
        this._bufferPos = 0;
        Arrays.fill(this._bitCount, (short)0);
        Arrays.fill(this._buffer, (byte)0);
        Arrays.fill(this._hash, 0L);
        Arrays.fill(this._K, 0L);
        Arrays.fill(this._L, 0L);
        Arrays.fill(this._block, 0L);
        Arrays.fill(this._state, 0L);
    }

    public void reset(Memoable memoable) {
        WhirlpoolDigest whirlpoolDigest = (WhirlpoolDigest)memoable;
        System.arraycopy(whirlpoolDigest._rc, 0, this._rc, 0, this._rc.length);
        System.arraycopy(whirlpoolDigest._buffer, 0, this._buffer, 0, this._buffer.length);
        this._bufferPos = whirlpoolDigest._bufferPos;
        System.arraycopy(whirlpoolDigest._bitCount, 0, this._bitCount, 0, this._bitCount.length);
        System.arraycopy(whirlpoolDigest._hash, 0, this._hash, 0, this._hash.length);
        System.arraycopy(whirlpoolDigest._K, 0, this._K, 0, this._K.length);
        System.arraycopy(whirlpoolDigest._L, 0, this._L, 0, this._L.length);
        System.arraycopy(whirlpoolDigest._block, 0, this._block, 0, this._block.length);
        System.arraycopy(whirlpoolDigest._state, 0, this._state, 0, this._state.length);
    }

    public void update(byte by) {
        this._buffer[this._bufferPos] = by;
        if (++this._bufferPos == this._buffer.length) {
            this.processFilledBuffer(this._buffer, 0);
        }
        this.increment();
    }

    public void update(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
    }
}

