/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.util.io.LimitedBuffer;

public class Prehash
implements Digest {
    private final String algorithmName;
    private final LimitedBuffer buf;

    private Prehash(Digest digest) {
        this.algorithmName = digest.getAlgorithmName();
        this.buf = new LimitedBuffer(digest.getDigestSize());
    }

    public int doFinal(byte[] byArray, int n) {
        try {
            if (this.getDigestSize() != this.buf.size()) {
                throw new IllegalStateException("Incorrect prehash size");
            }
            int n2 = this.buf.copyTo(byArray, n);
            Object var5_4 = null;
            this.reset();
            return n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.reset();
            throw throwable;
        }
    }

    public static Prehash forDigest(Digest digest) {
        return new Prehash(digest);
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int getDigestSize() {
        return this.buf.limit();
    }

    public void reset() {
        this.buf.reset();
    }

    public void update(byte by) {
        this.buf.write(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.buf.write(byArray, n, n2);
    }
}

