/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public class GOST3411Digest
implements ExtendedDigest,
Memoable {
    private static final int DIGEST_LENGTH = 32;
    private final CryptoServicePurpose purpose;
    private byte[] H = new byte[32];
    private byte[] L = new byte[32];
    private byte[] M = new byte[32];
    private byte[] Sum = new byte[32];
    private byte[][] C = new byte[4][32];
    private byte[] xBuf = new byte[32];
    private int xBufOff;
    private long byteCount;
    private BlockCipher cipher = new GOST28147Engine();
    private byte[] sBox;
    private byte[] K = new byte[32];
    byte[] a = new byte[8];
    short[] wS = new short[16];
    short[] w_S = new short[16];
    byte[] S = new byte[32];
    byte[] U = new byte[32];
    byte[] V = new byte[32];
    byte[] W = new byte[32];
    private static final byte[] C2;

    static {
        byte[] byArray = new byte[32];
        byArray[1] = -1;
        byArray[3] = -1;
        byArray[5] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[10] = -1;
        byArray[12] = -1;
        byArray[14] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[20] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[31] = -1;
        C2 = byArray;
    }

    public GOST3411Digest() {
        this(CryptoServicePurpose.ANY);
    }

    public GOST3411Digest(CryptoServicePurpose cryptoServicePurpose) {
        this.purpose = cryptoServicePurpose;
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.sBox = GOST28147Engine.getSBox("D-A");
        this.cipher.init(true, new ParametersWithSBox(null, this.sBox));
        this.reset();
    }

    public GOST3411Digest(GOST3411Digest gOST3411Digest) {
        this.purpose = gOST3411Digest.purpose;
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.reset(gOST3411Digest);
    }

    public GOST3411Digest(byte[] byArray) {
        this(byArray, CryptoServicePurpose.ANY);
    }

    public GOST3411Digest(byte[] byArray, CryptoServicePurpose cryptoServicePurpose) {
        this.purpose = cryptoServicePurpose;
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.sBox = Arrays.clone(byArray);
        this.cipher.init(true, new ParametersWithSBox(null, this.sBox));
        this.reset();
    }

    private byte[] A(byte[] byArray) {
        int n = 0;
        while (n < 8) {
            this.a[n] = (byte)(byArray[n] ^ byArray[n + 8]);
            ++n;
        }
        System.arraycopy(byArray, 8, byArray, 0, 24);
        System.arraycopy(this.a, 0, byArray, 24, 8);
        return byArray;
    }

    private void E(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2) {
        this.cipher.init(true, new KeyParameter(byArray));
        this.cipher.processBlock(byArray3, n2, byArray2, n);
    }

    private byte[] P(byte[] byArray) {
        int n = 0;
        while (n < 8) {
            this.K[4 * n] = byArray[n];
            this.K[1 + 4 * n] = byArray[8 + n];
            this.K[2 + 4 * n] = byArray[16 + n];
            this.K[3 + 4 * n] = byArray[24 + n];
            ++n;
        }
        return this.K;
    }

    public Memoable copy() {
        return new GOST3411Digest(this);
    }

    private void cpyBytesToShort(byte[] byArray, short[] sArray) {
        int n = 0;
        while (n < byArray.length / 2) {
            sArray[n] = (short)(byArray[n * 2 + 1] << 8 & 0xFF00 | byArray[n * 2] & 0xFF);
            ++n;
        }
    }

    private void cpyShortToBytes(short[] sArray, byte[] byArray) {
        int n = 0;
        while (n < byArray.length / 2) {
            byArray[n * 2 + 1] = (byte)(sArray[n] >> 8);
            byArray[n * 2] = (byte)sArray[n];
            ++n;
        }
    }

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, 256, this.purpose);
    }

    public int doFinal(byte[] byArray, int n) {
        this.finish();
        System.arraycopy(this.H, 0, byArray, n, this.H.length);
        this.reset();
        return 32;
    }

    private void finish() {
        Pack.longToLittleEndian(this.byteCount * 8L, this.L, 0);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processBlock(this.L, 0);
        this.processBlock(this.Sum, 0);
    }

    private void fw(byte[] byArray) {
        this.cpyBytesToShort(byArray, this.wS);
        this.w_S[15] = (short)(this.wS[0] ^ this.wS[1] ^ this.wS[2] ^ this.wS[3] ^ this.wS[12] ^ this.wS[15]);
        System.arraycopy(this.wS, 1, this.w_S, 0, 15);
        this.cpyShortToBytes(this.w_S, byArray);
    }

    public String getAlgorithmName() {
        return "GOST3411";
    }

    public int getByteLength() {
        return 32;
    }

    public int getDigestSize() {
        return 32;
    }

    protected void processBlock(byte[] byArray, int n) {
        int n2;
        int n3;
        System.arraycopy(byArray, n, this.M, 0, 32);
        System.arraycopy(this.H, 0, this.U, 0, 32);
        System.arraycopy(this.M, 0, this.V, 0, 32);
        int n4 = 0;
        while (n4 < 32) {
            this.W[n4] = (byte)(this.U[n4] ^ this.V[n4]);
            ++n4;
        }
        this.E(this.P(this.W), this.S, 0, this.H, 0);
        int n5 = 1;
        while (n5 < 4) {
            byte[] byArray2 = this.A(this.U);
            n3 = 0;
            while (n3 < 32) {
                this.U[n3] = (byte)(byArray2[n3] ^ this.C[n5][n3]);
                ++n3;
            }
            this.V = this.A(this.A(this.V));
            n2 = 0;
            while (n2 < 32) {
                this.W[n2] = (byte)(this.U[n2] ^ this.V[n2]);
                ++n2;
            }
            this.E(this.P(this.W), this.S, n5 * 8, this.H, n5 * 8);
            ++n5;
        }
        int n6 = 0;
        while (n6 < 12) {
            this.fw(this.S);
            ++n6;
        }
        n3 = 0;
        while (n3 < 32) {
            this.S[n3] = (byte)(this.S[n3] ^ this.M[n3]);
            ++n3;
        }
        this.fw(this.S);
        n2 = 0;
        while (n2 < 32) {
            this.S[n2] = (byte)(this.H[n2] ^ this.S[n2]);
            ++n2;
        }
        int n7 = 0;
        while (n7 < 61) {
            this.fw(this.S);
            ++n7;
        }
        System.arraycopy(this.S, 0, this.H, 0, this.H.length);
    }

    public void reset() {
        this.byteCount = 0L;
        this.xBufOff = 0;
        int n = 0;
        while (n < this.H.length) {
            this.H[n] = 0;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.L.length) {
            this.L[n2] = 0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.M.length) {
            this.M[n3] = 0;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.C[1].length) {
            this.C[1][n4] = 0;
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.C[3].length) {
            this.C[3][n5] = 0;
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.Sum.length) {
            this.Sum[n6] = 0;
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.xBuf.length) {
            this.xBuf[n7] = 0;
            ++n7;
        }
        System.arraycopy(C2, 0, this.C[2], 0, C2.length);
    }

    public void reset(Memoable memoable) {
        GOST3411Digest gOST3411Digest = (GOST3411Digest)memoable;
        this.sBox = gOST3411Digest.sBox;
        this.cipher.init(true, new ParametersWithSBox(null, this.sBox));
        this.reset();
        System.arraycopy(gOST3411Digest.H, 0, this.H, 0, gOST3411Digest.H.length);
        System.arraycopy(gOST3411Digest.L, 0, this.L, 0, gOST3411Digest.L.length);
        System.arraycopy(gOST3411Digest.M, 0, this.M, 0, gOST3411Digest.M.length);
        System.arraycopy(gOST3411Digest.Sum, 0, this.Sum, 0, gOST3411Digest.Sum.length);
        System.arraycopy(gOST3411Digest.C[1], 0, this.C[1], 0, gOST3411Digest.C[1].length);
        System.arraycopy(gOST3411Digest.C[2], 0, this.C[2], 0, gOST3411Digest.C[2].length);
        System.arraycopy(gOST3411Digest.C[3], 0, this.C[3], 0, gOST3411Digest.C[3].length);
        System.arraycopy(gOST3411Digest.xBuf, 0, this.xBuf, 0, gOST3411Digest.xBuf.length);
        this.xBufOff = gOST3411Digest.xBufOff;
        this.byteCount = gOST3411Digest.byteCount;
    }

    private void sumByteArray(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 != this.Sum.length) {
            int n3 = (this.Sum[n2] & 0xFF) + (byArray[n2] & 0xFF) + n;
            this.Sum[n2] = (byte)n3;
            n = n3 >>> 8;
            ++n2;
        }
    }

    public void update(byte by) {
        this.xBuf[this.xBufOff++] = by;
        if (this.xBufOff == this.xBuf.length) {
            this.sumByteArray(this.xBuf);
            this.processBlock(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    public void update(byte[] byArray, int n, int n2) {
        while (this.xBufOff != 0 && n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
        while (n2 >= this.xBuf.length) {
            System.arraycopy(byArray, n, this.xBuf, 0, this.xBuf.length);
            this.sumByteArray(this.xBuf);
            this.processBlock(this.xBuf, 0);
            n += this.xBuf.length;
            n2 -= this.xBuf.length;
            this.byteCount += (long)this.xBuf.length;
        }
        while (n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
    }
}

