/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.CharToByteConverter;
import org.bouncycastle.crypto.PBEParametersGenerator;

public final class PasswordConverter {
    public static final CharToByteConverter ASCII = new CharToByteConverter(){

        public byte[] convert(char[] cArray) {
            return PBEParametersGenerator.PKCS5PasswordToBytes(cArray);
        }

        public String getType() {
            return "ASCII";
        }
    };
    public static final CharToByteConverter UTF8 = new CharToByteConverter(){

        public byte[] convert(char[] cArray) {
            return PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(cArray);
        }

        public String getType() {
            return "UTF8";
        }
    };
    public static final CharToByteConverter PKCS12 = new CharToByteConverter(){

        public byte[] convert(char[] cArray) {
            return PBEParametersGenerator.PKCS12PasswordToBytes(cArray);
        }

        public String getType() {
            return "PKCS12";
        }
    };
}

