/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.StreamCipher;

public class DefaultBufferedBlockCipher
extends BufferedBlockCipher {
    protected byte[] buf;
    protected int bufOff;
    protected boolean forEncryption;
    protected BlockCipher cipher;
    protected MultiBlockCipher mbCipher;
    protected boolean partialBlockOkay;
    protected boolean pgpCFB;

    protected DefaultBufferedBlockCipher() {
    }

    public DefaultBufferedBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        if (blockCipher instanceof MultiBlockCipher) {
            this.mbCipher = (MultiBlockCipher)blockCipher;
            this.buf = new byte[this.mbCipher.getMultiBlockSize()];
        } else {
            this.mbCipher = null;
            this.buf = new byte[blockCipher.getBlockSize()];
        }
        this.bufOff = 0;
        String string = blockCipher.getAlgorithmName();
        int n = string.indexOf(47) + 1;
        boolean bl = this.pgpCFB = n > 0 && string.startsWith("PGP", n);
        this.partialBlockOkay = this.pgpCFB || blockCipher instanceof StreamCipher ? true : n > 0 && string.startsWith("OpenPGP", n);
    }

    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        try {
            int n2 = 0;
            if (n + this.bufOff > byArray.length) {
                throw new OutputLengthException("output buffer too short for doFinal()");
            }
            if (this.bufOff != 0) {
                if (!this.partialBlockOkay) {
                    throw new DataLengthException("data not block size aligned");
                }
                this.cipher.processBlock(this.buf, 0, this.buf, 0);
                n2 = this.bufOff;
                this.bufOff = 0;
                System.arraycopy(this.buf, 0, byArray, n, n2);
            }
            int n3 = n2;
            Object var5_5 = null;
            this.reset();
            return n3;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.reset();
            throw throwable;
        }
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int getOutputSize(int n) {
        if (this.pgpCFB && this.forEncryption) {
            return n + this.bufOff + (this.cipher.getBlockSize() + 2);
        }
        return n + this.bufOff;
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public int getUpdateOutputSize(int n) {
        int n2 = n + this.bufOff;
        int n3 = this.pgpCFB ? (this.forEncryption ? n2 % this.buf.length - (this.cipher.getBlockSize() + 2) : n2 % this.buf.length) : n2 % this.buf.length;
        return n2 - n3;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        this.reset();
        this.cipher.init(bl, cipherParameters);
    }

    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException, IllegalStateException {
        int n2 = 0;
        this.buf[this.bufOff++] = by;
        if (this.bufOff == this.buf.length) {
            n2 = this.cipher.processBlock(this.buf, 0, byArray, n);
            this.bufOff = 0;
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    public int processBytes(byte[] var1_1, int var2_2, int var3_3, byte[] var4_4, int var5_5) throws DataLengthException, IllegalStateException {
        block7: {
            if (var3_3 < 0) {
                throw new IllegalArgumentException("Can't have a negative input length!");
            }
            var6_6 = this.getBlockSize();
            var7_7 = this.getUpdateOutputSize(var3_3);
            if (var7_7 > 0 && var5_5 + var7_7 > var4_4.length) {
                throw new OutputLengthException("output buffer too short");
            }
            var8_8 = 0;
            var9_9 = this.buf.length - this.bufOff;
            if (var3_3 <= var9_9) break block7;
            System.arraycopy(var1_1, var2_2, this.buf, this.bufOff, var9_9);
            var8_8 += this.cipher.processBlock(this.buf, 0, var4_4, var5_5);
            this.bufOff = 0;
            var3_3 -= var9_9;
            var2_2 += var9_9;
            if (this.mbCipher == null) ** GOTO lbl26
            var10_10 = var3_3 / this.mbCipher.getMultiBlockSize();
            if (var10_10 <= 0) break block7;
            var8_8 += this.mbCipher.processBlocks(var1_1, var2_2, var10_10, var4_4, var5_5 + var8_8);
            var11_11 = var10_10 * this.mbCipher.getMultiBlockSize();
            var3_3 -= var11_11;
            var2_2 += var11_11;
            break block7;
lbl-1000:
            // 1 sources

            {
                var8_8 += this.cipher.processBlock(var1_1, var2_2, var4_4, var5_5 + var8_8);
                var3_3 -= var6_6;
                var2_2 += var6_6;
lbl26:
                // 2 sources

                ** while (var3_3 > this.buf.length)
            }
        }
        System.arraycopy(var1_1, var2_2, this.buf, this.bufOff, var3_3);
        this.bufOff += var3_3;
        if (this.bufOff == this.buf.length) {
            var8_8 += this.cipher.processBlock(this.buf, 0, var4_4, var5_5 + var8_8);
            this.bufOff = 0;
        }
        return var8_8;
    }

    public void reset() {
        int n = 0;
        while (n < this.buf.length) {
            this.buf[n] = 0;
            ++n;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

