/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x500.style;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public abstract class AbstractX500NameStyle
implements X500NameStyle {
    public boolean areEqual(X500Name x500Name, X500Name x500Name2) {
        if (x500Name.size() != x500Name2.size()) {
            return false;
        }
        RDN[] rDNArray = x500Name.getRDNs();
        RDN[] rDNArray2 = x500Name2.getRDNs();
        boolean bl = false;
        AttributeTypeAndValue attributeTypeAndValue = rDNArray[0].getFirst();
        AttributeTypeAndValue attributeTypeAndValue2 = rDNArray2[0].getFirst();
        if (attributeTypeAndValue != null && attributeTypeAndValue2 != null) {
            bl = attributeTypeAndValue.getType().equals(attributeTypeAndValue2.getType()) ^ true;
        }
        int n = 0;
        while (n != rDNArray.length) {
            if (!this.foundMatch(bl, rDNArray[n], rDNArray2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public abstract ASN1ObjectIdentifier attrNameToOID(String var1);

    private int calcHashCode(ASN1Encodable aSN1Encodable) {
        String string = IETFUtils.canonicalString(aSN1Encodable);
        return string.hashCode();
    }

    public int calculateHashCode(X500Name x500Name) {
        int n = 0;
        RDN[] rDNArray = x500Name.getRDNs();
        int n2 = 0;
        while (n2 != rDNArray.length) {
            if (rDNArray[n2].isMultiValued()) {
                AttributeTypeAndValue[] attributeTypeAndValueArray = rDNArray[n2].getTypesAndValues();
                int n3 = 0;
                while (n3 != attributeTypeAndValueArray.length) {
                    n ^= attributeTypeAndValueArray[n3].getType().hashCode();
                    n ^= this.calcHashCode(attributeTypeAndValueArray[n3].getValue());
                    ++n3;
                }
            } else {
                n ^= rDNArray[n2].getFirst().getType().hashCode();
                n ^= this.calcHashCode(rDNArray[n2].getFirst().getValue());
            }
            ++n2;
        }
        return n;
    }

    public static Hashtable copyHashTable(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable2.put(k, hashtable.get(k));
        }
        return hashtable2;
    }

    protected ASN1Encodable encodeStringValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        return new DERUTF8String(string);
    }

    private boolean foundMatch(boolean bl, RDN rDN, RDN[] rDNArray) {
        if (bl) {
            int n = rDNArray.length - 1;
            while (n >= 0) {
                if (rDNArray[n] != null && this.rdnAreEqual(rDN, rDNArray[n])) {
                    rDNArray[n] = null;
                    return true;
                }
                --n;
            }
        } else {
            int n = 0;
            while (n != rDNArray.length) {
                if (rDNArray[n] != null && this.rdnAreEqual(rDN, rDNArray[n])) {
                    rDNArray[n] = null;
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public abstract RDN[] fromString(String var1);

    public abstract String[] oidToAttrNames(ASN1ObjectIdentifier var1);

    public abstract String oidToDisplayName(ASN1ObjectIdentifier var1);

    protected boolean rdnAreEqual(RDN rDN, RDN rDN2) {
        return IETFUtils.rDNAreEqual(rDN, rDN2);
    }

    public ASN1Encodable stringToValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        if (string.length() != 0 && string.charAt(0) == '#') {
            try {
                return IETFUtils.valueFromHexString(string, 1);
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("can't recode value for oid " + aSN1ObjectIdentifier.getId());
            }
        }
        if (string.length() != 0 && string.charAt(0) == '\\') {
            string = string.substring(1);
        }
        return this.encodeStringValue(aSN1ObjectIdentifier, string);
    }

    public abstract String toString(X500Name var1);
}

