/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x500;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class X500Name
extends ASN1Object
implements ASN1Choice {
    private static X500NameStyle defaultStyle = BCStyle.INSTANCE;
    private boolean isHashCodeCalculated;
    private int hashCodeValue;
    private X500NameStyle style;
    private RDN[] rdns;
    private DERSequence rdnSeq;

    public X500Name(String string) {
        this(defaultStyle, string);
    }

    private X500Name(ASN1Sequence aSN1Sequence) {
        this(defaultStyle, aSN1Sequence);
    }

    public X500Name(X500NameStyle x500NameStyle, String string) {
        this(x500NameStyle.fromString(string));
        this.style = x500NameStyle;
    }

    private X500Name(X500NameStyle x500NameStyle, ASN1Sequence aSN1Sequence) {
        int n = aSN1Sequence.size();
        this.style = x500NameStyle;
        this.rdns = new RDN[n];
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(n2);
            RDN rDN = RDN.getInstance(aSN1Encodable);
            bl &= rDN == aSN1Encodable;
            this.rdns[n2] = rDN;
            ++n2;
        }
        this.rdnSeq = bl ? DERSequence.convert(aSN1Sequence) : new DERSequence(this.rdns);
    }

    public X500Name(X500NameStyle x500NameStyle, X500Name x500Name) {
        this.style = x500NameStyle;
        this.rdns = x500Name.rdns;
        this.rdnSeq = x500Name.rdnSeq;
    }

    public X500Name(X500NameStyle x500NameStyle, RDN[] rDNArray) {
        this.style = x500NameStyle;
        this.rdns = (RDN[])rDNArray.clone();
        this.rdnSeq = new DERSequence(this.rdns);
    }

    public X500Name(RDN[] rDNArray) {
        this(defaultStyle, rDNArray);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X500Name) && !(object instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
        if (this.toASN1Primitive().equals(aSN1Primitive)) {
            return true;
        }
        try {
            return this.style.areEqual(this, X500Name.getInstance(object));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ASN1ObjectIdentifier[] getAttributeTypes() {
        Object object;
        int n = this.rdns.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            object = this.rdns[n3];
            n2 += ((RDN)object).size();
            ++n3;
        }
        object = new ASN1ObjectIdentifier[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            RDN rDN = this.rdns[n5];
            n4 += rDN.collectAttributeTypes((ASN1ObjectIdentifier[])object, n4);
            ++n5;
        }
        return object;
    }

    public static X500NameStyle getDefaultStyle() {
        return defaultStyle;
    }

    public static X500Name getInstance(Object object) {
        if (object instanceof X500Name) {
            return (X500Name)object;
        }
        if (object != null) {
            return new X500Name(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static X500Name getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return X500Name.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, true));
    }

    public static X500Name getInstance(X500NameStyle x500NameStyle, Object object) {
        if (object instanceof X500Name) {
            return new X500Name(x500NameStyle, (X500Name)object);
        }
        if (object != null) {
            return new X500Name(x500NameStyle, ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RDN[] getRDNs() {
        return (RDN[])this.rdns.clone();
    }

    public RDN[] getRDNs(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        RDN[] rDNArray;
        RDN[] rDNArray2 = new RDN[this.rdns.length];
        int n = 0;
        int n2 = 0;
        while (n2 != this.rdns.length) {
            rDNArray = this.rdns[n2];
            if (rDNArray.containsAttributeType(aSN1ObjectIdentifier)) {
                rDNArray2[n++] = rDNArray;
            }
            ++n2;
        }
        if (n < rDNArray2.length) {
            rDNArray = new RDN[n];
            System.arraycopy(rDNArray2, 0, rDNArray, 0, rDNArray.length);
            rDNArray2 = rDNArray;
        }
        return rDNArray2;
    }

    public int hashCode() {
        if (this.isHashCodeCalculated) {
            return this.hashCodeValue;
        }
        this.isHashCodeCalculated = true;
        this.hashCodeValue = this.style.calculateHashCode(this);
        return this.hashCodeValue;
    }

    public static void setDefaultStyle(X500NameStyle x500NameStyle) {
        if (x500NameStyle == null) {
            throw new NullPointerException("cannot set style to null");
        }
        defaultStyle = x500NameStyle;
    }

    public int size() {
        return this.rdns.length;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.rdnSeq;
    }

    public String toString() {
        return this.style.toString(this);
    }
}

