/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class X9Test
extends SimpleTest {
    private byte[] namedPub = Base64.decode("MDcwEwYHKoZIzj0CAQYIKoZIzj0DAQEDIAADG5xRI+Iki/JrvL20hoDUa7Cggzorv5B9yyqSMjYu");
    private byte[] expPub = Base64.decode("MIH8MIHXBgcqhkjOPQIBMIHLAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVECAQEDIAADG5xRI+Iki/JrvL20hoDUa7Cggzorv5B9yyqSMjYu");
    private byte[] namedPriv = Base64.decode("MDkCAQAwEwYHKoZIzj0CAQYIKoZIzj0DAQEEHzAdAgEBBBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAo=");
    private byte[] expPriv = Base64.decode("MIIBBAIBADCB1wYHKoZIzj0CATCBywIBATApBgcqhkjOPQEBAh5///////////////9///////+AAAAAAAB///////8wVwQef///////////////f///////gAAAAAAAf//////8BB4lVwX6KjBmVLH0ywPWp1CjDCUBAtSYhxfZuhWrbT4DFQB9c3QWj/40cbYKhXaGoZR107+i/wQfA2doro4Yu5LPzwBclJqixtlIU9DmYLv4VLHJUF/pWgIef///////////////f///l13rQbOmBXw8QyFGUmVRAgEBBCUwIwIBAQQeAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAU");

    private void encodePrivateKey() throws Exception {
        ASN1Primitive aSN1Primitive;
        X962Parameters x962Parameters = new X962Parameters(X9ObjectIdentifiers.prime192v1);
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime192v1);
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), new ECPrivateKey(x9ECParameters.getN().bitLength(), BigInteger.valueOf(10L)));
        if (!this.areEqual(privateKeyInfo.getEncoded(), this.namedPriv)) {
            this.fail("failed private named generation");
        }
        if (!privateKeyInfo.equals(aSN1Primitive = ASN1Primitive.fromByteArray(this.namedPriv))) {
            this.fail("failed private named equality");
        }
        if (!this.areEqual((privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters = new X962Parameters(x9ECParameters = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3))), new ECPrivateKey(x9ECParameters.getN().bitLength(), BigInteger.valueOf(20L)))).getEncoded(), this.expPriv)) {
            this.fail("failed private explicit generation");
        }
        if (!privateKeyInfo.equals(aSN1Primitive = ASN1Primitive.fromByteArray(this.expPriv))) {
            this.fail("failed private explicit equality");
        }
    }

    private void encodePublicKey() throws Exception {
        ASN1Primitive aSN1Primitive;
        ECPoint eCPoint;
        DEROctetString dEROctetString;
        X962Parameters x962Parameters;
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        X9IntegerConverter x9IntegerConverter = new X9IntegerConverter();
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        if (x9IntegerConverter.getByteLength(x9ECParameters.getCurve()) != 30) {
            this.fail("wrong byte length reported for curve");
        }
        if (x9ECParameters.getCurve().getFieldSize() != 239) {
            this.fail("wrong field size reported for curve");
        }
        if (!this.areEqual((subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters = new X962Parameters(X9ObjectIdentifiers.prime192v1)), (dEROctetString = new DEROctetString((eCPoint = x9ECParameters.getG().multiply(BigInteger.valueOf(100L))).getEncoded(true))).getOctets())).getEncoded(), this.namedPub)) {
            this.fail("failed public named generation");
        }
        X9ECPoint x9ECPoint = new X9ECPoint(x9ECParameters.getCurve(), dEROctetString);
        if (!Arrays.areEqual(dEROctetString.getOctets(), x9ECPoint.getPointEncoding())) {
            this.fail("point encoding not preserved");
        }
        if (!subjectPublicKeyInfo.equals(aSN1Primitive = ASN1Primitive.fromByteArray(this.namedPub))) {
            this.fail("failed public named equality");
        }
        if (!this.areEqual((subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters = new X962Parameters(x9ECParameters)), dEROctetString.getOctets())).getEncoded(), this.expPub)) {
            this.fail("failed public explicit generation");
        }
        if (!subjectPublicKeyInfo.equals(aSN1Primitive = ASN1Primitive.fromByteArray(this.expPub))) {
            this.fail("failed public explicit equality");
        }
    }

    public String getName() {
        return "X9";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new X9Test());
    }

    public void performTest() throws Exception {
        this.encodePublicKey();
        this.encodePrivateKey();
    }
}

