/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AltSignatureAlgorithm;
import org.bouncycastle.asn1.x509.AltSignatureValue;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.SubjectAltPublicKeyInfo;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class X509AltTest
extends SimpleTest {
    public String getName() {
        return "X509Alt";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new X509AltTest());
    }

    public void performTest() throws Exception {
        SubjectAltPublicKeyInfo subjectAltPublicKeyInfo = new SubjectAltPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new DERBitString(Hex.decode("0102030405060708090807060504030201")));
        AltSignatureValue altSignatureValue = new AltSignatureValue(Hex.decode("0102030405060708090807060504030201"));
        AltSignatureAlgorithm altSignatureAlgorithm = new AltSignatureAlgorithm(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, DERNull.INSTANCE));
        AltSignatureAlgorithm altSignatureAlgorithm2 = new AltSignatureAlgorithm(PKCSObjectIdentifiers.md5WithRSAEncryption, DERNull.INSTANCE);
        this.isEquals(altSignatureAlgorithm, altSignatureAlgorithm2);
        ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
        extensionsGenerator.addExtension(Extension.subjectAltPublicKeyInfo, false, subjectAltPublicKeyInfo);
        extensionsGenerator.addExtension(Extension.altSignatureAlgorithm, false, altSignatureAlgorithm);
        extensionsGenerator.addExtension(Extension.altSignatureValue, false, altSignatureValue);
        Extensions extensions = extensionsGenerator.generate();
        this.isEquals(subjectAltPublicKeyInfo, SubjectAltPublicKeyInfo.fromExtensions(extensions));
        this.isEquals(altSignatureAlgorithm, AltSignatureAlgorithm.fromExtensions(extensions));
        this.isEquals(altSignatureValue, AltSignatureValue.fromExtensions(extensions));
        this.isEquals(subjectAltPublicKeyInfo, SubjectAltPublicKeyInfo.getInstance(subjectAltPublicKeyInfo.getEncoded()));
        this.isEquals(altSignatureAlgorithm, AltSignatureAlgorithm.getInstance(altSignatureAlgorithm.getEncoded()));
        this.isEquals(altSignatureValue, AltSignatureValue.getInstance(altSignatureValue.getEncoded()));
        this.isEquals(subjectAltPublicKeyInfo, SubjectAltPublicKeyInfo.getInstance(new DERTaggedObject(1, subjectAltPublicKeyInfo), true));
        this.isEquals(altSignatureAlgorithm, AltSignatureAlgorithm.getInstance(new DERTaggedObject(1, altSignatureAlgorithm), true));
        this.isEquals(altSignatureValue, AltSignatureValue.getInstance(new DERTaggedObject(1, altSignatureValue), true));
    }
}

