/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.test.SimpleTest;

public class SetTest
extends SimpleTest {
    private void checkedSortedSet(int n, ASN1Set aSN1Set) {
        if (aSN1Set.getObjectAt(0) instanceof ASN1Boolean && aSN1Set.getObjectAt(1) instanceof ASN1Integer && aSN1Set.getObjectAt(2) instanceof DERBitString && aSN1Set.getObjectAt(3) instanceof DEROctetString) {
            return;
        }
        this.fail("sorting failed on attempt: " + n);
    }

    public String getName() {
        return "Set";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new SetTest());
    }

    public void performTest() throws Exception {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        byte[] byArray = new byte[10];
        aSN1EncodableVector.add(new DEROctetString(byArray));
        aSN1EncodableVector.add(new DERBitString(byArray));
        aSN1EncodableVector.add(new ASN1Integer(100L));
        aSN1EncodableVector.add(ASN1Boolean.getInstance(true));
        this.checkedSortedSet(0, new DERSet(aSN1EncodableVector));
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(100L));
        aSN1EncodableVector.add(ASN1Boolean.getInstance(true));
        aSN1EncodableVector.add(new DEROctetString(byArray));
        aSN1EncodableVector.add(new DERBitString(byArray));
        this.checkedSortedSet(1, new DERSet(aSN1EncodableVector));
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(ASN1Boolean.getInstance(true));
        aSN1EncodableVector.add(new DEROctetString(byArray));
        aSN1EncodableVector.add(new DERBitString(byArray));
        aSN1EncodableVector.add(new ASN1Integer(100L));
        this.checkedSortedSet(2, new DERSet(aSN1EncodableVector));
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERBitString(byArray));
        aSN1EncodableVector.add(new DEROctetString(byArray));
        aSN1EncodableVector.add(new ASN1Integer(100L));
        aSN1EncodableVector.add(ASN1Boolean.getInstance(true));
        this.checkedSortedSet(3, new DERSet(aSN1EncodableVector));
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DEROctetString(byArray));
        aSN1EncodableVector.add(new DERBitString(byArray));
        aSN1EncodableVector.add(new ASN1Integer(100L));
        aSN1EncodableVector.add(ASN1Boolean.getInstance(true));
        ASN1Set aSN1Set = new BERSet(aSN1EncodableVector);
        if (!(aSN1Set.getObjectAt(0) instanceof DEROctetString)) {
            this.fail("BER set sort order changed.");
        }
        ASN1TaggedObject aSN1TaggedObject = new DERTaggedObject(false, 1, (ASN1Encodable)new DERSequence(aSN1EncodableVector));
        aSN1Set = ASN1Set.getInstance(aSN1TaggedObject = (ASN1TaggedObject)ASN1Primitive.fromByteArray(aSN1TaggedObject.getEncoded("DER")), false);
        if (aSN1Set.getObjectAt(0) instanceof ASN1Boolean) {
            this.fail("sorted when shouldn't be.");
        }
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(ASN1Boolean.getInstance(true));
        aSN1EncodableVector.add(ASN1Boolean.getInstance(true));
        aSN1EncodableVector.add(ASN1Boolean.getInstance(true));
        aSN1Set = new DERSet(aSN1EncodableVector);
    }
}

