/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1RelativeOID;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class RelativeOIDTest
extends SimpleTest {
    private static final byte[] req1 = Hex.decode("0D03813403");
    private static final byte[] req2 = Hex.decode("0D082A36FFFFFFDD6311");

    private void branchCheck(String string, String string2) {
        String string3;
        String string4 = String.valueOf(string) + "." + string2;
        if (!string4.equals(string3 = new ASN1RelativeOID(string).branch(string2).getId())) {
            this.fail("failed 'branch' check for " + string + "/" + string2);
        }
    }

    private void checkInvalid(String string) {
        this.isTrue(ASN1RelativeOID.tryFromID(string) == null);
        try {
            new ASN1RelativeOID(string);
            this.fail("failed to catch bad relative oid: " + string);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private void checkValid(String string) throws IOException {
        this.isTrue(ASN1RelativeOID.tryFromID(string) != null);
        ASN1RelativeOID aSN1RelativeOID = new ASN1RelativeOID(string);
        aSN1RelativeOID = (ASN1RelativeOID)ASN1Primitive.fromByteArray(aSN1RelativeOID.getEncoded());
        if (!aSN1RelativeOID.getId().equals(string)) {
            this.fail("failed relative oid check for " + string);
        }
    }

    public String getName() {
        return "RelativeOID";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new RelativeOIDTest());
    }

    public void performTest() throws IOException {
        this.recodeCheck("180.3", req1);
        this.recodeCheck("42.54.34359733987.17", req2);
        this.checkValid("0");
        this.checkValid("37");
        this.checkValid("0.1");
        this.checkValid("1.0");
        this.checkValid("1.0.2");
        this.checkValid("1.0.20");
        this.checkValid("1.0.200");
        this.checkValid("1.1.127.32512.8323072.2130706432.545460846592.139637976727552.35747322042253312.9151314442816847872");
        this.checkValid("1.2.123.12345678901.1.1.1");
        this.checkValid("2.25.196556539987194312349856245628873852187.1");
        this.checkValid("3.1");
        this.checkValid("37.196556539987194312349856245628873852187.100");
        this.checkValid("192.168.1.1");
        this.checkInvalid("00");
        this.checkInvalid("0.01");
        this.checkInvalid("00.1");
        this.checkInvalid("1.00.2");
        this.checkInvalid("1.0.02");
        this.checkInvalid("1.2.00");
        this.checkInvalid(".1");
        this.checkInvalid("..1");
        this.checkInvalid("3..1");
        this.checkInvalid(".123452");
        this.checkInvalid("1.");
        this.checkInvalid("1.345.23.34..234");
        this.checkInvalid("1.345.23.34.234.");
        this.checkInvalid(".12.345.77.234");
        this.checkInvalid(".12.345.77.234.");
        this.checkInvalid("1.2.3.4.A.5");
        this.checkInvalid("1,2");
        this.branchCheck("1.1", "2.2");
    }

    private void recodeCheck(String string, byte[] byArray) throws IOException {
        byte[] byArray2;
        ASN1RelativeOID aSN1RelativeOID = new ASN1RelativeOID(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        ASN1RelativeOID aSN1RelativeOID2 = (ASN1RelativeOID)aSN1InputStream.readObject();
        if (!aSN1RelativeOID.equals(aSN1RelativeOID2)) {
            this.fail("relative OID didn't match", aSN1RelativeOID, aSN1RelativeOID2);
        }
        if ((byArray2 = aSN1RelativeOID.getEncoded("DER")).length != byArray.length) {
            this.fail("failed length test");
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray2[n] != byArray[n]) {
                this.fail("failed comparison test", new String(Hex.encode(byArray)), new String(Hex.encode(byArray2)));
            }
            ++n;
        }
    }
}

